/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.vrtest.CommonImpl;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestClassFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestDriverFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestDriverShim;
import com.novell.nds.dirxml.driver.vrtest.VRTestModifiedObject;
import com.novell.nds.dirxml.driver.vrtest.VRTestNotification;
import com.novell.nds.dirxml.driver.vrtest.VRTestObject;
import com.novell.nds.dirxml.driver.vrtest.VRTestPathParser;
import com.novell.nds.dirxml.driver.vrtest.VRTestRootObject;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.StateParent;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAddAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSAddElement;
import com.novell.nds.dirxml.driver.xds.XDSAddValueElement;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSDeleteElement;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSModifyAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyElement;
import com.novell.nds.dirxml.driver.xds.XDSMoveElement;
import com.novell.nds.dirxml.driver.xds.XDSParentElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryDocument;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSRemoveValueElement;
import com.novell.nds.dirxml.driver.xds.XDSRenameElement;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import com.novell.nds.dirxml.vrtest.VRTestAction;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestEventType;
import com.novell.nds.dirxml.vrtest.VRTestException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class VRTestPublicationShim
extends CommonImpl
implements PublicationShim,
XmlQueryProcessor,
VRTestConstants {
    private static final String TRACE_SUFFIX = "Publisher";
    private static final int NO_OF_PARAMS = 5;
    private static final String TAG_ALLOW_LOOPBACK = "allow-loopback";
    private static final String TAG_USE_FILTER = "use-filter";
    private static final String TAG_SAVE_STATE = "save-state-each-event";
    private static final String TAG_MODIFY_ALL = "modify-all";
    private static final int RECONNECT_WAIT_MILLIS = 10000;
    private boolean running;
    private VRTestDriverFilter filter;
    private Map pubParams;
    private VRTestDriverShim driver;
    private Thread thread;
    private boolean allowLoopBack;
    private boolean useFilter;
    private boolean saveState;
    private boolean modifyAll;

    public VRTestPublicationShim(VRTestDriverShim someDriver) {
        this.driver = someDriver;
        this.setAPI(this.driver.getAPI());
        this.setDriverRDN(this.driver.getDriverRDN());
        this.setDriverParams(this.driver.getDriverParams());
        this.setTrace(TRACE_SUFFIX);
        this.setPubParams();
        this.running = false;
        this.thread = null;
    }

    private void setPubParams() {
        this.pubParams = new HashMap(5);
        Parameter param = new Parameter(TAG_ALLOW_LOOPBACK, "no", DataType.BOOLEAN);
        this.pubParams.put(param.tagName(), param);
        param = new Parameter(TAG_USE_FILTER, "yes", DataType.BOOLEAN);
        this.pubParams.put(param.tagName(), param);
        param = new Parameter(TAG_SAVE_STATE, "no", DataType.BOOLEAN);
        this.pubParams.put(param.tagName(), param);
        param = new Parameter(TAG_MODIFY_ALL, "no", DataType.BOOLEAN);
        this.pubParams.put(param.tagName(), param);
        param = new Parameter("run-count", "0", DataType.LONG);
        param.add((Constraint)RangeConstraint.POSITIVE);
        this.pubParams.put(param.tagName(), param);
    }

    public XmlDocument init(XmlDocument initXML) {
        this.trace.trace("init", 1);
        XDSResultDocument result = this.newResultDoc();
        try {
            XDSInitDocument init = new XDSInitDocument(initXML);
            init.parameters(this.pubParams);
            Parameter param = (Parameter)this.pubParams.get("run-count");
            this.setRunCount(param.toLong());
            param.overrideValue(String.valueOf(this.getRunCount()));
            this.allowLoopBack = ((Parameter)this.pubParams.get(TAG_ALLOW_LOOPBACK)).toBoolean();
            this.useFilter = ((Parameter)this.pubParams.get(TAG_USE_FILTER)).toBoolean();
            this.saveState = ((Parameter)this.pubParams.get(TAG_SAVE_STATE)).toBoolean();
            this.modifyAll = ((Parameter)this.pubParams.get(TAG_MODIFY_ALL)).toBoolean();
            this.filter = new VRTestDriverFilter(init.extractInitParamsElement().extractDriverFilterElement().domElement());
            this.appendStateInfo((StateParent)result.appendInitParamsElement().appendPublisherStateElement());
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSStatusElement status = XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
            status.parametersAppend(this.pubParams);
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)XDSUtil.appendStackTrace((Exception)e), (XmlDocument)initXML);
        }
        return result.toXML();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlDocument start(XmlCommandProcessor processor) {
        this.thread = Thread.currentThread();
        XDSResultDocument resultDoc = this.newResultDoc();
        XDSStatusElement status = resultDoc.appendStatusElement();
        try {
            block5: {
                try {
                    this.setupInitialConnection(processor, status);
                    if (!this.connected) break block5;
                    this.running = true;
                    this.publish(processor);
                    status.setLevel(StatusLevel.SUCCESS);
                    status.setType(StatusType.DRIVER_STATUS);
                }
                catch (InterruptedException ie) {
                    status.setLevel(StatusLevel.SUCCESS);
                    status.setType(StatusType.DRIVER_STATUS);
                    Object var7_5 = null;
                    this.disconnect();
                    return resultDoc.toXML();
                }
                catch (Exception e) {
                    status.setLevel(StatusLevel.FATAL);
                    status.setType(StatusType.DRIVER_STATUS);
                    status.descriptionAppend(e.getMessage());
                    status.exceptionAppend(e, true);
                    Object var7_6 = null;
                    this.disconnect();
                    return resultDoc.toXML();
                }
            }
            Object var7_4 = null;
            this.disconnect();
            return resultDoc.toXML();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.disconnect();
            throw throwable;
        }
    }

    private void setPublicationProperties() throws VRTestException {
        this.filter.setProperties(this.api.getSchema());
        this.api.setQueryProcessor(this);
        this.api.setLoopBack(this.allowLoopBack);
    }

    private void setupInitialConnection(XmlCommandProcessor processor, XDSStatusElement status) throws InterruptedException, Exception {
        int retries = 0;
        while (!this.connected) {
            try {
                this.connect();
                this.setPublicationProperties();
                this.connected = true;
                if (retries <= 0) break;
                XDSCommandDocument notifyDoc = this.newCommandDoc();
                status = notifyDoc.appendStatusElement();
                status.setLevel(StatusLevel.SUCCESS);
                status.setType(StatusType.APP_CONNECTION);
                status.appendText("Connected.");
                processor.execute(notifyDoc.toXML(), (XmlQueryProcessor)this);
                break;
            }
            catch (Exception e) {
                if (e instanceof VRTestException) {
                    status.setLevel(StatusLevel.FATAL);
                    status.setType(StatusType.DRIVER_STATUS);
                    status.descriptionAppend(e.getMessage());
                    status.exceptionAppend(e, true);
                    break;
                }
                if (e instanceof IOException) {
                    XDSCommandDocument notifyDoc = new XDSCommandDocument();
                    status = notifyDoc.appendStatusElement();
                    status.setLevel(StatusLevel.WARNING);
                    status.setType(StatusType.APP_CONNECTION);
                    status.descriptionAppend("Unable to connect.");
                    status.exceptionAppend(e, false);
                    processor.execute(notifyDoc.toXML(), (XmlQueryProcessor)this);
                    Thread.sleep(10000L);
                    ++retries;
                    continue;
                }
                throw e;
            }
        }
    }

    private void publish(XmlCommandProcessor processor) throws InterruptedException, Exception {
        while (this.running) {
            StatusAttributes attrs;
            XDSCommandDocument commandDoc = this.newCommandDoc();
            try {
                if (!this.connected) {
                    this.connect();
                    this.setPublicationProperties();
                    this.connected = true;
                    attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.APP_CONNECTION, null);
                    XDSUtil.appendStatus((StatusDocument)commandDoc, (StatusAttributes)attrs, (String)"Connected.");
                    processor.execute(commandDoc.toXML(), (XmlQueryProcessor)this);
                    commandDoc = this.newCommandDoc();
                }
                VRTestNotification notification = this.api.waitForNotification(processor, this.trace);
                this.publishNotification(notification, processor, commandDoc);
            }
            catch (Exception e) {
                commandDoc.empty();
                attrs = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.APP_GENERAL, null);
                if (e instanceof VRTestException) {
                    XDSUtil.appendStatus((StatusDocument)commandDoc, (StatusAttributes)attrs, null, (Exception)e, (boolean)false, null);
                    processor.execute(commandDoc.toXML(), (XmlQueryProcessor)this);
                    continue;
                }
                if (e instanceof IOException) {
                    if (this.running) {
                        attrs.setLevel(StatusLevel.WARNING);
                        attrs.setType(StatusType.APP_CONNECTION);
                        XDSUtil.appendStatus((StatusDocument)commandDoc, (StatusAttributes)attrs, (String)this.getConnectHeader(), (Exception)e, (boolean)false, null);
                        processor.execute(commandDoc.toXML(), (XmlQueryProcessor)this);
                        Thread.sleep(10000L);
                    }
                    this.connected = false;
                    continue;
                }
                throw e;
            }
        }
    }

    private void publishNotification(VRTestNotification notification, XmlCommandProcessor processor, XDSCommandDocument notifyDoc) throws VRTestException, IOException {
        VRTestModifiedObject object = notification.getObject();
        String className = object.getClassName();
        VRTestClassFilter classFilter = this.filter.getClassFilter(className);
        if (classFilter == null && this.useFilter) {
            this.trace.trace("Filtered Class:  " + className);
        } else {
            VRTestEventType type;
            if (classFilter != null) {
                className = classFilter.getClassName().toString();
            }
            if ((type = notification.getType()) == VRTestEventType.CREATE) {
                this.appendAddElement(notifyDoc, object, classFilter, className);
            } else if (type == VRTestEventType.MODIFY) {
                this.appendMoveModifyORRenameElement(notifyDoc, object, classFilter, className);
            } else if (type == VRTestEventType.DELETE) {
                this.appendDeleteElement(notifyDoc, object, className);
            } else {
                XDSStatusElement status = notifyDoc.appendStatusElement();
                status.setLevel(StatusLevel.WARNING);
                status.appendText(Errors.unsupportedEventType(type.toString()));
            }
            this.publishNotificationDocument(notifyDoc, processor);
        }
    }

    private void appendAddElement(XDSCommandDocument notifyDoc, VRTestModifiedObject object, VRTestClassFilter classFilter, String className) throws VRTestException, IOException {
        XDSAddElement add = notifyDoc.appendAddElement();
        add.setClassName(className);
        add.setSrcDN(object.getDN());
        String association = object.extractAssociationText();
        add.appendAssociationElement(association);
        this.appendAddAttrElements(add, object, classFilter, className);
    }

    private void appendMoveModifyORRenameElement(XDSCommandDocument notifyDoc, VRTestModifiedObject object, VRTestClassFilter classFilter, String className) throws VRTestException, IOException {
        String newPath;
        boolean namingAttributeInFilter = true;
        String namingAttributeName = object.getNamingAttributeSchema().toString();
        if (classFilter != null) {
            namingAttributeName = classFilter.getFilterName(namingAttributeName);
            if (this.useFilter && namingAttributeName == null) {
                namingAttributeInFilter = false;
            }
        }
        LinkedList newNames = new LinkedList();
        if (namingAttributeInFilter && object.renamed(newNames)) {
            if (object.getNamingAttributeSchema().isMultiValued()) {
                this.appendRenameElement(notifyDoc, object, className, object.getName());
                if (newNames.size() != 0 && !this.modifyAll) {
                    this.appendOtherNames(notifyDoc, object, className, namingAttributeName);
                    object.removeCurrent();
                }
            } else {
                this.appendRenameElement(notifyDoc, object, className, (String)newNames.getFirst());
                object.removeCurrent();
            }
        }
        if ((newPath = object.getNewPath()) != null) {
            this.appendMoveElement(notifyDoc, object, className, newPath);
        }
        if (object.hasMoreModifiedAttributes()) {
            this.appendModifyElement(notifyDoc, object, classFilter, className);
        }
    }

    private void appendOtherNames(XDSCommandDocument notifyDoc, VRTestObject object, String className, String namingAttributeName) throws IOException, VRTestException {
        LinkedList otherNames = object.getOtherNames();
        if (otherNames != null) {
            XDSModifyElement modify = notifyDoc.appendModifyElement();
            modify.setClassName(className);
            modify.setSrcDN(object.getDN());
            modify.appendAssociationElement(object.extractAssociationText());
            XDSModifyAttrElement modifyAttr = modify.appendModifyAttrElement();
            modifyAttr.setAttrName(namingAttributeName);
            modifyAttr.appendRemoveAllValuesElement();
            XDSAddValueElement addValue = modifyAttr.appendAddValueElement();
            ListIterator iterator = otherNames.listIterator();
            while (iterator.hasNext()) {
                addValue.appendValueElement((String)iterator.next());
            }
        }
    }

    private void appendDeleteElement(XDSCommandDocument notifyDoc, VRTestModifiedObject object, String className) throws VRTestException, IOException {
        XDSDeleteElement delete = notifyDoc.appendDeleteElement();
        delete.setClassName(className);
        delete.appendAssociationElement(object.extractAssociationText());
    }

    private void appendModifyElement(XDSCommandDocument notifyDoc, VRTestModifiedObject object, VRTestClassFilter classFilter, String className) throws VRTestException, IOException {
        XDSModifyElement modify = notifyDoc.appendModifyElement();
        modify.setClassName(className);
        modify.setSrcDN(object.getDN());
        modify.appendAssociationElement(object.extractAssociationText());
        this.appendModifyAttrElements(modify, object, classFilter);
    }

    private void appendModifyAttrElements(XDSModifyElement modify, VRTestModifiedObject object, VRTestClassFilter classFilter) throws VRTestException, IOException {
        XDSModifyAttrElement modifyAttr;
        LinkedList<String> attributeValues;
        List attributes = this.modifyAll ? object.getAttributes() : object.getModifiedAttributes();
        HashMap<String, LinkedList<String>> attributeNameValueMap = null;
        VRTestClassSchema classSchema = object.getClassSchema();
        ListIterator a = attributes.listIterator();
        while (a.hasNext()) {
            VRTestAttributeSchema attributeSchema;
            VRTestAttribute attribute = (VRTestAttribute)a.next();
            String attrName = attribute.getName();
            String attrFilterName = null;
            if (this.useFilter && (attrFilterName = classFilter.getFilterName(attrName)) == null) {
                this.trace.trace("Filtered Attribute:  " + attrName);
                continue;
            }
            if (attrFilterName != null) {
                attrName = attrFilterName;
            }
            if ((attributeSchema = classSchema.getAttributeSchema(attrName)) == null) {
                throw new VRTestException(Errors.noAttributeSchema(attrName));
            }
            if (this.modifyAll) {
                if (attributeNameValueMap == null) {
                    attributeNameValueMap = new HashMap<String, LinkedList<String>>();
                }
                if ((attributeValues = (LinkedList)attributeNameValueMap.get(attrName)) == null) {
                    attributeValues = new LinkedList<String>();
                    attributeNameValueMap.put(attrName, attributeValues);
                }
                attributeValues.add(attribute.getValue());
                continue;
            }
            modifyAttr = modify.appendModifyAttrElement();
            modifyAttr.setAttrName(attrName);
            this.appendValueElement(modifyAttr, attribute, attributeSchema);
        }
        if (this.modifyAll && attributeNameValueMap != null) {
            Iterator keys = attributeNameValueMap.keySet().iterator();
            while (keys.hasNext()) {
                String attributeName = (String)keys.next();
                attributeValues = (LinkedList<String>)attributeNameValueMap.get(attributeName);
                ListIterator values = attributeValues.listIterator();
                modifyAttr = modify.appendModifyAttrElement();
                modifyAttr.setAttrName(attributeName);
                modifyAttr.appendRemoveAllValuesElement();
                XDSAddValueElement addValue = modifyAttr.appendAddValueElement();
                while (values.hasNext()) {
                    String value = (String)values.next();
                    addValue.appendValueElement(value);
                }
            }
        }
    }

    private void appendValueElement(XDSModifyAttrElement modifyAttr, VRTestAttribute attribute, VRTestAttributeSchema attributeSchema) {
        boolean isAdd = attribute.hasAction(VRTestAction.ADD);
        if (isAdd && !attributeSchema.isMultiValued()) {
            modifyAttr.appendRemoveAllValuesElement();
        }
        if (isAdd) {
            XDSAddValueElement addValue = modifyAttr.appendAddValueElement();
            addValue.appendValueElement(attribute.getValue());
        } else {
            XDSRemoveValueElement removeValue = modifyAttr.appendRemoveValueElement();
            removeValue.appendValueElement(attribute.getValue());
        }
    }

    private void appendRenameElement(XDSCommandDocument notifyDoc, VRTestModifiedObject object, String className, String newName) throws VRTestException, IOException {
        XDSRenameElement rename = notifyDoc.appendRenameElement();
        rename.setClassName(className);
        rename.setRemoveOldName(true);
        rename.setSrcDN(object.getDN());
        rename.appendAssociationElement(object.extractAssociationText());
        rename.appendNewNameElement(newName);
    }

    private void appendMoveElement(XDSCommandDocument notifyDoc, VRTestModifiedObject object, String className, String path) throws VRTestException, IOException {
        String association;
        XDSMoveElement move = notifyDoc.appendMoveElement();
        move.setClassName(className);
        move.setSrcDN(object.getDN());
        move.appendAssociationElement(object.extractAssociationText());
        VRTestPathParser parser = new VRTestPathParser(path);
        XDSParentElement parent = move.appendParentElement();
        parent.setSrcDN(parser.getContainerDN());
        VRTestRootObject rootObject = this.api.getRootObject();
        String containerName = parser.getContainerName();
        if (rootObject.hasName(containerName)) {
            association = rootObject.extractAssociationText();
        } else {
            VRTestObject container = this.api.getObjectByNameANDPath(containerName, parser.getContainerPath());
            association = container.extractAssociationText();
        }
        parent.appendAssociationElement(association);
    }

    public XmlDocument query(XmlDocument queryXML) {
        this.trace.trace("query", 1);
        XDSQueryResultDocument result = new XDSQueryResultDocument();
        this.appendSourceInfo((WriteableDocument)result);
        String eventID = null;
        try {
            XDSQueryDocument queryDoc = new XDSQueryDocument(queryXML);
            ListIterator q = queryDoc.extractQueryElements().listIterator();
            while (q.hasNext()) {
                XDSQueryElement query = (XDSQueryElement)q.next();
                eventID = query.getEventID();
                this.queryHandler(query, (QueryResultDocument)result);
                StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)eventID);
                XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
            }
        }
        catch (XDSException xds) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)((Object)xds), (boolean)false, (XmlDocument)queryXML);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                this.connected = false;
            }
            result.empty();
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, eventID);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)true, (XmlDocument)queryXML);
        }
        return result.toXML();
    }

    void shutdown() {
        this.running = false;
        this.thread.interrupt();
        this.api.closeConnection();
    }

    private void publishNotificationDocument(XDSCommandDocument commandDoc, XmlCommandProcessor processor) {
        if (!commandDoc.isEmpty()) {
            if (this.saveState) {
                this.appendStateInfo((StateParent)commandDoc.appendInitParamsElement().appendPublisherStateElement());
            }
            processor.execute(commandDoc.toXML(), (XmlQueryProcessor)this);
        }
    }

    private void appendAddAttrElements(XDSAddElement add, VRTestModifiedObject object, VRTestClassFilter classFilter, String className) {
        ListIterator a = object.getModifiedAttributes().listIterator();
        while (a.hasNext()) {
            VRTestAttribute attribute = (VRTestAttribute)a.next();
            String attrName = attribute.getName();
            String attrFilterName = null;
            if (this.useFilter && (attrFilterName = classFilter.getFilterName(attrName)) == null) {
                this.trace.trace("Filtered Attribute:  " + attrName);
                continue;
            }
            if (attrFilterName != null) {
                attrName = attrFilterName;
            }
            XDSAddAttrElement addAttr = add.appendAddAttrElement();
            addAttr.setAttrName(attrName);
            addAttr.appendValueElement(attribute.getValue());
        }
    }
}

