/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.vrtest.CommonImpl;
import com.novell.nds.dirxml.driver.vrtest.Constants;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestAddAttributes;
import com.novell.nds.dirxml.driver.vrtest.VRTestAttributeFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestDNParser;
import com.novell.nds.dirxml.driver.vrtest.VRTestDNType;
import com.novell.nds.dirxml.driver.vrtest.VRTestDriverShim;
import com.novell.nds.dirxml.driver.vrtest.VRTestModifyAttributes;
import com.novell.nds.dirxml.driver.vrtest.VRTestObject;
import com.novell.nds.dirxml.driver.vrtest.VRTestRootObject;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.StateParent;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.ValueElementsParent;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAddAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSAddAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSAddElement;
import com.novell.nds.dirxml.driver.xds.XDSAddValueElement;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSCommandResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSDeleteElement;
import com.novell.nds.dirxml.driver.xds.XDSElement;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSModifyAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyElement;
import com.novell.nds.dirxml.driver.xds.XDSMoveElement;
import com.novell.nds.dirxml.driver.xds.XDSParentElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAllValuesElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveValueElement;
import com.novell.nds.dirxml.driver.xds.XDSRenameElement;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.XDSValueElement;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Element;

public class VRTestSubscriptionShim
extends CommonImpl
implements SubscriptionShim,
VRTestConstants,
Constants {
    private static final String TRACE_SUFFIX = "Subscriber";
    private static final int NO_OF_PARAMS = 1;
    private static final String DRIVER_ID_VALUE = "VRTEST";
    private static final String DRIVER_MIN_ACTIVATION_VERSION = "0";
    private Map subParams;
    private VRTestDriverShim driver;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSAddElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSModifyElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSRenameElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSMoveElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSQueryElement;

    private static boolean unsupportedType(ValueType type) {
        return type == ValueType.OCTET || type == ValueType.STRUCTURED;
    }

    public VRTestSubscriptionShim(VRTestDriverShim someDriver) {
        this.driver = someDriver;
        this.setAPI(this.driver.getAPI());
        this.setDriverRDN(this.driver.getDriverRDN());
        this.setDriverParams(this.driver.getDriverParams());
        this.setTrace(TRACE_SUFFIX);
        this.setSubParams();
    }

    private void setSubParams() {
        this.subParams = new HashMap(1);
        Parameter param = new Parameter("run-count", DRIVER_MIN_ACTIVATION_VERSION, DataType.LONG);
        param.add((Constraint)RangeConstraint.POSITIVE);
        this.subParams.put(param.tagName(), param);
    }

    public XmlDocument init(XmlDocument initXML) {
        this.trace.trace("init", 1);
        XDSResultDocument result = this.newResultDoc();
        try {
            XDSInitDocument init = new XDSInitDocument(initXML);
            init.parameters(this.subParams);
            Parameter param = (Parameter)this.subParams.get("run-count");
            this.setRunCount(param.toLong());
            param.overrideValue(String.valueOf(this.getRunCount()));
            this.appendStateInfo((StateParent)result.appendInitParamsElement().appendSubscriberStateElement());
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSStatusElement status = XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
            status.parametersAppend(this.subParams);
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)XDSUtil.appendStackTrace((Exception)e), (XmlDocument)initXML);
        }
        return result.toXML();
    }

    public XmlDocument execute(XmlDocument commandXML, XmlQueryProcessor processor) {
        this.trace.trace("execute", 1);
        XDSCommandResultDocument result = new XDSCommandResultDocument();
        this.appendSourceInfo((WriteableDocument)result);
        String eventID = null;
        try {
            XDSCommandDocument commands = new XDSCommandDocument(commandXML);
            if (commands.containsIdentityQuery()) {
                XDSQueryElement query = commands.identityQuery();
                this.appendDriverIdentityInfo(result);
                StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)query.getEventID());
                XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
            } else {
                this.connect();
                this.connected = true;
                ListIterator c = commands.childElements().listIterator();
                while (c.hasNext()) {
                    CommandElement command = (CommandElement)c.next();
                    eventID = command.getEventID();
                    this.dispatch(command, result);
                    StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)eventID);
                    XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
                }
            }
        }
        catch (XDSException xds) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)((Object)xds), (boolean)false, (XmlDocument)commandXML);
        }
        catch (VRTestException vrt) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.APP_GENERAL, eventID);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)((Object)vrt), (boolean)false, null);
        }
        catch (IOException io) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.RETRY, (StatusType)StatusType.APP_CONNECTION, eventID);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, (String)this.getConnectHeader(), (Exception)io, (boolean)false, null);
            this.connected = false;
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, eventID);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)true, (XmlDocument)commandXML);
        }
        return result.toXML();
    }

    private void dispatch(CommandElement command, XDSCommandResultDocument result) throws VRTestException, IOException {
        this.trace.trace("dispatch", 1);
        Class<?> commandClass = command.getClass();
        if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSAddElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSAddElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSAddElement")) : class$com$novell$nds$dirxml$driver$xds$XDSAddElement)) {
            this.addHandler((XDSAddElement)command, result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSModifyElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSModifyElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSModifyElement")) : class$com$novell$nds$dirxml$driver$xds$XDSModifyElement)) {
            this.modifyHandler((XDSModifyElement)command, result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSDeleteElement")) : class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement)) {
            this.deleteHandler((XDSDeleteElement)command, result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSRenameElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSRenameElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSRenameElement")) : class$com$novell$nds$dirxml$driver$xds$XDSRenameElement)) {
            this.renameHandler((XDSRenameElement)command, result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSMoveElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSMoveElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSMoveElement")) : class$com$novell$nds$dirxml$driver$xds$XDSMoveElement)) {
            this.moveHandler((XDSMoveElement)command, result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSQueryElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSQueryElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSQueryElement")) : class$com$novell$nds$dirxml$driver$xds$XDSQueryElement)) {
            this.queryHandler((XDSQueryElement)command, (QueryResultDocument)result);
        } else {
            this.trace.trace("unhandled element:  " + command.tagName(), 3);
        }
    }

    private void addHandler(XDSAddElement add, XDSCommandResultDocument result) throws VRTestException, IOException {
        VRTestSchema schema = this.api.getSchema();
        VRTestClassSchema classSchema = schema.getClassSchema(add.getClassName());
        if (classSchema == null) {
            throw new VRTestException(Errors.noClassSchema(add.getClassName()));
        }
        String dn = add.getSrcDN();
        if (dn == null) {
            throw new VRTestException(Errors.noAttributeValue("src-dn"));
        }
        VRTestAddAttributes attributes = new VRTestAddAttributes();
        if (schema.isHierarchical()) {
            String objectPath = VRTestDNParser.ParseObjectPath(dn, VRTestDNType.EDIR);
            attributes.addAttribute("Object Path", objectPath);
        }
        VRTestAttributeSchema namingAttributeSchema = classSchema.getNamingAttributeSchema();
        this.ToVRTestAttributes(add.extractAddAttrElements(), attributes, namingAttributeSchema, classSchema, (StatusDocument)result);
        VRTestObject object = this.api.createObject(classSchema.getName(), attributes);
        XDSAddAssociationElement addAssociation = result.appendAddAssociationElement();
        addAssociation.setDestDN(dn);
        addAssociation.appendText(object.extractAssociationText());
    }

    private void ToVRTestAttributes(List addAttrElements, VRTestAddAttributes attributes, VRTestAttributeSchema namingAttributeSchema, VRTestClassSchema classSchema, StatusDocument statusDoc) throws VRTestException {
        ListIterator a = addAttrElements.listIterator();
        boolean foundNamingAttribute = false;
        while (a.hasNext()) {
            XDSAddAttrElement addAttr = (XDSAddAttrElement)a.next();
            String attrName = addAttr.getAttrName();
            VRTestAttributeSchema attributeSchema = classSchema.getAttributeSchema(attrName);
            if (attributeSchema == null) {
                XDSStatusElement status = statusDoc.appendStatusElement();
                status.setLevel(StatusLevel.WARNING);
                status.appendText(Errors.noAttributeSchema(attrName));
                continue;
            }
            if (namingAttributeSchema.hasName(attrName)) {
                foundNamingAttribute = true;
            }
            this.ToVRTestAttributes(addAttr, attributes, attributeSchema.getName(), attributeSchema.isMultiValued());
        }
        if (!foundNamingAttribute) {
            throw new VRTestException(Errors.noAddAttr(namingAttributeSchema.getName()));
        }
    }

    private void ToVRTestAttributes(XDSAddAttrElement addAttr, VRTestAddAttributes attributes, String attributeName, boolean multiValued) throws VRTestException {
        List valueElements = addAttr.extractValueElements();
        ListIterator v = valueElements.listIterator();
        while (v.hasNext()) {
            XDSValueElement valueElement = (XDSValueElement)v.next();
            if (VRTestSubscriptionShim.unsupportedType(valueElement.getType())) {
                throw new VRTestException("Unsupported type:  '" + valueElement.getType() + "'.");
            }
            String value = valueElement.extractText();
            attributes.addAttribute(attributeName, value);
            if (!multiValued) break;
        }
    }

    private void modifyHandler(XDSModifyElement modify, XDSCommandResultDocument result) throws VRTestException, IOException {
        VRTestObject object;
        String association = modify.extractAssociationText();
        String className = null;
        VRTestClassSchema classSchema = this.api.getSchema().getClassSchema(modify.getClassName());
        if (classSchema != null) {
            className = classSchema.getName();
        }
        if ((object = this.api.getObjectByAssociation(association, className)) == null) {
            XDSRemoveAssociationElement remove = result.appendRemoveAssociationElement();
            remove.appendText(association);
            return;
        }
        VRTestModifyAttributes attributes = new VRTestModifyAttributes();
        VRTestSubscriptionShim.ToVRTestAttributes(attributes, modify, object, classSchema, (StatusDocument)result);
        this.api.modifyObject(object, attributes);
    }

    private static void ToVRTestAttributes(VRTestModifyAttributes modifyAttributes, XDSModifyElement modify, VRTestObject object, VRTestClassSchema classSchema, StatusDocument statusDoc) throws VRTestException, IOException {
        ListIterator ma = modify.extractModifyAttrElements().listIterator();
        while (ma.hasNext()) {
            XDSModifyAttrElement modifyAttr = (XDSModifyAttrElement)ma.next();
            String attrName = modifyAttr.getAttrName();
            VRTestAttributeSchema attributeSchema = classSchema.getAttributeSchema(attrName);
            if (attributeSchema == null) {
                XDSStatusElement status = statusDoc.appendStatusElement();
                status.setLevel(StatusLevel.WARNING);
                status.appendText(Errors.noAttributeSchema(attrName));
                continue;
            }
            VRTestSubscriptionShim.ToVRTestAttributes(modifyAttributes, modifyAttr, object, attributeSchema);
        }
    }

    private static void ToVRTestAttributes(VRTestModifyAttributes modifyAttributes, XDSModifyAttrElement modifyAttr, VRTestObject object, VRTestAttributeSchema attributeSchema) throws VRTestException, IOException {
        String attributeName = attributeSchema.getName();
        ListIterator c = modifyAttr.childElements().listIterator();
        while (c.hasNext()) {
            XDSElement child = (XDSElement)c.next();
            if (child instanceof XDSRemoveAllValuesElement) {
                VRTestSubscriptionShim.ToVRTestAttributes(modifyAttributes, object, attributeName);
                continue;
            }
            if (child instanceof XDSRemoveValueElement) {
                VRTestSubscriptionShim.ToVRTestAttributes(modifyAttributes, (XDSRemoveValueElement)child, attributeName);
                continue;
            }
            if (!(child instanceof XDSAddValueElement)) continue;
            CommonImpl.ToVRTestAttributes(modifyAttributes, (ValueElementsParent)((XDSAddValueElement)child), attributeName);
        }
    }

    private static void ToVRTestAttributes(VRTestModifyAttributes modifyAttributes, VRTestObject object, String attributeName) throws VRTestException, IOException {
        VRTestAttributeFilter filter = new VRTestAttributeFilter();
        filter.addAttribute(attributeName, VRTestAttribute.ANY_VALUE);
        ListIterator oa = object.getAttributes(filter).listIterator();
        while (oa.hasNext()) {
            VRTestAttribute objectAttribute = (VRTestAttribute)oa.next();
            modifyAttributes.removeAttribute(objectAttribute.getName(), objectAttribute.getValue());
        }
    }

    private static void ToVRTestAttributes(VRTestModifyAttributes attributes, XDSRemoveValueElement removeValue, String attributeName) throws VRTestException {
        ListIterator v = removeValue.extractValueElements().listIterator();
        while (v.hasNext()) {
            XDSValueElement value = (XDSValueElement)v.next();
            if (VRTestSubscriptionShim.unsupportedType(value.getType())) {
                throw new VRTestException("Unsupported type '" + value.getType() + "'.");
            }
            attributes.removeAttribute(attributeName, value.extractText());
        }
    }

    private void deleteHandler(XDSDeleteElement delete, XDSCommandResultDocument result) throws VRTestException, IOException {
        String association = delete.extractAssociationText();
        String className = null;
        VRTestClassSchema classSchema = this.api.getSchema().getClassSchema(delete.getClassName());
        if (classSchema != null) {
            className = classSchema.getName();
        }
        this.api.deleteObject(association, className);
        XDSRemoveAssociationElement remove = result.appendRemoveAssociationElement();
        remove.setEventID(delete.getEventID());
        remove.appendText(association);
    }

    void renameHandler(XDSRenameElement rename, XDSCommandResultDocument result) throws VRTestException, IOException {
        String className = rename.getClassName();
        if (className == null) {
            throw new VRTestException(Errors.noAttributeValue("class-name"));
        }
        VRTestObject object = this.api.getObjectByAssociation(rename.extractAssociationText(), className);
        if (object == null) {
            XDSRemoveAssociationElement remove = result.appendRemoveAssociationElement();
            remove.appendText(rename.extractAssociationText());
            return;
        }
        String oldName = object.getName();
        if (oldName == null) {
            throw new VRTestException("Object missing name.");
        }
        VRTestClassSchema classSchema = object.getClassSchema();
        if (classSchema == null) {
            throw new VRTestException(Errors.noClassSchema(className));
        }
        String namingAttributeName = classSchema.getNamingAttributeSchema().getName();
        VRTestModifyAttributes attributes = new VRTestModifyAttributes();
        attributes.removeAttribute(namingAttributeName, oldName);
        attributes.addAttribute(namingAttributeName, rename.extractNewNameText());
        this.api.modifyObject(object, attributes);
    }

    void moveHandler(XDSMoveElement move, XDSCommandResultDocument result) throws VRTestException, IOException {
        String newPath;
        XDSParentElement parent;
        String association;
        VRTestObject objectToMove;
        if (!this.api.getSchema().isHierarchical()) {
            return;
        }
        String className = null;
        VRTestClassSchema classSchema = this.api.getSchema().getClassSchema(move.getClassName());
        if (classSchema != null) {
            className = classSchema.getName();
        }
        if ((objectToMove = this.api.getObjectByAssociation(move.extractAssociationText(), className)) == null) {
            XDSRemoveAssociationElement remove = result.appendRemoveAssociationElement();
            remove.appendText(move.extractAssociationText());
            return;
        }
        String oldPath = objectToMove.getPath();
        if (oldPath == null) {
            throw new VRTestException("Object missing path.");
        }
        VRTestRootObject root = this.api.getRootObject();
        if (root.hasAssociation(association = (parent = move.extractParentElement()).extractAssociationText())) {
            newPath = root.getChildPath();
        } else {
            VRTestObject parentObject = this.api.getObjectByAssociation(association, null);
            if (parentObject == null) {
                XDSRemoveAssociationElement remove = result.appendRemoveAssociationElement();
                remove.appendText(association);
                throw new VRTestException("Parent object not found.");
            }
            String dn = parentObject.getDN();
            if (dn == null) {
                throw new VRTestException("Object missing required dn.");
            }
            newPath = dn + "\\";
        }
        VRTestModifyAttributes attributes = new VRTestModifyAttributes();
        attributes.removeAttribute("Object Path", oldPath);
        attributes.addAttribute("Object Path", newPath);
        this.api.modifyObject(objectToMove, attributes);
    }

    private void appendDriverIdentityInfo(XDSCommandResultDocument result) {
        if (result != null) {
            String driverID = "<instance class-name=\"__driver_identification_class__\"><attr attr-name=\"driver-id\"><value type=\"string\">VRTEST</value></attr><attr attr-name=\"driver-version\"><value type=\"string\">1.1</value></attr><attr attr-name=\"min-activation-version\"><value type=\"string\">0</value></attr></instance>";
            XDSUtil.appendXML((Element)result.domIOElement(), (String)driverID);
        }
    }

    void shutdown() {
        this.disconnect();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

