/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.EnumConstraint;
import com.novell.nds.dirxml.driver.xds.Lib_1_4;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.util.Java;

final class BooleanConstraint
extends Constraint {
    public static final BooleanConstraint BOOLEAN;
    private static final ConstraintGroup TRUE;
    private static final ConstraintGroup FALSE;

    BooleanConstraint() {
        this.setOperator(LogicalOp.AND);
    }

    boolean isTrue(Parameter param, Object someValue, Object[] typedValue) {
        return TRUE.isValidValue(param, someValue, typedValue);
    }

    boolean isFalse(Parameter param, Object someValue, Object[] typedValue) {
        return FALSE.isValidValue(param, someValue, typedValue);
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        boolean valid = true;
        if (someValue != null && !(someValue instanceof Boolean)) {
            if (this.isTrue(param, someValue, typedValue)) {
                typedValue[0] = Boolean.TRUE;
            } else if (this.isFalse(param, someValue, typedValue)) {
                typedValue[0] = Boolean.FALSE;
            } else {
                valid = false;
            }
        }
        return valid;
    }

    String getLegalValues() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(TRUE.getLegalValues());
        buffer.append(", ");
        buffer.append(FALSE.getLegalValues());
        return buffer.toString();
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClass() == o.getClass();
    }

    Object cloneAsNeeded(boolean sameParameter) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return true;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }

    static {
        boolean java14 = Java.isJRE(1, 4);
        ConstraintGroup group = new ConstraintGroup();
        EnumConstraint enumConstraint = new EnumConstraint();
        enumConstraint.addLiterals(new String[]{"y", "yes", "t", "true", "on"});
        group.add(enumConstraint);
        RangeConstraint range = new RangeConstraint(1L, 1L);
        group.add(range);
        if (java14) {
            group.add(Lib_1_4.newCaseInsensitiveRegExConstraint("t.*"));
            group.add(Lib_1_4.newCaseInsensitiveRegExConstraint("y.*"));
        }
        group.setConstant();
        TRUE = group;
        group = new ConstraintGroup();
        enumConstraint = new EnumConstraint();
        enumConstraint.addLiterals(new String[]{"n", "no", "f", "false", "off"});
        group.add(enumConstraint);
        range = new RangeConstraint(1L, 1L);
        range.setNOT();
        group.add(range);
        if (java14) {
            group.add(Lib_1_4.newCaseInsensitiveRegExConstraint("f.*"));
            group.add(Lib_1_4.newCaseInsensitiveRegExConstraint("n.*"));
        }
        group.setConstant();
        FALSE = group;
        BooleanConstraint constraint = new BooleanConstraint();
        constraint.setConstant();
        BOOLEAN = constraint;
    }
}

