/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.BooleanComparator;
import com.novell.nds.dirxml.driver.xds.CharInsensitiveComparator;
import com.novell.nds.dirxml.driver.xds.CharSensitiveComparator;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.DoubleComparator;
import com.novell.nds.dirxml.driver.xds.LongComparator;
import com.novell.nds.dirxml.driver.xds.StringInsensitiveComparator;
import com.novell.nds.dirxml.driver.xds.StringSensitiveComparator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

abstract class Comparators {
    static final Comparator STRING_INSENSITIVE = new StringInsensitiveComparator();
    static final Comparator STRING_SENSITIVE = new StringSensitiveComparator();
    static final Comparator CHAR_INSENSITIVE = new CharInsensitiveComparator();
    static final Comparator CHAR_SENSITIVE = new CharSensitiveComparator();
    static final Comparator LONG;
    static final Comparator SHORT;
    static final Comparator INT;
    static final Comparator DOUBLE;
    static final Comparator FLOAT;
    static final Comparator BOOLEAN;
    static final Map ARGS;

    Comparators() {
    }

    static boolean AreNull(Object o1, Object o2) {
        return o1 == null || o2 == null;
    }

    static int CompareNulls(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        throw new IllegalArgumentException("Both arguments cannot be non-null");
    }

    static boolean IsString(Object o) {
        return o == null ? false : o.getClass() == String.class;
    }

    static boolean IsCharacter(Object o) {
        return o == null ? false : o.getClass() == Character.class;
    }

    static boolean TestArgs(Comparator comp, DataType type) {
        boolean accepts;
        Object[] testArgs = (Object[])ARGS.get(type.getJavaClass());
        try {
            comp.compare(testArgs[0], testArgs[1]);
            accepts = true;
        }
        catch (ClassCastException cc) {
            accepts = false;
        }
        return accepts;
    }

    static {
        SHORT = LONG = new LongComparator();
        INT = LONG;
        FLOAT = DOUBLE = new DoubleComparator();
        BOOLEAN = new BooleanComparator();
        ARGS = new HashMap();
        Object[] args = new Object[]{new Short("0"), new Short("1")};
        ARGS.put(Short.class, args);
        args = new Object[]{new Integer(0), new Integer(1)};
        ARGS.put(Integer.class, args);
        args = new Object[]{new Long(0L), new Long(1L)};
        ARGS.put(Long.class, args);
        args = new Object[]{new Float(0.0), new Float(1.0)};
        ARGS.put(Float.class, args);
        args = new Object[]{new Double(0.0), new Double(1.0)};
        ARGS.put(Double.class, args);
        args = new Object[]{new Character('b'), new Character('a')};
        ARGS.put(Character.class, args);
        args = new Object[]{new Character('b'), new Character('a')};
        ARGS.put(Character.class, args);
        args = new Object[]{new String("cd"), new String("ab")};
        ARGS.put(String.class, args);
        args = new Object[]{new Boolean(false), new Boolean(true)};
        ARGS.put(Boolean.class, args);
    }
}

