/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class Constraint {
    protected static int HASH_REQUIRED = 1;
    protected static int HASH_GLOBAL_REQUIRED = 2;
    protected static int HASH_SINGLE_VALUE = 3;
    protected static int HASH_MULTI_VALUE = 4;
    protected static final String OPEN_SET = "[";
    protected static final String CLOSE_SET = "]";
    protected static final String KEYWORD_AND = "and";
    protected static final String KEYWORD_OR = "or";
    protected static final String KEYWORD_NOT = "not";
    private static final boolean DEFAULT_CONSTANT = false;
    private static final boolean DEFAULT_REQUIRED = false;
    private static final boolean DEFAULT_CONTAINER = false;
    private static final boolean DEFAULT_NOT = false;
    private static final LogicalOp DEFAULT_OP = LogicalOp.OR;
    private List types;
    protected LogicalOp groupOp;
    protected boolean constant;
    protected boolean required;
    protected boolean isGroup;
    protected boolean not;
    protected List constraints;
    protected Set registeredParams;

    protected Constraint() {
        this.init();
    }

    private void init() {
        this.types = new LinkedList();
        this.types.add(DataType.ANY);
        this.constant = false;
        this.required = false;
        this.constraints = new LinkedList();
        this.isGroup = false;
        this.not = false;
        this.groupOp = DEFAULT_OP;
        this.registeredParams = Collections.EMPTY_SET;
    }

    public List getTypes() {
        return this.types;
    }

    protected void setType(DataType t) {
        this.types.clear();
        this.types.add(t);
    }

    public DataType getType() {
        return (DataType)this.types.get(0);
    }

    protected void addConstraint(Constraint c) {
        this.constraints.add(c);
    }

    protected void checkConstant() {
        if (this.constant) {
            throw new IllegalStateException("Constraint is unmodifiable.");
        }
    }

    void register(Parameter param) {
        if (this.isStateful()) {
            if (!this.canBeAppliedToMultipleParams() && this.registeredParams.size() > 0 && !this.registeredParams.contains(param)) {
                throw new IllegalArgumentException("This constraint can be added to at most one parameter.");
            }
            if (this.registeredParams.isEmpty()) {
                this.registeredParams = new HashSet();
            }
            this.registeredParams.add(param);
        }
    }

    Collection getRegisteredParams() {
        return this.registeredParams;
    }

    boolean isGroup() {
        return this.isGroup;
    }

    boolean isConstant() {
        return this.constant;
    }

    void setConstant() {
        this.constant = true;
    }

    List getConstraints() {
        return this.constraints;
    }

    abstract boolean isValidValue(Parameter var1, Object var2, Object[] var3);

    abstract boolean isSatisfied();

    void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    public boolean getNOT() {
        return this.not;
    }

    protected void setRequired() {
        this.checkConstant();
        this.required = true;
    }

    boolean isRequired() {
        return this.required;
    }

    boolean isUnique() {
        return false;
    }

    public String toString() {
        String string = this.getLegalValues();
        if (Lib.IsValue(string)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(OPEN_SET);
            buffer.append(string);
            buffer.append(CLOSE_SET);
            string = buffer.toString();
            if (this.not) {
                string = KEYWORD_NOT + string;
            }
        }
        return string;
    }

    protected void setOperator(LogicalOp someOp) {
        this.groupOp = someOp;
    }

    public LogicalOp getOperator() {
        return this.groupOp;
    }

    abstract String getLegalValues();

    abstract Object cloneAsNeeded(boolean var1);

    public abstract boolean forStructured();

    public abstract boolean forScalar();

    abstract boolean isType();

    boolean isCardinality() {
        return false;
    }

    public abstract boolean canBeAppliedToMultipleParams();

    abstract boolean isStateful();

    abstract boolean isIndependent();

    boolean isTyped() {
        return !this.types.contains(DataType.ANY) && !this.types.contains(DataType.STRUCT);
    }

    boolean isUntyped() {
        return this.types.contains(DataType.ANY);
    }

    boolean isStateless() {
        return !this.isStateful();
    }

    boolean isDependent() {
        return !this.isIndependent();
    }
}

