/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ConstraintGroup
extends Constraint {
    private Set constraintSet;
    private int hashCode;
    private boolean hashCodeSet;

    public ConstraintGroup() {
        this.isGroup = true;
        this.constraintSet = Collections.EMPTY_SET;
    }

    private ConstraintGroup(ConstraintGroup other, boolean sameParameter) {
        this.isGroup = true;
        this.constant = other.constant;
        this.groupOp = other.groupOp;
        this.not = other.not;
        this.required = other.required;
        this.constraintSet = new HashSet(other.constraintSet.size());
        this.constraints = new ArrayList(other.constraints.size());
        ListIterator l = other.constraints.listIterator();
        while (l.hasNext()) {
            Constraint c = (Constraint)l.next();
            c = (Constraint)c.cloneAsNeeded(sameParameter);
            if (other.constant) {
                c.setConstant();
            }
            this.constraints.add(c);
            this.constraintSet.add(c);
        }
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    void setConstant() {
        this.constant = true;
        ListIterator l = this.constraints.listIterator();
        while (l.hasNext()) {
            Constraint c = (Constraint)l.next();
            c.setConstant();
        }
    }

    public boolean forStructured() {
        Constraint c;
        boolean structured = true;
        ListIterator l = this.constraints.listIterator();
        while (l.hasNext() && (structured &= (c = (Constraint)l.next()).forStructured())) {
        }
        return structured;
    }

    public boolean forScalar() {
        Constraint c;
        boolean scalar = true;
        ListIterator l = this.constraints.listIterator();
        while (l.hasNext() && (scalar &= (c = (Constraint)l.next()).forScalar())) {
        }
        return scalar;
    }

    public void setOperator(LogicalOp someOp) {
        this.checkConstant();
        if (someOp != null) {
            this.groupOp = someOp;
        }
    }

    public void add(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        if (constraint.isDependent()) {
            throw new IllegalArgumentException("Grouping of dependent constraints is not supported.");
        }
        if (constraint.isRequired()) {
            this.setRequired();
        }
        constraint.setConstant();
        if (!this.constraintSet.contains(constraint)) {
            this.addConstraint(constraint);
            if (this.constraintSet.isEmpty()) {
                this.constraintSet = new HashSet();
            }
            this.constraintSet.add(constraint);
        }
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        if (this.groupOp == LogicalOp.AND) {
            return this.applyANDGroup(param, someValue, typedValue);
        }
        if (this.groupOp == LogicalOp.OR) {
            return this.applyORGroup(param, someValue, typedValue);
        }
        throw new RuntimeException("Broken IF-ELSE statement.");
    }

    String getLegalValues() {
        int size = this.constraints.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            Constraint constraint = (Constraint)this.constraints.get(0);
            return constraint.getLegalValues();
        }
        int current = 1;
        StringBuffer buffer = new StringBuffer(32 * size);
        buffer.append("(");
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext()) {
            Constraint constraint = (Constraint)c.next();
            buffer.append(constraint.toString());
            if (current < size) {
                buffer.append(" " + this.groupOp.toString() + " ");
            }
            ++current;
        }
        buffer.append(")");
        return buffer.toString();
    }

    private boolean applyANDGroup(Parameter param, Object someValue, Object[] typedValue) {
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext()) {
            Constraint constraint = (Constraint)c.next();
            if (constraint.isValidValue(param, someValue, typedValue)) continue;
            return false;
        }
        return true;
    }

    private boolean applyORGroup(Parameter param, Object someValue, Object[] typedValue) {
        if (this.constraints.isEmpty()) {
            return true;
        }
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext()) {
            Constraint current = (Constraint)c.next();
            if (!current.isValidValue(param, someValue, typedValue)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        this.hashCode = 0;
        ListIterator l = this.constraints.listIterator();
        while (l.hasNext()) {
            this.hashCode += l.next().hashCode();
        }
        this.setConstant();
        this.hashCodeSet = true;
        return this.hashCode;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof Constraint) {
            Constraint other = (Constraint)o;
            boolean bl = equal = this.constraints.size() == other.constraints.size();
            if (equal) {
                if (this.constraints.size() > 1) {
                    boolean bl2 = equal = this.groupOp == other.groupOp;
                }
                if (equal) {
                    if (this.groupOp == LogicalOp.OR) {
                        ListIterator th = this.constraints.listIterator();
                        while (th.hasNext()) {
                            if (other.constraints.contains(th.next())) continue;
                            equal = false;
                            break;
                        }
                    } else if (this.groupOp == LogicalOp.AND) {
                        ListIterator th = this.constraints.listIterator();
                        ListIterator ot = other.constraints.listIterator();
                        while (th.hasNext() && ot.hasNext()) {
                            Constraint oc;
                            Constraint tc = (Constraint)th.next();
                            if (tc.equals(oc = (Constraint)ot.next())) continue;
                            equal = false;
                            break;
                        }
                    } else {
                        throw new IllegalStateException("Broken IF-ELSE statement.");
                    }
                }
            }
        }
        return equal;
    }

    Object cloneAsNeeded(boolean sameParameter) {
        return new ConstraintGroup(this, sameParameter);
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        Constraint c;
        boolean can = false;
        ListIterator l = this.constraints.listIterator();
        while (l.hasNext() && !(can |= (c = (Constraint)l.next()).canBeAppliedToMultipleParams())) {
        }
        return can;
    }

    boolean isStateful() {
        Constraint c;
        boolean stateful = false;
        ListIterator l = this.constraints.listIterator();
        while (l.hasNext() && !(stateful |= (c = (Constraint)l.next()).isStateful())) {
        }
        return stateful;
    }

    public List getTypes() {
        ArrayList<DataType> list = new ArrayList<DataType>(this.constraints.size());
        ListIterator l = this.constraints.listIterator();
        while (l.hasNext()) {
            Constraint c = (Constraint)l.next();
            if (!c.isTyped()) continue;
            list.add(c.getType());
        }
        if (list.isEmpty()) {
            list.add(DataType.ANY);
        }
        return list;
    }

    boolean isTyped() {
        Constraint c;
        boolean typed = false;
        ListIterator l = this.constraints.listIterator();
        while (l.hasNext() && !(typed |= (c = (Constraint)l.next()).isTyped())) {
        }
        return typed;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

