/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Lib;

public class DTDVersion
implements Comparable {
    public static final DTDVersion V1_0 = new DTDVersion("1.0", 0);
    public static final DTDVersion V1_1 = new DTDVersion("1.1", 1);
    public static final DTDVersion V2_0 = new DTDVersion("2.0", 2);
    public static final DTDVersion V3_0;
    public static final DTDVersion CURRENT;
    public static final DTDVersion UNKNOWN;
    public static final DTDVersion ILLEGAL;
    private static final int NO_OF_VERSIONS = 4;
    static final DTDVersion[] VERSIONS;
    private String version;
    private int weight;

    private DTDVersion(String versionValue, int someWeight) {
        this.version = versionValue;
        this.weight = someWeight;
    }

    static DTDVersion Lookup(String version) {
        for (int v = 0; v < VERSIONS.length; ++v) {
            if (!VERSIONS[v].equals(version)) continue;
            return VERSIONS[v];
        }
        return UNKNOWN;
    }

    String getValue() {
        return this.version;
    }

    int getWeight() {
        return this.weight;
    }

    public int compareTo(Object someVersion) {
        Lib.CheckParam(someVersion, "someVersion");
        DTDVersion otherVersion = (DTDVersion)someVersion;
        int otherWeight = otherVersion.getWeight();
        if (this.weight < otherWeight) {
            return -1;
        }
        if (this.weight > otherWeight) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object someVersion) {
        if (someVersion == null) {
            return false;
        }
        if (this == someVersion) {
            return true;
        }
        if (someVersion.getClass() == String.class) {
            return this.equals((String)someVersion);
        }
        return false;
    }

    public boolean equals(String someVersion) {
        if (someVersion == null) {
            return false;
        }
        return this.version.compareTo(someVersion) == 0;
    }

    public String toString() {
        return this.version;
    }

    static {
        CURRENT = V3_0 = new DTDVersion("3.0", 3);
        UNKNOWN = new DTDVersion("unknown", Integer.MAX_VALUE);
        ILLEGAL = new DTDVersion("illegal", Integer.MAX_VALUE);
        VERSIONS = new DTDVersion[4];
        DTDVersion.VERSIONS[0] = V1_0;
        DTDVersion.VERSIONS[1] = V1_1;
        DTDVersion.VERSIONS[2] = V2_0;
        DTDVersion.VERSIONS[3] = V3_0;
    }
}

