/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Lib;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataType {
    public static final DataType CHAR = new DataType("character");
    public static final DataType STRING;
    public static final DataType TRIMMED_STRING;
    public static final DataType SHORT;
    public static final DataType INT;
    public static final DataType LONG;
    public static final DataType FLOAT;
    public static final DataType DOUBLE;
    public static final DataType BOOLEAN;
    public static final DataType STRUCT;
    public static final DataType ANY;
    private String name;
    private String before;
    private Class type;
    private List promotableTo;

    private DataType(String someName) {
        this.name = someName;
        this.promotableTo = new LinkedList();
        this.promotableTo.add(this);
    }

    static boolean IsStringType(DataType someType) {
        return someType == STRING || someType == CHAR;
    }

    static boolean IsEnumerativeType(DataType someType) {
        return someType != BOOLEAN;
    }

    private void setBeforeText(String beforeText) {
        this.before = beforeText;
    }

    private void addTypePromotion(DataType someType) {
        this.promotableTo.add(someType);
    }

    private void setJavaClass(Class someClass) {
        this.type = someClass;
    }

    public Class getJavaClass() {
        return this.type;
    }

    boolean isCompatible(List otherTypes) {
        if (otherTypes == null || otherTypes.isEmpty()) {
            return false;
        }
        return this.isCompatibleImpl(otherTypes);
    }

    boolean isCompatibleImpl(List otherTypes) {
        Iterator i = otherTypes.iterator();
        while (i.hasNext()) {
            if (!this.isCompatibleImpl((DataType)i.next())) continue;
            return true;
        }
        return false;
    }

    boolean isCompatible(DataType testType) {
        if (testType == null) {
            return false;
        }
        return this.isCompatibleImpl(testType);
    }

    boolean isCompatibleImpl(DataType testType) {
        if (this.promotableTo.contains(testType)) {
            return true;
        }
        Iterator i = this.promotableTo.iterator();
        while (i.hasNext()) {
            DataType t = (DataType)i.next();
            if (t == this || !testType.isCompatibleImpl(t)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    String toClause() {
        if (Lib.IsValue(this.before)) {
            return this.before + " " + this.name;
        }
        return this.name;
    }

    static {
        CHAR.setBeforeText("a");
        CHAR.setJavaClass(Character.class);
        STRING = new DataType("string");
        STRING.setBeforeText("a");
        STRING.setJavaClass(String.class);
        TRIMMED_STRING = new DataType("string");
        TRIMMED_STRING.setBeforeText("a");
        TRIMMED_STRING.setJavaClass(String.class);
        SHORT = new DataType("short");
        SHORT.setBeforeText("a");
        SHORT.setJavaClass(Short.class);
        INT = new DataType("integer");
        INT.setBeforeText("an");
        INT.setJavaClass(Integer.class);
        LONG = new DataType("long");
        LONG.setBeforeText("a");
        LONG.setJavaClass(Long.class);
        FLOAT = new DataType("float");
        FLOAT.setBeforeText("a");
        FLOAT.setJavaClass(Float.class);
        DOUBLE = new DataType("double");
        DOUBLE.setBeforeText("a");
        DOUBLE.setJavaClass(Double.class);
        BOOLEAN = new DataType("boolean");
        BOOLEAN.setBeforeText("a");
        BOOLEAN.setJavaClass(Boolean.class);
        STRUCT = new DataType("struct");
        ANY = new DataType("untyped");
        CHAR.addTypePromotion(STRING);
        CHAR.addTypePromotion(TRIMMED_STRING);
        SHORT.addTypePromotion(INT);
        INT.addTypePromotion(LONG);
        LONG.addTypePromotion(STRING);
        FLOAT.addTypePromotion(DOUBLE);
        DOUBLE.addTypePromotion(STRING);
        DOUBLE.addTypePromotion(TRIMMED_STRING);
    }
}

