/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;

final class DoubleConstraint
extends Constraint {
    DoubleConstraint() {
        this.setOperator(LogicalOp.AND);
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        boolean valid = true;
        if (someValue != null && someValue.getClass() != Double.class) {
            if (someValue.getClass() == Float.class) {
                typedValue[0] = new Double(((Float)someValue).doubleValue());
            } else {
                try {
                    String string = someValue.toString();
                    if (string == null) {
                        valid = false;
                        typedValue[0] = null;
                    } else {
                        typedValue[0] = new Double(string.trim());
                    }
                }
                catch (NumberFormatException nfe) {
                    valid = false;
                }
            }
        }
        return valid;
    }

    String getLegalValues() {
        return "4.9E-324...1.7976931348623157E308";
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClass() == o.getClass();
    }

    Object cloneAsNeeded(boolean sameParameter) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return true;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

