/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class DynamicEnumConstraint
extends Constraint {
    Set enumParams;

    public DynamicEnumConstraint(Collection params) {
        Lib.CheckParam(params, "params");
        this.setEnumParams(params);
        this.addConstraint(this);
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private void setEnumParams(Collection c) {
        if (c.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter must be specified.");
        }
        DataType current = DataType.ANY;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            if (p == null) continue;
            if (p.isStructured()) {
                throw new IllegalArgumentException("Only scalar parameters can be specified.");
            }
            if (current == DataType.ANY) {
                current = p.getDataType();
            } else {
                DataType next = p.getDataType();
                if (!current.isCompatibleImpl(next)) {
                    throw new IllegalArgumentException("Data type mismatch.  Parameters providing values for an enumerative constraints must be type compatible.  Parameter " + p.getParamInfo() + " of type '" + next + "' violates this principle.");
                }
            }
            this.enumParams.add(p);
        }
        this.setType(current);
    }

    void register(Parameter param) {
        if (this.registeredParams.contains(param)) {
            throw new IllegalArgumentException("This constraint cannot be applied to a parameter it also contains.");
        }
        super.register(param);
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        return true;
    }

    Collection getParameters() {
        return this.enumParams;
    }

    String getLegalValues() {
        boolean first = true;
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.enumParams.iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            Iterator o = p.toList().iterator();
            while (o.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                boolean string = DataType.IsStringType(p.getType());
                if (string) {
                    buffer.append("'");
                }
                buffer.append(o.next());
                if (!string) continue;
                buffer.append("'");
            }
        }
        return buffer.toString();
    }

    boolean contains(Parameter p) {
        return this.enumParams.contains(p);
    }

    public int hashCode() {
        this.setConstant();
        int hashCode = 0;
        Iterator i = this.enumParams.iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            hashCode += p.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof DynamicEnumConstraint) {
            DynamicEnumConstraint oc = (DynamicEnumConstraint)o;
            boolean bl = equal = this.enumParams.size() == oc.enumParams.size();
            if (equal) {
                Iterator i = this.enumParams.iterator();
                while (i.hasNext()) {
                    Parameter p = (Parameter)i.next();
                    if (oc.contains(p)) continue;
                    equal = false;
                    break;
                }
            }
        } else if (o instanceof ConstraintGroup) {
            ConstraintGroup og = (ConstraintGroup)o;
            boolean bl = equal = og.constraints.size() == 1;
            if (equal) {
                equal = this.equals(og.constraints.get(0));
            }
        }
        return equal;
    }

    Object cloneAsNeeded(boolean sameParameter) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return false;
    }

    boolean isStateful() {
        return true;
    }

    boolean isIndependent() {
        return false;
    }

    boolean isSatisfied() {
        boolean satisfied = true;
        Parameter check = (Parameter)this.registeredParams.iterator().next();
        Iterator o = check.toList().iterator();
        block0: while (o.hasNext() && satisfied) {
            Object v = o.next();
            Iterator i = this.enumParams.iterator();
            while (i.hasNext()) {
                Parameter p = (Parameter)i.next();
                if (!p.hasValue(v)) continue;
                continue block0;
            }
            satisfied = false;
            break;
        }
        return this.not ? !satisfied : satisfied;
    }
}

