/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Comparators;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class EnumConstraint
extends Constraint {
    public static final Comparator CASE_SENSITIVE = Comparators.STRING_SENSITIVE;
    public static final Comparator CASE_INSENSITIVE;
    private static final Comparator DEFAULT_COMP;
    private List values;
    private Comparator comparator;
    private boolean caseInsensitive;
    private int hashCode;
    private boolean hashCodeSet;

    public EnumConstraint() {
        this.setValues();
        this.setComparator(DEFAULT_COMP);
        this.addConstraint(this);
    }

    public EnumConstraint(Comparator someComparator) {
        Lib.CheckParam(someComparator, "someComparator");
        this.setValues();
        this.setComparator(someComparator);
        this.addConstraint(this);
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private void setCaseInsensitive() {
        this.caseInsensitive = this.comparator.compare("c", "C") == 0;
    }

    private void setValues() {
        this.values = new LinkedList();
    }

    public void setComparator(Comparator someComparator) {
        this.checkConstant();
        Lib.CheckParam(someComparator, "someComparator");
        Comparators.TestArgs(someComparator, DataType.STRING);
        this.comparator = someComparator;
        Collections.sort(this.values, this.comparator);
        this.setCaseInsensitive();
    }

    public void addLiteral(String value) {
        this.checkConstant();
        this.addValue(value);
    }

    private void addValue(String value) {
        int index;
        if (Lib.IsValue(value) && (index = Collections.binarySearch(this.values, value, this.comparator)) < 0) {
            index = -index - 1;
            this.values.add(index, value);
        }
    }

    public void addLiterals(String[] someValues) {
        this.checkConstant();
        if (someValues == null || someValues.length == 0) {
            return;
        }
        for (int v = 0; v < someValues.length; ++v) {
            this.addValue(someValues[v]);
        }
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        return someValue == null ? true : this.isValid(someValue.toString(), this.not);
    }

    private boolean isValid(String someValue, boolean returnVal) {
        return Collections.binarySearch(this.values, someValue) > -1 ? !returnVal : returnVal;
    }

    List getLiterals() {
        return this.values;
    }

    String getLegalValues() {
        StringBuffer buffer = new StringBuffer(this.values.size() * 16);
        boolean first = true;
        ListIterator l = this.values.listIterator();
        while (l.hasNext()) {
            String value = (String)l.next();
            if (first) {
                first = false;
            } else {
                buffer.append(" or ");
            }
            buffer.append("'" + value + "'");
        }
        return buffer.toString();
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        String hashString = this.getLegalValues();
        if (this.caseInsensitive) {
            hashString = hashString.toUpperCase();
        }
        this.setConstant();
        this.hashCodeSet = true;
        this.hashCode = hashString.hashCode();
        return this.hashCode;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof EnumConstraint) {
            EnumConstraint oc = (EnumConstraint)o;
            if (((Object)this.comparator).equals(oc.comparator) && this.comparator.compare(this.getLegalValues(), oc.getLegalValues()) == 0) {
                equal = true;
            }
        } else if (o instanceof ConstraintGroup) {
            ConstraintGroup og = (ConstraintGroup)o;
            boolean bl = equal = og.constraints.size() == 1;
            if (equal) {
                equal = this.equals(og.constraints.get(0));
            }
        }
        return equal;
    }

    Object cloneAsNeeded(boolean sameParameter) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }

    static {
        DEFAULT_COMP = CASE_INSENSITIVE = Comparators.STRING_INSENSITIVE;
    }
}

