/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Iterator;
import java.util.List;

abstract class Errors {
    static final String BROKEN_IF_ELSE = "Broken IF-ELSE statement.";
    static final String BROKEN_XPATH = "Broken XPATH expression.";
    static final String EMPTY_OR_MALFORMED = "Document is either empty or malformed.";
    static final String DUPLICATE_PARAM = "Initialization document contains one or more parameters with the same tag name.  Parameter tag names must be unique.";
    static final String UNSUPPORTED_CONTEXT = "Unsupported context.";

    Errors() {
    }

    static String DuplicateParam(String parentTag, String childTag) {
        return "Element <" + parentTag + "> contains more than one <" + childTag + "> element.  Parameter tag names must be unique.";
    }

    static String IllegalText(String tagName) {
        return "Element <" + tagName + "> has illegal child text node.";
    }

    static String IllegalNode(String tagName, String description) {
        return "Element <" + tagName + "> has illegal child node '" + description + ".";
    }

    static String IllegalElement(String parentTagName, String illegalTagName) {
        return "Element <" + parentTagName + "> has illegal child element <" + illegalTagName + ">.";
    }

    /*
     * WARNING - void declaration
     */
    static String MisplacedElement(String parentTagName, String childTagName, int position) {
        void var3_3;
        String suffix;
        if (position > 3) {
            suffix = "th";
        } else if (position == 1) {
            suffix = "st";
        } else if (position == 2) {
            suffix = "nd";
        } else if (position == 3) {
            suffix = "rd";
        } else {
            throw new RuntimeException(Errors.ParamOutOfRange("position", String.valueOf(position)));
        }
        return "Misplaced child element.  Element <" + childTagName + "> must be the " + position + (String)var3_3 + " child element of element <" + parentTagName + ">.";
    }

    static String WrongContext(String requiredContext) {
        return "Method invoked out-of-context.  Required context:  " + requiredContext + ".";
    }

    static String WrongDTDVersion(String requiredVersion) {
        return "Method requires document DTD version " + requiredVersion + " or later.";
    }

    static String BadBooleanType(String bool) {
        return "Unsupported boolean type '" + bool + "'.";
    }

    static String BadValueType(String type) {
        return "Unsupported value type '" + type + "'.";
    }

    static String NoText(String tagName) {
        return "Element <" + tagName + "> missing required text node.";
    }

    static String UnsupportedType(String type) {
        return "Unsuported type '" + type + "'.";
    }

    static String NoElement(String tagName) {
        return "Missing required element <" + tagName + ">.";
    }

    static String TooManyElement(String parent, String tagName) {
        return "Element <" + parent + "> contains too many <" + tagName + "> elements.";
    }

    static String DuplicateElement(String tagName) {
        return "Element <" + tagName + "> multiply defined.";
    }

    static String NoChildElements(String tagName) {
        return "Element <" + tagName + "> missing required child element.";
    }

    static String NoAttributeValue(String attribute) {
        return "Attribute '" + attribute + "' missing required value.";
    }

    static String BadAttributeValue(String attribute, String value) {
        return "Attribute '" + attribute + "' has an illegal value '" + value + "'.";
    }

    static String NoAttribute(String attribute) {
        return "Missing required attribute '" + attribute + "'.";
    }

    static String NoParamValue(String paramName) {
        return "No value passed for parameter '" + paramName + "'.";
    }

    static String NoParam(String paramName) {
        return "Missing required parameter element <" + paramName + ">.";
    }

    static String ParamOutOfRange(String paramName, String value) {
        return "Out-of-range value '" + value + "' for parameter '" + paramName + "'.";
    }

    static String ReqTypeStructured() {
        return "A value element must have a 'type' attribute value of 'structured' to contain 'component' child elements.";
    }

    static String ReqTypeDN() {
        return "A value element must have a 'type' attribute value of 'dn' to have an 'association-ref' attribute value.";
    }

    static String ParamConstraintTypeMismatch(List types, Parameter p) {
        if (types == null || types.isEmpty() || p == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Data type mismatch.  Constraints of type");
        if (types.size() > 1) {
            buffer.append("s ");
            boolean first = false;
            Iterator i = types.iterator();
            while (i.hasNext()) {
                DataType t = (DataType)i.next();
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append("'");
                buffer.append(t);
                buffer.append("'");
            }
        } else {
            buffer.append(" '");
            buffer.append(types.get(0));
            buffer.append("'");
        }
        buffer.append(" cannot be applied to parameters of type '");
        buffer.append(p.getType());
        buffer.append("'.");
        buffer.append(".");
        return buffer.toString();
    }
}

