/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;

final class FloatConstraint
extends Constraint {
    FloatConstraint() {
        this.setOperator(LogicalOp.AND);
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        boolean valid = true;
        if (someValue != null && someValue.getClass() != Float.class) {
            try {
                String string = someValue.toString();
                if (string == null) {
                    valid = false;
                    typedValue[0] = null;
                } else {
                    typedValue[0] = new Float(string.trim());
                }
            }
            catch (NumberFormatException nfe) {
                valid = false;
            }
        }
        return valid;
    }

    String getLegalValues() {
        return "1.4E-45...3.4028235E38";
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClass() == o.getClass();
    }

    Object cloneAsNeeded(boolean sameParameter) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return true;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

