/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.Context;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib_1_4;
import com.novell.nds.dirxml.driver.xds.NonXDSElement;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSInstanceElement;
import com.novell.nds.dirxml.driver.xds.XDSMethodInvocationContextException;
import com.novell.nds.dirxml.driver.xds.XDSModifyAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryTokenElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.XDSValueElement;
import com.novell.nds.dirxml.driver.xds._Boolean;
import com.novell.nds.dirxml.driver.xds.util.Java;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class Lib {
    private static final String NO_VALUE = "_";

    Lib() {
    }

    static int NormalizeCompare(long value) {
        if (value < 0L) {
            return -1;
        }
        if (value > 0L) {
            return 1;
        }
        return 0;
    }

    static int NormalizeCompare(double value) {
        if (value < 0.0) {
            return -1;
        }
        if (value > 0.0) {
            return 1;
        }
        return 0;
    }

    static ElementImpl OptionsElement_parseChildElement(ElementImpl parent, Element childElement, String tagName, int position, int noOfElements, List[] params, List[] instances) throws XDSParseException {
        ElementImpl child = null;
        if ("instance".compareTo(tagName) == 0) {
            if (instances[0] == Collections.EMPTY_LIST) {
                instances[0] = new LinkedList();
            }
            child = new XDSInstanceElement(childElement, parent.document);
            instances[0].add(child);
        } else {
            if (params[0] == Collections.EMPTY_LIST) {
                params[0] = new ArrayList(noOfElements);
            }
            child = new NonXDSElement(childElement, parent.document);
            params[0].add(child);
        }
        return child;
    }

    static void ExtractParams(ElementImpl impl, Map[] paramElementMap, List[] paramElemenList, Map parameters) throws XDSParameterException {
        Lib.CheckContext(impl.document.context, 0);
        if (paramElemenList != null) {
            Lib.ExtractParams(impl, paramElementMap, paramElemenList[0], parameters);
        }
    }

    static void ExtractParams(ElementImpl impl, Map[] paramElementMap, List paramElementList, Map parameters) throws XDSParameterException {
        Lib.CheckContext(impl.document.context, 0);
        if (paramElementMap != null && paramElementList != null) {
            Lib.ParamParent_populateMap(impl, paramElementMap, paramElementList);
            Lib.ExtractParams(paramElementMap[0], paramElementList, parameters);
        }
    }

    static void ExtractParams(Map paramElementMap, List paramElementList, Map parameters) throws XDSParameterException {
        Lib.CheckParam(parameters, "params");
        XDSParameterException xds = new XDSParameterException();
        if (Java.isJRE(1, 4)) {
            Lib_1_4.ExtractParams(paramElementList, parameters, xds);
        } else {
            Lib.ExtractParams_1_2(paramElementMap, parameters, xds);
        }
        Lib.ApplyConstraints(parameters, xds);
        if (xds.getNext() != null) {
            throw xds.getNext();
        }
    }

    static XDSException ApplyConstraints(Map parameters, XDSException currentException) {
        Iterator i = parameters.values().iterator();
        while (i.hasNext()) {
            for (Parameter p = (Parameter)i.next(); p != null; p = p.getNext()) {
                currentException = p.applyConstraints(currentException);
            }
        }
        return currentException;
    }

    static void ExtractParams_1_2(Map paramElements, Map parameters, XDSException currentException) {
        Iterator entries = parameters.values().iterator();
        while (entries.hasNext()) {
            currentException = Lib.ExtractParam_1_2(paramElements, (Parameter)entries.next(), currentException);
        }
    }

    static XDSException ExtractParam_1_2(Map paramElements, Parameter currentParam, XDSException currentException) {
        ParamElement paramElement = (ParamElement)paramElements.get(currentParam.tagName());
        if (paramElement != null) {
            currentParam.setParamElement(paramElement);
            currentParam.setDisplayName(paramElement.getDisplayName());
            currentParam.setValue(paramElement.extractText());
        }
        return currentException;
    }

    static ElementImpl StateElement_parseChildElement(ElementImpl parent, Element childElement, String tagName, int position, int noOfElements, List[] params) throws XDSParseException {
        NonXDSElement param = new NonXDSElement(childElement, parent.document);
        if (params[0] == Collections.EMPTY_LIST) {
            params[0] = new ArrayList(noOfElements);
        }
        params[0].add(param);
        return param;
    }

    private static void ParamParent_populateMap(ElementImpl parent, Map[] maps, List list) throws XDSParameterException {
        if (maps[0] == XDS.EMPTY_MAP && list.size() > 0) {
            maps[0] = new HashMap(list.size());
            ListIterator p = list.listIterator();
            while (p.hasNext()) {
                ParamElement param = (ParamElement)p.next();
                ParamElement o = maps[0].put(param.tagName(), param);
                if (o == null) continue;
                throw new XDSParameterException(Errors.DuplicateParam(parent.tagName(), param.tagName()));
            }
        }
    }

    static ParamElement ParamParent_paramElement(ElementImpl impl, Map[] maps, List[] lists, String tagName) throws XDSParameterException {
        Lib.CheckContext(impl.document.context, 0);
        if (lists == null) {
            return null;
        }
        return Lib.ParamParent_paramElement(impl, maps, lists[0], tagName);
    }

    static ParamElement ParamParent_paramElement(ElementImpl impl, Map[] maps, List list, String tagName) throws XDSParameterException {
        ParamElement returnVal;
        Lib.CheckContext(impl.document.context, 0);
        if (maps == null) {
            returnVal = null;
        } else {
            Lib.ParamParent_populateMap(impl, maps, list);
            returnVal = (ParamElement)maps[0].get(tagName);
        }
        return returnVal;
    }

    static String ParamParent_paramText(ElementImpl impl, Map[] maps, List[] lists, String tagName) throws XDSParameterException {
        Lib.CheckContext(impl.document.context, 0);
        if (lists == null) {
            return null;
        }
        return Lib.ParamParent_paramText(impl, maps, lists[0], tagName);
    }

    static String ParamParent_paramText(ElementImpl impl, Map[] maps, List list, String tagName) throws XDSParameterException {
        Lib.CheckContext(impl.document.context, 0);
        ParamElement element = Lib.ParamParent_paramElement(impl, maps, list, tagName);
        return element == null ? null : element.extractText();
    }

    static String GetText(ElementImpl impl, TextParent parent) {
        Lib.CheckContext(impl.document.context, 0);
        if (parent == null) {
            return null;
        }
        return parent.extractText();
    }

    static boolean GetValue(ElementImpl impl, _Boolean bool) {
        Lib.CheckContext(impl.document.context, 0);
        if (bool == null) {
            return false;
        }
        return bool.toPrimitive();
    }

    static String GetValue(ElementImpl impl, String value) {
        Lib.CheckContext(impl.document.context, 0);
        return value;
    }

    static String GetAttributeValue(ElementImpl impl, String attrName) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet(attrName);
    }

    static void CheckParam(String param, String paramName) {
        if (param == null || "".compareTo(param) == 0) {
            throw new IllegalArgumentException(Errors.NoParamValue(paramName));
        }
    }

    public static String ToNull(String someValue) {
        if (Lib.NoValue(someValue)) {
            return null;
        }
        return someValue;
    }

    static boolean IsParamValue(String someValue) {
        return Lib.IsValue(someValue) && NO_VALUE.compareTo(someValue) != 0;
    }

    static boolean NoParamValue(String someValue) {
        return Lib.NoValue(someValue) || NO_VALUE.compareTo(someValue) == 0;
    }

    static boolean IsValue(String someValue) {
        return someValue != null && "".compareTo(someValue) != 0;
    }

    static boolean NoValue(String someValue) {
        return someValue == null || "".compareTo(someValue) == 0;
    }

    static void CheckParam(Object obj, String paramName) {
        if (obj == null) {
            throw new IllegalArgumentException(Errors.NoParamValue(paramName));
        }
    }

    static void AssociationElementParent_validate(ElementImpl parent, XDSAssociationElement association, int noOfAssociations, boolean required) throws XDSParseException {
        if (association != null) {
            if (noOfAssociations > 1) {
                throw new XDSParseException(Errors.DuplicateElement("association"));
            }
            if (parent.document.isStrict() && association.position() != 1) {
                throw new XDSParseException(Errors.MisplacedElement(parent.tagName(), "association", 1));
            }
        }
    }

    static XDSAssociationElement AssociationElementParent_appendAssociationElement(ElementImpl impl, String value) {
        Lib.CheckParam(impl, "impl");
        Lib.CheckParam(impl.document, "impl.document");
        Lib.CheckParam(impl.element, "impl.element");
        Lib.CheckContext(impl.document.context, 1);
        XDSAssociationElement association = new XDSAssociationElement(impl.document, impl.element);
        association.appendText(value);
        return association;
    }

    static XDSAssociationElement AssociationElementParent_associationElement(ElementImpl impl, XDSAssociationElement association) {
        Lib.CheckContext(impl.document.context, 0);
        return association;
    }

    static String TextParent_extractText(ElementImpl impl, TextParent parent) {
        Lib.CheckContext(impl.document.context, 0);
        if (parent == null) {
            return null;
        }
        return parent.extractText();
    }

    static void CheckVersion(DTDVersion actual, DTDVersion expected) {
        if (actual.compareTo(expected) == -1) {
            throw new XDSMethodInvocationContextException(Errors.WrongDTDVersion(expected.toString()));
        }
    }

    static void CheckContext(int actual, int expected) {
        if (actual != expected) {
            throw new XDSMethodInvocationContextException(Errors.WrongContext(Context.ToString(expected)));
        }
    }

    static List GetElements(DocumentImpl impl, List elements) {
        Lib.CheckContext(impl.context, 0);
        return elements;
    }

    static List GetElements(DocumentImpl impl, List[] elements) {
        Lib.CheckContext(impl.context, 0);
        if (elements == null) {
            return Collections.EMPTY_LIST;
        }
        return Lib.GetElements(impl, elements[0]);
    }

    static List GetElements(ElementImpl impl, List elements) {
        Lib.CheckContext(impl.document.context, 0);
        if (elements == null) {
            return Collections.EMPTY_LIST;
        }
        return elements;
    }

    static List GetElements(ElementImpl impl, List[] elements) {
        Lib.CheckContext(impl.document.context, 0);
        if (elements == null) {
            return Collections.EMPTY_LIST;
        }
        return Lib.GetElements(impl, elements[0]);
    }

    static List ValueElementParent_extractValueElements(ElementImpl impl, List[] elements) {
        Lib.CheckContext(impl.document.context, 0);
        if (elements == null) {
            return Collections.EMPTY_LIST;
        }
        return elements[0];
    }

    static XDSValueElement ValueElementParent_appendValueElement(ElementImpl impl, ValueType type, String text) {
        Lib.CheckParam(impl, "impl");
        Lib.CheckContext(impl.document.context, 1);
        XDSValueElement value = new XDSValueElement(impl.document, impl.element, type);
        if (text != null) {
            value.appendText(text);
        }
        return value;
    }

    static ElementImpl ValueElementParent_parseChildElement(ElementImpl parent, Element childElement, String tagName, int noOfElements, List[] values) throws XDSParseException {
        XDSValueElement child = null;
        if ("value".compareTo(tagName) == 0) {
            child = new XDSValueElement(childElement, parent.document);
            if (values[0] == Collections.EMPTY_LIST) {
                values[0] = new ArrayList(noOfElements);
            }
            values[0].add(child);
        }
        return child;
    }

    static void ValueElementsParent_validate(ElementImpl impl) throws XDSParseException {
        if (impl.children() == Collections.EMPTY_LIST) {
            throw new XDSParseException(Errors.NoElement("value"));
        }
    }

    static void TextParent_appendText(ElementImpl impl, String pcdata) {
        Lib.CheckContext(impl.document.context, 1);
        if (Lib.NoValue(pcdata)) {
            return;
        }
        Text text = impl.document.document.createTextNode(pcdata);
        impl.element.appendChild(text);
    }

    static String TextParent_text(ElementImpl impl, String text) {
        Lib.CheckContext(impl.document.context, 0);
        return Lib.ToNull(text);
    }

    static String SomeAttrElement_getAttrName(ElementImpl impl, String attrName) {
        Lib.CheckContext(impl.document.context, 0);
        return attrName;
    }

    static void SomeAttrElement_setAttrName(ElementImpl impl, String value) {
        Lib.CheckContext(impl.document.context, 1);
        impl.attributeValueSet("attr-name", value);
    }

    static void SomeAttrElement_validate(ElementImpl impl, String attrName) throws XDSParseException {
        if (attrName == null) {
            impl.throwMissingAttributeException("attr-name");
        }
    }

    static XmlDocument WriteableDocument_toXML(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 1);
        return new XmlDocument(impl.document);
    }

    static XDSModifyAssociationElement WriteableDocument_appendModifyAssociationElement(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 1);
        return new XDSModifyAssociationElement(impl, impl.ioElement);
    }

    static XDSInitParamsElement StateDocument_appendInitParamsElement(DocumentImpl impl, XDSInitParamsElement[] initParams) {
        Lib.CheckContext(impl.context, 1);
        if (initParams[0] == null) {
            initParams[0] = new XDSInitParamsElement(impl, impl.ioElement);
        }
        return initParams[0];
    }

    static XDSSourceElement WriteableDocument_appendSourceElement(DocumentImpl impl, XDSSourceElement source) {
        Lib.CheckContext(impl.context, 1);
        if (source == null) {
            source = new XDSSourceElement(impl, impl.rootElement);
            Element element = source.domElement();
            impl.rootElement.removeChild(element);
            impl.rootElement.insertBefore(element, impl.ioElement);
        }
        return source;
    }

    static XDSStatusElement StatusDocument_appendHeartbeat(DocumentImpl impl) {
        XDSStatusElement status = Lib.StatusDocument_appendStatusElement(impl);
        status.setLevel(StatusLevel.SUCCESS);
        status.setType(StatusType.HEARTBEAT);
        return status;
    }

    static XDSStatusElement StatusDocument_appendStatusElement(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 1);
        return new XDSStatusElement(impl, impl.ioElement);
    }

    static void WriteableDocument_setEmpty(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 1);
        Element newElement = impl.document.createElement(impl.tagName);
        impl.rootElement.replaceChild(newElement, impl.ioElement);
        impl.ioElement = newElement;
    }

    static void CommandElement_setEventID(ElementImpl impl, String someID) {
        impl.attributeValueSet("event-id", someID);
    }

    static String CommandElement_getEventID(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet("event-id");
    }

    static String CommandElement_getSrcDN(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet("src-dn");
    }

    static String CommandElement_getQualifiedSrcDN(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet("qualified-src-dn");
    }

    static String CommandElement_getSrcEntryID(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet("src-entry-id");
    }

    static String CommandElement_getClassName(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet("class-name");
    }

    static XDSPasswordElement PasswordElementParent_passwordElement(ElementImpl impl, XDSPasswordElement password) {
        Lib.CheckContext(impl.document.context, 0);
        return password;
    }

    static String PasswordElementParent_passwordText(ElementImpl impl, XDSPasswordElement password) {
        return Lib.GetText(impl, password);
    }

    static DTDVersion ReadableDocument_dtdVersion(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 0);
        return impl.version;
    }

    static XDSSourceElement ReadableDocument_sourceElement(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 0);
        return impl.source;
    }

    static void QueryResultDocument_Sort(Map map) {
        Iterator status = map.values().iterator();
        while (status.hasNext()) {
            List levels = (List)status.next();
            Collections.sort(levels);
        }
    }

    private static void QueryResultDocument_PopulateMap(Map[] map, List elements) {
        if (map[0] == XDS.EMPTY_MAP) {
            map[0] = new HashMap(elements.size());
            ListIterator l = elements.listIterator();
            while (l.hasNext()) {
                XDSStatusElement status = (XDSStatusElement)l.next();
                String eventID = status.getEventID();
                if (eventID == null) continue;
                LinkedList<XDSStatusElement> levels = (LinkedList<XDSStatusElement>)map[0].get(eventID);
                if (levels == null) {
                    levels = new LinkedList<XDSStatusElement>();
                    levels.add(status);
                    map[0].put(eventID, levels);
                    continue;
                }
                levels.add(status);
            }
            Lib.QueryResultDocument_Sort(map[0]);
        }
    }

    public static StatusLevel ResultDocument_mostSevereStatusLevel(DocumentImpl impl, String id, Map[] map, List[] lists, XDSStatusElement[] mostSevere) {
        XDSStatusElement element = Lib.ResultDocument_mostSevereStatusElement(impl, id, map, lists, mostSevere);
        return element == null ? StatusLevel.SUCCESS : element.getLevel();
    }

    static List QueryResultDocument_extractQueryTokenElements(DocumentImpl impl, List[] lists) {
        Lib.CheckContext(impl.context, 0);
        if (lists != null && lists[0] != null && !lists[0].isEmpty()) {
            return lists[0];
        }
        return Collections.EMPTY_LIST;
    }

    static boolean QueryResultDocument_containsQueryTokenElements(DocumentImpl impl, List[] lists) {
        Lib.CheckContext(impl.context, 0);
        if (lists == null || lists[0] == null) {
            return false;
        }
        return !lists[0].isEmpty();
    }

    static boolean QueryResultDocument_containsQueryToken(DocumentImpl impl, List[] lists, String matchToken) {
        Lib.CheckContext(impl.context, 0);
        boolean match = false;
        if (lists != null && lists[0] != null && matchToken != null) {
            Iterator i = lists[0].iterator();
            while (i.hasNext()) {
                XDSQueryTokenElement queryToken = (XDSQueryTokenElement)i.next();
                String candidateToken = queryToken.extractText();
                if (!matchToken.equals(candidateToken)) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    static XDSStatusElement ResultDocument_mostSevereStatusElement(DocumentImpl impl, String id, Map[] maps, List[] lists, XDSStatusElement[] mostSevere) {
        Lib.CheckContext(impl.context, 0);
        XDSStatusElement returnVal = null;
        if (maps != null && lists != null && mostSevere != null && lists[0] != null) {
            Lib.QueryResultDocument_PopulateMap(maps, lists[0]);
            List levels = (List)maps[0].get(id);
            returnVal = levels != null && !levels.isEmpty() ? (XDSStatusElement)levels.get(0) : mostSevere[0];
        }
        return returnVal;
    }

    static List QueryResultDocument_extractStatusElements(DocumentImpl impl, Map[] maps, List[] lists, String someID) {
        Lib.CheckContext(impl.context, 0);
        List returnVal = Collections.EMPTY_LIST;
        if (maps != null && lists != null && lists[0] != null) {
            Lib.QueryResultDocument_PopulateMap(maps, lists[0]);
            List list = (List)maps[0].get(someID);
            if (list != null) {
                returnVal = list;
            }
        }
        return returnVal;
    }

    static ElementImpl QueryResultDocument_parseChildElement(DocumentImpl doc, Element domElement, String tagName, int position, int noOfElements, List[] statusElements, List[] instanceElements, XDSStatusElement[] mostSevere, List[] queryToken) throws XDSParseException {
        ElementImpl child = null;
        if ("status".compareTo(tagName) == 0) {
            child = new XDSStatusElement(domElement, doc);
            if (mostSevere[0] == null) {
                mostSevere[0] = child;
            } else {
                ElementImpl elementImpl = mostSevere[0] = mostSevere[0].compareTo(child) == 1 ? child : mostSevere[0];
            }
            if (statusElements[0] == Collections.EMPTY_LIST) {
                statusElements[0] = new LinkedList();
            }
            statusElements[0].add(child);
        } else if ("instance".compareTo(tagName) == 0) {
            if (instanceElements[0] == Collections.EMPTY_LIST) {
                instanceElements[0] = new LinkedList();
            }
            child = new XDSInstanceElement(domElement, doc);
            instanceElements[0].add(child);
        } else if ("query-token".compareTo(tagName) == 0) {
            if (queryToken[0] == Collections.EMPTY_LIST) {
                queryToken[0] = new LinkedList();
            }
            child = new XDSQueryTokenElement(domElement, doc);
            queryToken[0].add(child);
        }
        return child;
    }

    static Node CloneSubtree(Document targetDoc, Node sourceRoot) {
        try {
            switch (sourceRoot.getNodeType()) {
                case 1: {
                    Element sourceElement = (Element)sourceRoot;
                    Element clonedElement = targetDoc.createElement(sourceElement.getNodeName());
                    NamedNodeMap attributes = sourceElement.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Attr attr = (Attr)attributes.item(i);
                        clonedElement.setAttribute(attr.getName(), attr.getValue());
                    }
                    NodeList children = sourceElement.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        clonedElement.appendChild(Lib.CloneSubtree(targetDoc, children.item(i)));
                    }
                    return clonedElement;
                }
                case 2: {
                    Attr clonedAttr = targetDoc.createAttribute(((Attr)sourceRoot).getName());
                    clonedAttr.setValue(((Attr)sourceRoot).getValue());
                    return clonedAttr;
                }
                case 3: {
                    return targetDoc.createTextNode(((Text)sourceRoot).getData());
                }
                case 4: {
                    return targetDoc.createCDATASection(((CDATASection)sourceRoot).getData());
                }
                case 5: {
                    return targetDoc.createEntityReference(sourceRoot.getNodeName());
                }
                case 7: {
                    return targetDoc.createProcessingInstruction(sourceRoot.getNodeName(), sourceRoot.getNodeValue());
                }
                case 8: {
                    return targetDoc.createComment(sourceRoot.getNodeValue());
                }
                case 11: {
                    DocumentFragment clonedFragment = targetDoc.createDocumentFragment();
                    NodeList children = sourceRoot.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        clonedFragment.appendChild(Lib.CloneSubtree(targetDoc, children.item(i)));
                    }
                    return clonedFragment;
                }
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    static XDSInstanceElement QueryResultDocument_appendInstanceElement(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 1);
        return new XDSInstanceElement(impl, impl.ioElement);
    }

    static XDSQueryTokenElement QueryTokenParent_appendQueryTokenElement(DocumentImpl impl, Element parent, String someToken) {
        Lib.CheckContext(impl.context, 1);
        Lib.CheckVersion(impl.version, DTDVersion.V2_0);
        XDSQueryTokenElement queryToken = new XDSQueryTokenElement(impl, parent);
        queryToken.appendText(someToken);
        return queryToken;
    }

    static String ParamElement_getDisplayName(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet("display-name");
    }

    static boolean ParamElement_isContentSensitive(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return "true".equals(impl.attributeValueGet("is-sensitive"));
    }

    static boolean ParamElement_isPasswordRef(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return "password-ref".equals(impl.attributeValueGet("type"));
    }

    static boolean ParamElement_hasContent(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.element.getChildNodes().getLength() > 0;
    }

    static boolean AreEquivalent(Parameter p1, Parameter p2, boolean inheritConstraints) {
        boolean equivalent = false;
        if (p1 != null && p2 != null) {
            boolean bl = equivalent = p1.getType() == p2.getType();
            if (equivalent && inheritConstraints) {
                boolean bl2 = equivalent = p1.getNumConstraints() == p2.getNumConstraints();
                if (equivalent) {
                    Iterator i = p1.getConstraints().iterator();
                    while (i.hasNext()) {
                        Constraint c = (Constraint)i.next();
                        if (p2.hasConstraint(c)) continue;
                        equivalent = false;
                        break;
                    }
                }
            }
        }
        return equivalent;
    }
}

