/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RegExConstraint;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class Lib_1_4 {
    Lib_1_4() {
    }

    static XDSException ExtractParams(List paramElements, Map parameters, XDSException currentException) {
        Iterator p = parameters.values().iterator();
        while (p.hasNext()) {
            currentException = Lib_1_4.ExtractParam(paramElements, (Parameter)p.next(), currentException);
        }
        return currentException;
    }

    private static XDSException ExtractParam(List paramElements, Parameter currentParam, XDSException currentException) {
        ParamElement element;
        Pattern matchPattern = currentParam.isStructured() ? Pattern.compile(currentParam.matchRegEx() + ".*") : Pattern.compile(currentParam.matchRegEx());
        ArrayList<ParamElement> omatches = new ArrayList<ParamElement>(paramElements.size());
        Iterator o = paramElements.iterator();
        while (o.hasNext()) {
            element = (ParamElement)o.next();
            if (!matchPattern.matcher(element.tagName()).matches()) continue;
            omatches.add(element);
        }
        if (omatches.isEmpty()) {
            return currentException;
        }
        if (currentParam.isStructured() || currentParam.isMultiValued()) {
            if (currentParam.isStructured()) {
                if (currentParam.isSingleValued()) {
                    currentException = Lib_1_4.FilterMatches(omatches, currentParam, currentException);
                    currentException = Lib_1_4.ExtractParams(omatches, currentParam.getParameterMap(), currentException);
                } else {
                    int instanceID = Integer.MIN_VALUE;
                    ArrayList<ParamElement> imatches = null;
                    o = omatches.iterator();
                    while (o.hasNext()) {
                        element = (ParamElement)o.next();
                        if (instanceID == Integer.MIN_VALUE) {
                            instanceID = Lib_1_4.GetInstanceID(element, Pattern.compile(currentParam.instanceRegEx()));
                            if (instanceID == Integer.MIN_VALUE) {
                                XDSParameterException nextException = new XDSParameterException("Parameter " + currentParam.getParamInfo() + " has an element with an illegal instance id " + instanceID + ".  Instance ids must be non-negative integers.");
                                currentException.setNextException(nextException);
                                currentException = nextException;
                            } else {
                                matchPattern = instanceID > -1 ? Pattern.compile(currentParam.instanceRegEx() + '_' + instanceID + "(?!\\d).*") : Pattern.compile(currentParam.instanceRegEx() + "(\\..*|$)");
                                currentParam.setInstanceID(instanceID);
                                currentParam.addParamElement(element);
                                imatches = new ArrayList<ParamElement>(omatches.size());
                                imatches.add(element);
                            }
                            o.remove();
                        } else if (matchPattern.matcher(element.tagName()).matches()) {
                            currentParam.addParamElement(element);
                            imatches.add(element);
                            o.remove();
                        }
                        if (o.hasNext()) continue;
                        currentException = Lib_1_4.ExtractParams(imatches, currentParam.getParameterMap(), currentException);
                        if (omatches.isEmpty()) continue;
                        Parameter nextParam = (Parameter)currentParam.cloneInstance(true);
                        currentParam.setNext(nextParam);
                        currentParam = nextParam;
                        o = omatches.iterator();
                        instanceID = Integer.MIN_VALUE;
                    }
                }
            } else {
                o = omatches.iterator();
                while (o.hasNext()) {
                    element = (ParamElement)o.next();
                    currentParam.addParamElement(element);
                    if (currentParam.getDisplayName() == null) {
                        currentParam.setDisplayName(element.getDisplayName());
                    }
                    currentParam.addValue(element.extractText());
                }
            }
        } else {
            XDSParameterException nextException;
            int instanceID = Integer.MIN_VALUE;
            o = omatches.iterator();
            if (omatches.size() > 1) {
                nextException = new XDSParameterException("Single-valued, non-structured parameters should consist of at most one element.  Parameter " + currentParam.getParamInfo() + " consists of " + omatches.size() + " elements.");
                currentException.setNextException(nextException);
                currentException = nextException;
            }
            if ((instanceID = Lib_1_4.GetInstanceID(element = (ParamElement)o.next(), Pattern.compile(currentParam.instanceRegEx()))) == Integer.MIN_VALUE) {
                nextException = new XDSParameterException("Parameter " + currentParam.getParamInfo() + " has an element '" + element.tagName() + "' with illegal instance id " + instanceID + ".  Instance ids must be non-negative integers.");
                currentException.setNextException(nextException);
                currentException = nextException;
            } else {
                currentParam.setInstanceID(instanceID);
                currentParam.setParamElement(element);
                String description = element.getDisplayName();
                if (description != null) {
                    currentParam.setDisplayName(description);
                }
                currentParam.setValue(element.extractText());
            }
        }
        return currentException;
    }

    private static XDSException FilterMatches(List paramElements, Parameter currentParam, XDSException currentException) {
        Pattern pattern = Pattern.compile(currentParam.instanceRegEx());
        int currentID = -1;
        int validID = Integer.MIN_VALUE;
        Iterator i = paramElements.iterator();
        while (i.hasNext()) {
            XDSParameterException nextException;
            ParamElement element = (ParamElement)i.next();
            currentID = Lib_1_4.GetInstanceID(element, pattern);
            if (currentID == Integer.MIN_VALUE) {
                nextException = new XDSParameterException("Parameter " + currentParam.getParamInfo() + " contains an element '" + element.tagName() + "' with an illegal instance id.  " + "Instance ids must be non-negative integers.");
                currentException.setNextException(nextException);
                currentException = nextException;
                i.remove();
                continue;
            }
            if (validID == Integer.MIN_VALUE) {
                validID = currentID;
                continue;
            }
            if (currentID == validID) continue;
            nextException = validID == -1 ? new XDSParameterException("Single-valued, structured parameter elements must have the same instance id.  Element '" + element.tagName() + "' of parameter " + currentParam.getParamInfo() + " should NOT have an instance id.") : new XDSParameterException("Single-valued, structured parameter elements must have the same instance id.  Element '" + element.tagName() + "' of parameter " + currentParam.getParamInfo() + " should have instance id " + validID + ".");
            currentException.setNextException(nextException);
            currentException = nextException;
            i.remove();
        }
        if (validID > -1) {
            currentParam.setInstanceID(validID);
        }
        return currentException;
    }

    private static int GetInstanceID(ParamElement element, Pattern pattern) {
        int id = -1;
        String[] tokens = pattern.split(element.tagName(), 2);
        if (tokens.length > 1) {
            id = Lib_1_4.ParseInstanceID(tokens[1]);
        }
        return id;
    }

    private static int ParseInstanceID(String token) {
        int id = -1;
        if (token != null && token.length() > 0) {
            int begin = token.charAt(0) == '_' ? 1 : 0;
            int end = token.indexOf(".");
            if (end == -1) {
                end = token.length();
            }
            if (begin == end) {
                if (begin == 1) {
                    id = Integer.MIN_VALUE;
                }
            } else {
                try {
                    id = Integer.parseInt(token.substring(begin, end));
                }
                catch (IllegalArgumentException iae) {
                    id = Integer.MIN_VALUE;
                }
            }
        }
        return id;
    }

    static Constraint newCaseInsensitiveRegExConstraint(String pattern) {
        RegExConstraint regx = new RegExConstraint(pattern, 66);
        return regx;
    }
}

