/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Comparators;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Maps;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public final class MultiUniqueConstraint
extends Constraint {
    private Comparator comparator;
    private Set values;

    public MultiUniqueConstraint(DataType someType, Comparator someComparator) {
        Lib.CheckParam(someType, "someType");
        this.setType(someType);
        this.setComparator(someComparator);
        this.setValues();
        this.setNOT();
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    public MultiUniqueConstraint(DataType someType) {
        this.setType(someType);
        this.setComparator(null);
        this.setValues();
        this.setNOT();
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    protected void setType(DataType someType) {
        if (someType == DataType.STRUCT) {
            throw new IllegalArgumentException("Type 'struct' is not supported.");
        }
        if (someType == DataType.ANY) {
            throw new IllegalArgumentException("Type 'any' is not supported.");
        }
        super.setType(someType);
    }

    private void setValues() {
        this.values = new TreeSet(this.comparator);
    }

    private void setComparator(Comparator someComparator) {
        if (someComparator == null) {
            someComparator = Maps.GetComparator(this.getType());
        }
        if (!Comparators.TestArgs(someComparator, this.getType())) {
            throw new IllegalArgumentException("Passed comparator does not accept arguments of type '" + this.getType().getJavaClass().getName() + "'.");
        }
        this.comparator = someComparator;
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        return someValue == null || this.values.add(someValue);
    }

    String getLegalValues() {
        StringBuffer buffer = new StringBuffer(this.values.size() * 16);
        boolean first = true;
        Iterator i = this.values.iterator();
        while (i.hasNext()) {
            String value = (String)i.next();
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            if (DataType.IsStringType(this.getType())) {
                buffer.append("'");
            }
            buffer.append(value);
            if (!DataType.IsStringType(this.getType())) continue;
            buffer.append("'");
        }
        return buffer.toString();
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    Comparator getComparator() {
        return this.comparator;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof MultiUniqueConstraint) {
            MultiUniqueConstraint oc = (MultiUniqueConstraint)o;
            equal = this.getType() == oc.getType() && ((Object)this.comparator).equals(oc.comparator);
        } else if (o instanceof ConstraintGroup) {
            ConstraintGroup og = (ConstraintGroup)o;
            boolean bl = equal = og.constraints.size() == 1;
            if (equal) {
                equal = this.equals(og.constraints.get(0));
            }
        }
        return equal;
    }

    Object cloneAsNeeded(boolean sameParameter) {
        throw new IllegalStateException("MultiUniqueConstraints constraints cannot be cloned.");
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return true;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

