/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.Constraints;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.EnumConstraint;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Maps;
import com.novell.nds.dirxml.driver.xds.MultiRequiredConstraint;
import com.novell.nds.dirxml.driver.xds.MultiUniqueConstraint;
import com.novell.nds.dirxml.driver.xds.MultiValueConstraint;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.SingleValueConstraint;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.util.Java;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Parameter
implements Comparable,
Cloneable {
    private static final boolean DEFAULT_REQUIRED = false;
    private static final boolean DEFAULT_CONSTANT = false;
    private static final LogicalOp OP = LogicalOp.AND;
    public static int INSTANCE_ID_NONE = -1;
    private String tagName;
    private String displayName;
    private DataType type;
    private List values;
    private StringBuffer _buffer;
    private List constraints;
    private Set constraintSet;
    private List paramElements;
    private Parameter parent;
    private Parameter deflt;
    private Parameter next;
    private Map parameters;
    private Map isSetWhen;
    private boolean declaredSensitive;
    private boolean runtimeSensitive;
    private boolean set;
    private int instanceID;
    private boolean required;
    private boolean constant;
    private String defltValue;
    private Object[] typedValue;

    private Parameter() {
    }

    public Parameter(String someTagName, String defaultValue, DataType someType) {
        Lib.CheckParam(someTagName, "someTagName");
        Lib.CheckParam(someType, "someType");
        this.init();
        this.tagName = someTagName;
        this.setDelcaredSensitive();
        this.setType(someType);
        this.add(Maps.GetConstraint(this.type));
        this.add(new SingleValueConstraint());
        this.setDefault(defaultValue);
    }

    public Parameter(String someTagName, Parameter defaultValue, boolean inheritConstraints) {
        Lib.CheckParam(someTagName, "someTagName");
        Lib.CheckParam(defaultValue, "defaultValue");
        this.init();
        this.tagName = someTagName;
        this.setDelcaredSensitive();
        this.setType(defaultValue.getDataType());
        this.setDefault(defaultValue);
        this.setConstraints(inheritConstraints);
    }

    private void init() {
        this.instanceID = INSTANCE_ID_NONE;
        this.set = false;
        this.next = null;
        this.displayName = null;
        this.required = false;
        this.constant = false;
        this.values = Collections.EMPTY_LIST;
        this.parameters = XDS.EMPTY_MAP;
        this.isSetWhen = XDS.EMPTY_MAP;
        this.constraints = Collections.EMPTY_LIST;
        this.constraintSet = Collections.EMPTY_SET;
        this.paramElements = Collections.EMPTY_LIST;
        this.typedValue = new Object[1];
        this._buffer = new StringBuffer();
    }

    public void addIsSetWhen(Parameter p) {
        if (p == null) {
            return;
        }
        if (this.isScalar()) {
            throw new IllegalArgumentException("Is set when parameters can only be added to structured parameters.");
        }
        if (this.parameters.get(p.tagName()) != p) {
            throw new IllegalArgumentException("Is set when parameters MUST be members of this parameter.");
        }
        if (this.isSetWhen.isEmpty()) {
            this.isSetWhen = new HashMap();
        }
        this.isSetWhen.put(p.tagName(), p);
    }

    int getNumConstraints() {
        return this.constraints.size();
    }

    boolean hasConstraint(Constraint c) {
        return this.constraintSet.contains(c);
    }

    Collection getConstraints() {
        return this.constraints;
    }

    public DataType getType() {
        return this.type;
    }

    private void setConstraints(boolean inherit) {
        ListIterator l = this.deflt.constraints.listIterator();
        while (l.hasNext()) {
            Constraint c = (Constraint)l.next();
            if (!c.isType() && !inherit) continue;
            c = (Constraint)c.cloneAsNeeded(true);
            this.add(c);
        }
    }

    private void setDelcaredSensitive() {
        this.declaredSensitive = this.tagName.toLowerCase().indexOf("password") != -1;
    }

    public void setContentSensitive() {
        this.declaredSensitive = true;
        Iterator i = this.parameters.values().iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            p.setContentSensitive();
        }
    }

    public boolean isSet() {
        boolean isSet;
        if (this.isStructured()) {
            Parameter p;
            Iterator i = this.isSetWhen.isEmpty() ? this.parameters.values().iterator() : this.isSetWhen.values().iterator();
            for (isSet = false; i.hasNext() && !isSet; isSet |= p.isSet()) {
                p = (Parameter)i.next();
            }
        } else {
            isSet = this.set && !this.values.isEmpty();
        }
        return isSet;
    }

    public boolean hasContent() {
        boolean has;
        ParamElement element;
        Iterator i = this.paramElements().iterator();
        for (has = false; i.hasNext() && !has; has |= element.hasContent()) {
            element = (ParamElement)i.next();
        }
        return has;
    }

    public boolean hasValues() {
        boolean has;
        if (this.isStructured()) {
            Parameter p;
            Iterator i = this.parameters.values().iterator();
            for (has = false; i.hasNext() && !has; has |= p.hasValues()) {
                p = (Parameter)i.next();
            }
            if (!has && this.next != null) {
                has = this.next.hasValues();
            }
        } else {
            boolean bl = has = !this.values.isEmpty();
            if (!has && this.deflt != null) {
                has = this.deflt.hasValues();
            }
        }
        return has;
    }

    public boolean isStructured() {
        return this.type == DataType.STRUCT;
    }

    public boolean isScalar() {
        return this.type != DataType.STRUCT;
    }

    public boolean isSingleValued() {
        return this.constraintSet.contains(SingleValueConstraint.SINGLE_VALUE);
    }

    public boolean isMultiValued() {
        return this.constraintSet.contains(MultiValueConstraint.MULTI_VALUE);
    }

    void setInstanceID(int id) {
        this.instanceID = id;
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    public Parameter getParameter(String tagName) {
        return (Parameter)this.parameters.get(tagName);
    }

    public Collection getParameters() {
        return this.parameters.values();
    }

    Map getParameterMap() {
        return this.parameters;
    }

    public void add(Parameter p) {
        if (p == null) {
            return;
        }
        if (!this.isStructured()) {
            throw new IllegalArgumentException("Parameters can only be added to structured parameters.");
        }
        if (this.isDecendantOrSelf(p)) {
            throw new IllegalArgumentException("It's illegal to add a parameter as a componet of itself");
        }
        if (this.parameters.isEmpty()) {
            this.parameters = new HashMap();
        }
        p.setParent(this);
        this.parameters.put(p.tagName(), p);
    }

    boolean isDecendantOrSelf(Parameter p) {
        boolean descendantOrSelf = false;
        if (p == this) {
            descendantOrSelf = true;
        } else {
            Iterator i = this.parameters.values().iterator();
            while (i.hasNext()) {
                Parameter c = (Parameter)i.next();
                if (!c.isDecendantOrSelf(p)) continue;
                descendantOrSelf = true;
                break;
            }
        }
        return descendantOrSelf;
    }

    void setParent(Parameter p) {
        this.parent = p;
    }

    public boolean isContentSensitive() {
        return this.declaredSensitive || this.runtimeSensitive;
    }

    boolean isTyped() {
        return this.type != DataType.ANY && this.type != DataType.STRUCT;
    }

    boolean isUntyped() {
        return this.type == DataType.ANY;
    }

    private void checkConstraint(Constraint someConstraint) {
        List types;
        if (this.constraintSet.contains(someConstraint)) {
            return;
        }
        if (this.isStructured() && !someConstraint.forStructured()) {
            throw new IllegalArgumentException("Constraint type '" + someConstraint.getClass().getName() + "' cannot be applied to structured parameters.");
        }
        if (this.isScalar() && !someConstraint.forScalar()) {
            throw new IllegalArgumentException("Constraint type '" + someConstraint.getClass().getName() + "' cannot be applied to scalar parameters.");
        }
        if (this.isTyped() && someConstraint.isTyped() && !this.type.isCompatibleImpl(types = someConstraint.getTypes())) {
            throw new IllegalArgumentException(Errors.ParamConstraintTypeMismatch(types, this));
        }
        if (someConstraint.getClass() == EnumConstraint.class) {
            if (!DataType.IsEnumerativeType(this.type)) {
                throw new IllegalArgumentException("Cannot apply enumerative constraint to type 'boolean'.");
            }
            this.checkEnumValuesForType((EnumConstraint)someConstraint);
        } else if (someConstraint.getClass() == SingleValueConstraint.class) {
            this.removeConstraint(MultiValueConstraint.MULTI_VALUE);
        } else if (someConstraint.getClass() == MultiValueConstraint.class) {
            this.removeConstraint(SingleValueConstraint.SINGLE_VALUE);
        }
    }

    private void removeConstraint(Constraint c) {
        if (this.constraintSet.remove(c)) {
            this.constraints.remove(c);
        }
    }

    public boolean hasValue(Object o) {
        return this.values.contains(o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkEnumValuesForType(EnumConstraint enumConstraint) {
        ListIterator<String> l = enumConstraint.getLiterals().listIterator();
        while (l.hasNext()) {
            String enumVal = (String)l.next();
            if (this.type == DataType.SHORT) {
                if (!Constraints.SHORT.isValidValue(this, enumVal, this.typedValue)) throw new IllegalArgumentException("Short parameter " + this.tagName + "cannot be constrained by an enumerations containing non-short value '" + enumVal + "'.");
                l.set(enumVal.trim());
            } else if (this.type == DataType.INT) {
                if (!Constraints.INT.isValidValue(this, enumVal, this.typedValue)) throw new IllegalArgumentException("Integer parameter " + this.tagName + "cannot be constrained by an enumerations containing non-integer value '" + enumVal + "'.");
                l.set(enumVal.trim());
            } else if (this.type == DataType.LONG) {
                if (!Constraints.LONG.isValidValue(this, enumVal, this.typedValue)) throw new IllegalArgumentException("Long parameter " + this.tagName + "cannot be constrained by an enumerations containing non-long value '" + enumVal + "'.");
                l.set(enumVal.trim());
            }
            if (this.type == DataType.FLOAT) {
                if (!Constraints.FLOAT.isValidValue(this, enumVal, this.typedValue)) throw new IllegalArgumentException("Integer parameter " + this.tagName + "cannot be constrained by an enumerations containing non-float value '" + enumVal + "'.");
                l.set(enumVal.trim());
                continue;
            }
            if (this.type != DataType.DOUBLE) continue;
            if (!Constraints.DOUBLE.isValidValue(this, enumVal, this.typedValue)) throw new IllegalArgumentException("Long parameter " + this.tagName + "cannot be constrained by an enumerations containing non-double value '" + enumVal + "'.");
            l.set(enumVal.trim());
        }
    }

    private void checkConstant() {
        if (this.constant) {
            throw new IllegalStateException("Parameter properties cannot be altered once values are added.");
        }
    }

    public void add(Constraint someConstraint) {
        this.checkConstant();
        if (someConstraint == null || this.isUntyped() && someConstraint.isTyped()) {
            return;
        }
        this.checkConstraint(someConstraint);
        if (someConstraint.isRequired()) {
            this.setRequired();
        }
        someConstraint.setConstant();
        if (this.constraints.isEmpty()) {
            this.constraints = new LinkedList();
        }
        if (this.constraintSet.isEmpty()) {
            this.constraintSet = new HashSet();
        }
        someConstraint.register(this);
        this.constraints.add(someConstraint);
        this.constraintSet.add(someConstraint);
    }

    private void setRequired() {
        this.required = true;
    }

    private void setDefault(Parameter someParameter) {
        if (someParameter != null) {
            if (someParameter.isStructured()) {
                throw new IllegalArgumentException("Default parameters cannot be structured.");
            }
            this.checkForDefaultCycle(someParameter);
            this.deflt = someParameter;
        }
    }

    private void checkForDefaultCycle(Parameter param) {
        if (param != null) {
            if (this == param) {
                throw new IllegalArgumentException("A parameter cannot be a default value of itself.  Default parameter " + param.getParamInfo() + " is equivalent to contains parameter " + this.getParamInfo() + " as a default.");
            }
            this.checkForDefaultCycle(param.getDefault());
        }
    }

    Parameter getDefault() {
        return this.deflt;
    }

    private void setValuesTo(Object someValue) {
        if (this.values.isEmpty()) {
            this.values = new LinkedList();
        } else {
            this.values.clear();
        }
        this.values.add(someValue);
        this.applyTypeConstraint();
    }

    private void setDefault(String someValue) {
        if (someValue != null) {
            if (this.isStructured()) {
                throw new IllegalStateException("Structured parameters cannot default to a scalar value.");
            }
            this.defltValue = someValue;
            this.setValuesTo(someValue);
        }
    }

    void setType(DataType someType) {
        if (this.isStructured() && !Java.isJRE(1, 4)) {
            throw new RuntimeException("Strucutred parameters are only supported in a Java 1.4 Runtime Environemnt (JRE) or later.");
        }
        this.type = someType;
    }

    public ParamElement paramElement() {
        return (ParamElement)Java.getFirst(this.paramElements);
    }

    public List paramElements() {
        return this.paramElements;
    }

    DataType getDataType() {
        return this.type;
    }

    public String tagName() {
        return this.tagName;
    }

    public String qualifiedTagName() {
        StringBuffer buffer = this._buffer;
        Java.clear(buffer);
        if (this.parent != null) {
            buffer.append(this.parent.qualifiedTagName());
            buffer.append(".");
            buffer.append(this.tagName);
        } else {
            buffer.append(this.tagName);
        }
        return buffer.toString();
    }

    void setDisplayName(String display) {
        if (display != null) {
            this.displayName = display;
        }
    }

    String getDisplayName() {
        return this.displayName;
    }

    String getParamInfo() {
        String qualifiedTagName = this.qualifiedTagName();
        StringBuffer buffer = this._buffer;
        Java.clear(buffer);
        buffer.append("tagName='");
        buffer.append(qualifiedTagName);
        buffer.append("'");
        if (this.displayName != null) {
            buffer.append(", displayName='");
            buffer.append(this.displayName);
            buffer.append("'");
        }
        if (this.instanceID > -1) {
            buffer.append(", instanceID=");
            buffer.append(this.instanceID);
        }
        return buffer.toString();
    }

    void setParamElement(ParamElement someElement) {
        if (this.paramElements == Collections.EMPTY_LIST) {
            this.paramElements = new LinkedList();
        } else {
            this.paramElements.clear();
        }
        this.addParamElementImpl(someElement);
    }

    void addParamElement(ParamElement someElement) {
        if (this.paramElements == Collections.EMPTY_LIST) {
            this.paramElements = new ArrayList();
        }
        this.addParamElementImpl(someElement);
    }

    void addParamElementImpl(ParamElement paramElement) {
        if (this.isScalar() && (paramElement.isContentSensitive() || paramElement.isPasswordRef())) {
            this.runtimeSensitive = true;
        }
        this.paramElements.add(paramElement);
    }

    public void overrideValue(String someValue) {
        this.overrideValue((Object)someValue);
    }

    public void overrideValue(Object someValue) {
        if (someValue == null) {
            this.set = false;
            this.values.clear();
        } else if (!this.isStructured()) {
            this.setValuesTo(someValue);
        }
    }

    void overrideTagName(String tagName) {
        if (XDSUtil.isValue(tagName)) {
            this.tagName = tagName;
        }
    }

    public void overrideDefault(Parameter override, boolean inheritConstraints) {
        if (this.deflt == null) {
            throw new IllegalStateException("Parameters without a parameter default cannot be overridden using this method.");
        }
        if (override != null) {
            if (!Lib.AreEquivalent(this, override, inheritConstraints)) {
                throw new IllegalArgumentException("Overriding default parameters must have the same data type and constraints as the default they're overriding.  Default parameter " + this.deflt.getParamInfo() + " of parameter " + this.getParamInfo() + " cannot be overridden by parameter '" + override.getParamInfo() + " for this reason.");
            }
            this.setDefault(override);
        }
    }

    void setValue(String someValue) {
        this.constant = true;
        if (Lib.IsParamValue(someValue)) {
            if (this.values == Collections.EMPTY_LIST) {
                this.values = new LinkedList();
            }
            if (!this.set) {
                this.set = true;
            }
            this.values.clear();
            this.values.add(someValue);
        }
    }

    void setNext(Parameter p) {
        if (!this.isStructured()) {
            throw new IllegalStateException("Only structured parameters can be chained.");
        }
        if (p == null) {
            return;
        }
        this.next = p;
    }

    void addValue(String someValue) {
        this.constant = true;
        if (Lib.IsParamValue(someValue)) {
            if (this.values == Collections.EMPTY_LIST) {
                this.values = new LinkedList();
            }
            if (!this.set) {
                this.values.clear();
                this.set = true;
            }
            this.values.add(someValue);
        }
    }

    private void applyTypeConstraint() {
        if (this.values.isEmpty()) {
            return;
        }
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext()) {
            Constraint constraint = (Constraint)c.next();
            if (!constraint.isType()) continue;
            boolean success = false;
            for (int i = 0; i < this.values.size(); ++i) {
                this.typedValue[0] = null;
                Object value = this.values.get(i);
                success = constraint.isValidValue(this, value, this.typedValue);
                if (!success) {
                    throw new IllegalArgumentException("Type mismatch.  Value '" + value + "' of parameter " + this.getParamInfo() + " is not " + this.type.toClause());
                }
                if (this.typedValue[0] == null) continue;
                this.values.set(i, this.typedValue[0]);
            }
        }
    }

    XDSException applyConstraints(XDSException currentException) {
        XDSParameterException nextException;
        Constraint constraint;
        if (this.constraints.isEmpty()) {
            return currentException;
        }
        boolean applyOnlyRequiredConstraints = false;
        if (this.isStructured() && !this.isSet()) {
            applyOnlyRequiredConstraints = true;
        }
        boolean noValues = this.values.isEmpty();
        LinkedList illegalValues = new LinkedList();
        if (noValues) {
            if (this.values == Collections.EMPTY_LIST) {
                this.values = new LinkedList();
            }
            this.values.add(null);
        }
        XDSException firstException = currentException;
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext() && currentException == firstException) {
            Object value;
            int i;
            boolean success;
            constraint = (Constraint)c.next();
            if (constraint.isDependent() || applyOnlyRequiredConstraints && !constraint.isRequired()) continue;
            illegalValues.clear();
            if (constraint.getOperator() == LogicalOp.OR) {
                success = false;
                for (i = 0; i < this.values.size(); ++i) {
                    this.typedValue[0] = null;
                    value = this.values.get(i);
                    if (!(success |= constraint.isValidValue(this, value, this.typedValue))) {
                        illegalValues.add(value);
                        continue;
                    }
                    if (!constraint.isType() || this.typedValue[0] == null) continue;
                    this.values.set(i, this.typedValue[0]);
                }
                if (success) continue;
                nextException = this.newIndependentParamException(constraint, illegalValues);
                currentException.setNextException(nextException);
                currentException = nextException;
                continue;
            }
            if (constraint.getOperator() == LogicalOp.AND) {
                for (i = 0; i < this.values.size(); ++i) {
                    this.typedValue[0] = null;
                    illegalValues.clear();
                    value = this.values.get(i);
                    success = constraint.isValidValue(this, value, this.typedValue);
                    if (!success) {
                        illegalValues.add(value);
                        continue;
                    }
                    if (!constraint.isType() || this.typedValue[0] == null) continue;
                    this.values.set(i, this.typedValue[0]);
                }
                if (illegalValues.isEmpty()) continue;
                nextException = this.newIndependentParamException(constraint, illegalValues);
                currentException.setNextException(nextException);
                currentException = nextException;
                continue;
            }
            throw new RuntimeException("Broken IF-ELSE statement.");
        }
        if (noValues) {
            this.values.clear();
        }
        if (this.isStructured() && this.isSet()) {
            Iterator p = this.getParameters().iterator();
            while (p.hasNext()) {
                Parameter param = (Parameter)p.next();
                currentException = param.applyConstraints(currentException);
            }
        }
        c = this.constraints.listIterator();
        while (c.hasNext()) {
            constraint = (Constraint)c.next();
            if (constraint.isIndependent() || constraint.isSatisfied()) continue;
            nextException = this.newDependentException(constraint);
            currentException.setNextException(nextException);
            currentException = nextException;
        }
        return currentException;
    }

    private XDSParameterException newDependentException(Constraint someConstraint) {
        StringBuffer buffer = new StringBuffer();
        if (someConstraint instanceof MultiRequiredConstraint) {
            MultiRequiredConstraint grc = (MultiRequiredConstraint)someConstraint;
            Collection params = grc.getRegisteredParams();
            if (params.size() == 1) {
                buffer.append("Parameter ");
            } else {
                buffer.append("Either parameter ");
            }
            boolean first = true;
            Iterator i = params.iterator();
            while (i.hasNext()) {
                Parameter p = (Parameter)i.next();
                if (first) {
                    first = false;
                } else {
                    buffer.append(" or ");
                }
                buffer.append(p.getParamInfo());
            }
            buffer.append(" must have a value.");
        } else if (someConstraint instanceof MultiUniqueConstraint) {
            String paramInfo = this.getParamInfo();
            buffer.append("Parameter ");
            buffer.append(paramInfo);
            buffer.append(" is not unique.");
        }
        buffer.append("  Legal values are ");
        int current = 1;
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext()) {
            someConstraint = (Constraint)c.next();
            buffer.append(someConstraint.toString());
            if (current < this.constraints.size()) {
                buffer.append(" " + OP.toString() + " ");
            }
            ++current;
        }
        buffer.append(".");
        return new XDSParameterException(buffer.toString(), this);
    }

    private XDSParameterException newIndependentParamException(Constraint someConstraint, List someValues) {
        boolean enclose;
        String paramInfo = this.getParamInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Parameter ");
        buffer.append(paramInfo);
        if (someConstraint.isRequired()) {
            buffer.append(" is missing a required value");
        } else if (someConstraint.isCardinality()) {
            buffer.append(" has too many values.  It should have at most one value");
        } else if (someConstraint.isType()) {
            buffer.append(" is not ");
            buffer.append(this.type.toClause());
            buffer.append("");
        } else if (someConstraint.isUnique()) {
            buffer.append(" is not unique");
        } else {
            boolean first = true;
            buffer.append(" has illegal value");
            if (someValues.size() > 1) {
                buffer.append("s");
            }
            ListIterator i = someValues.listIterator();
            while (i.hasNext()) {
                Object value = i.next();
                if (first) {
                    first = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(" ");
                if (value == null) {
                    buffer.append(value);
                    continue;
                }
                buffer.append("'");
                buffer.append(value);
                buffer.append("'");
            }
        }
        buffer.append(".  Legal values are ");
        boolean bl = enclose = this.constraints.size() > 1 || this.constraints.size() == 1 && ((Constraint)this.constraints.get(0)).isGroup();
        if (enclose) {
            buffer.append("[");
        }
        int current = 1;
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext()) {
            someConstraint = (Constraint)c.next();
            String string = someConstraint.toString();
            if (Lib.IsValue(string)) {
                buffer.append(string);
                if (current < this.constraints.size()) {
                    buffer.append(" " + OP.toString() + " ");
                }
            }
            ++current;
        }
        if (enclose) {
            buffer.append("]");
        }
        buffer.append(".");
        return new XDSParameterException(buffer.toString(), this);
    }

    public Character toCharacter() {
        Object o = null;
        try {
            o = this.getValue();
            Character ch = (Character)o;
            if (ch == null && this.deflt != null) {
                ch = this.deflt.toCharacter();
            }
            return ch;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + o + "' to type '" + DataType.CHAR.toString() + "'.");
        }
    }

    public Short toShort() {
        Object o = null;
        try {
            o = this.getValue();
            Short s = (Short)o;
            if (s == null && this.deflt != null) {
                s = this.deflt.toShort();
            }
            return s;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + o + "' to type '" + DataType.SHORT.toString() + "'.");
        }
    }

    public Integer toInteger() {
        Object o = null;
        try {
            o = this.getValue();
            Integer i = (Integer)o;
            if (i == null && this.deflt != null) {
                i = this.deflt.toInteger();
            }
            return i;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + o + "' to type '" + DataType.INT.toString() + "'.");
        }
    }

    public Long toLong() {
        Object o = null;
        try {
            o = this.getValue();
            Long l = (Long)o;
            if (l == null && this.deflt != null) {
                l = this.deflt.toLong();
            }
            return l;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + o + "' to type '" + DataType.LONG.toString() + "'.");
        }
    }

    public Float toFloat() {
        Object o = null;
        try {
            o = this.getValue();
            Float f = (Float)o;
            if (f == null && this.deflt != null) {
                f = this.deflt.toFloat();
            }
            return f;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + o + "' to type '" + DataType.FLOAT.toString() + "'.");
        }
    }

    public Double toDouble() {
        Object o = null;
        try {
            o = this.getValue();
            Double d = (Double)o;
            if (d == null && this.deflt != null) {
                d = this.deflt.toDouble();
            }
            return d;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + o + "' to type '" + DataType.DOUBLE.toString() + "'.");
        }
    }

    public Number toNumber() {
        Object o = null;
        try {
            o = this.getValue();
            Number n = (Number)o;
            if (n == null && this.deflt != null) {
                n = this.deflt.toNumber();
            }
            return n;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + o + "' to Java type '" + Number.class.getName() + "'.");
        }
    }

    public Boolean toBoolean() {
        Object o = null;
        try {
            o = this.getValue();
            Boolean bool = (Boolean)o;
            if (bool == null && this.deflt != null) {
                bool = this.deflt.toBoolean();
            }
            return bool;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + o + "' to type '" + DataType.BOOLEAN.toString() + "'.");
        }
    }

    Object getValue() {
        return Java.getFirst(this.values);
    }

    public String toString() {
        Object o = this.getValue();
        if (o == null && this.deflt != null) {
            o = this.deflt.toString();
        }
        return o == null ? null : o.toString();
    }

    public List toList() {
        if (this.values.isEmpty() && this.deflt != null) {
            return this.deflt.toList();
        }
        return this.values;
    }

    public Parameter getNext() {
        return this.next;
    }

    boolean isRequired() {
        return this.required;
    }

    public int compareTo(Object o) {
        Parameter p = (Parameter)o;
        int result = this.qualifiedTagName().compareTo(p.qualifiedTagName());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    String matchRegEx() {
        StringBuffer buffer = this._buffer;
        Java.clear(buffer);
        if (this.parent != null) {
            buffer.append(this.parent.matchRegEx());
        }
        buffer.append(this.tagName);
        buffer.append("(_\\d*)?");
        if (this.isStructured()) {
            buffer.append("\\.");
        }
        return buffer.toString();
    }

    String instanceRegEx() {
        StringBuffer buffer = this._buffer;
        Java.clear(buffer);
        if (this.parent != null) {
            buffer.append(this.parent.instanceRegEx());
            if (this.parent.instanceID > -1) {
                buffer.append("_");
                buffer.append(this.parent.instanceID);
                buffer.append("\\.");
            }
        }
        buffer.append(this.tagName);
        return buffer.toString();
    }

    public int hashCode() {
        return this.qualifiedTagName().hashCode();
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof Parameter) {
            equal = this.compareTo(o) == 0;
        }
        return equal;
    }

    public Object clone(String tagName) {
        Parameter clone = (Parameter)this.cloneInstance(false);
        clone.overrideTagName(tagName);
        return clone;
    }

    public Object clone() {
        return this.cloneInstance(false);
    }

    Object cloneInstance(boolean sameParameter) {
        Iterator i;
        Parameter clone = new Parameter();
        clone.tagName = this.tagName;
        clone.displayName = this.displayName;
        clone.type = this.type;
        clone.typedValue = new Object[1];
        clone.parent = this.parent;
        clone._buffer = new StringBuffer();
        clone.declaredSensitive = this.declaredSensitive;
        clone.runtimeSensitive = false;
        clone.set = false;
        clone.required = this.required;
        clone.constant = this.constant;
        clone.instanceID = -1;
        clone.paramElements = Collections.EMPTY_LIST;
        clone.next = null;
        clone.deflt = this.deflt;
        if (this.constraints.isEmpty()) {
            clone.constraints = Collections.EMPTY_LIST;
            clone.constraintSet = Collections.EMPTY_SET;
        } else {
            clone.constraints = new ArrayList(this.constraints.size());
            clone.constraintSet = new HashSet();
            ListIterator l = this.constraints.listIterator();
            while (l.hasNext()) {
                Constraint c = (Constraint)l.next();
                c = (Constraint)c.cloneAsNeeded(sameParameter);
                clone.constraints.add(c);
                clone.constraintSet.add(c);
            }
        }
        if (this.parameters.isEmpty()) {
            clone.parameters = XDS.EMPTY_MAP;
        } else {
            clone.parameters = new HashMap(this.parameters.size());
            i = this.parameters.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Parameter param = (Parameter)entry.getValue();
                if (param == null) continue;
                Parameter paramClone = (Parameter)param.cloneInstance(sameParameter);
                clone.add(paramClone);
            }
        }
        if (this.isSetWhen.isEmpty()) {
            clone.isSetWhen = XDS.EMPTY_MAP;
        } else {
            clone.isSetWhen = new HashMap(this.isSetWhen.size());
            i = this.isSetWhen.values().iterator();
            while (i.hasNext()) {
                Parameter param = (Parameter)((Object)i.next());
                clone.isSetWhen.put(param.tagName(), clone.parameters.get(param.tagName()));
            }
        }
        if (this.values.isEmpty()) {
            clone.values = Collections.EMPTY_LIST;
        } else {
            clone.values = new LinkedList();
            if (this.defltValue != null) {
                clone.setDefault(this.defltValue);
            }
        }
        return clone;
    }
}

