/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Comparators;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.EqualityOp;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Comparator;

public final class RangeConstraint
extends Constraint {
    public static final RangeConstraint POSITIVE;
    public static final RangeConstraint NON_NEGATIVE;
    public static final RangeConstraint NEGATIVE;
    private static final String RANGE_SYMBOL;
    private static final boolean DEFAULT_EMPTY;
    private Comparator comparator;
    private boolean same;
    private Object first;
    private Object last;
    private boolean empty;
    private EqualityOp equalityOp;
    private int hashCode;
    private boolean hashCodeSet;
    private boolean isStringComparator;

    public RangeConstraint(char first, char last) {
        this.init();
        this.same = first == last;
        this.equalityOp = EqualityOp.NONE;
        this.setType(DataType.CHAR);
        this.comparator = Comparators.CHAR_SENSITIVE;
        this.isStringComparator = true;
        this.first = new Character(first);
        this.last = new Character(last);
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    public RangeConstraint(char firstAndLast) {
        this(firstAndLast, firstAndLast);
    }

    public RangeConstraint(long first, long last) {
        this.init();
        this.same = first == last;
        this.equalityOp = EqualityOp.NONE;
        this.setType(DataType.LONG);
        this.comparator = Comparators.LONG;
        this.isStringComparator = false;
        this.first = new Long(first);
        this.last = new Long(last);
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    public RangeConstraint(long firstAndLast) {
        this(firstAndLast, firstAndLast);
    }

    public RangeConstraint(double first, double last) {
        this.init();
        this.same = first == last;
        this.equalityOp = EqualityOp.NONE;
        this.setType(DataType.DOUBLE);
        this.comparator = Comparators.DOUBLE;
        this.isStringComparator = false;
        this.first = new Double(first);
        this.last = new Double(last);
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    public RangeConstraint(double firstAndLast) {
        this(firstAndLast, firstAndLast);
    }

    public RangeConstraint(long someNumber, EqualityOp someOp) {
        Lib.CheckParam(someOp, "someOp");
        this.init();
        if (someNumber == Long.MIN_VALUE && someOp == EqualityOp.LT || someNumber == Long.MAX_VALUE && someOp == EqualityOp.GT) {
            this.setEmpty();
        }
        this.same = false;
        this.equalityOp = someOp;
        this.first = new Long(someNumber);
        this.setType(DataType.LONG);
        this.comparator = Comparators.LONG;
        this.isStringComparator = false;
        this.last = null;
        this.setOperator(LogicalOp.AND);
    }

    public RangeConstraint(double someNumber, EqualityOp someOp) {
        Lib.CheckParam(someOp, "someOp");
        this.init();
        if (someNumber == Double.MIN_VALUE && someOp == EqualityOp.LT || someNumber == Double.MAX_VALUE && someOp == EqualityOp.GT) {
            this.setEmpty();
        }
        this.same = false;
        this.equalityOp = someOp;
        this.first = new Double(someNumber);
        this.setType(DataType.DOUBLE);
        this.comparator = Comparators.DOUBLE;
        this.isStringComparator = false;
        this.last = null;
        this.setOperator(LogicalOp.AND);
    }

    private void init() {
        this.empty = DEFAULT_EMPTY;
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private void setEmpty() {
        this.checkConstant();
        this.empty = true;
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        boolean valid = true;
        if (someValue != null) {
            valid = this.empty ? false : this.compare(someValue);
        }
        return valid;
    }

    private boolean compare(Object someValue) {
        boolean returnVal;
        int result = this.comparator.compare(someValue, this.first);
        if (this.equalityOp == EqualityOp.NONE) {
            returnVal = result != -1 && this.comparator.compare(someValue, this.last) != 1;
        } else {
            switch (result) {
                case -1: {
                    returnVal = EqualityOp.IsLessThan(this.equalityOp);
                    break;
                }
                case 1: {
                    returnVal = EqualityOp.IsGreaterThan(this.equalityOp);
                    break;
                }
                case 0: {
                    returnVal = EqualityOp.MayBeEqual(this.equalityOp);
                    break;
                }
                default: {
                    throw new RuntimeException("Broken SWITCH statement.");
                }
            }
        }
        return this.not ? !returnVal : returnVal;
    }

    String getLegalValues() {
        StringBuffer buffer = new StringBuffer(32);
        if (this.empty) {
            return "";
        }
        if (this.equalityOp == EqualityOp.NONE) {
            if (this.same) {
                if (this.isStringComparator) {
                    buffer.append("'");
                }
                buffer.append(this.first);
                if (this.isStringComparator) {
                    buffer.append("'");
                }
            } else {
                if (this.isStringComparator) {
                    buffer.append("'");
                }
                buffer.append(this.first);
                if (this.isStringComparator) {
                    buffer.append("'");
                }
                buffer.append(RANGE_SYMBOL);
                if (this.isStringComparator) {
                    buffer.append("'");
                }
                buffer.append(this.last);
                if (this.isStringComparator) {
                    buffer.append("'");
                }
            }
        } else {
            buffer.append("n ");
            buffer.append(this.equalityOp);
            buffer.append(" ");
            buffer.append(this.first);
        }
        return buffer.toString();
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        this.hashCode = this.getLegalValues().hashCode();
        this.hashCodeSet = true;
        this.setConstant();
        return this.hashCode;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof RangeConstraint) {
            RangeConstraint other = (RangeConstraint)o;
            if (this.getLegalValues().compareTo(other.getLegalValues()) == 0) {
                equal = true;
            }
        } else if (o instanceof ConstraintGroup) {
            ConstraintGroup og = (ConstraintGroup)o;
            boolean bl = equal = og.constraints.size() == 1;
            if (equal) {
                equal = this.equals(og.constraints.get(0));
            }
        }
        return equal;
    }

    Object cloneAsNeeded(boolean sameParameter) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }

    static {
        DEFAULT_EMPTY = false;
        RANGE_SYMBOL = "...";
        RangeConstraint temp = new RangeConstraint(0L, EqualityOp.GT);
        temp.setConstant();
        POSITIVE = temp;
        POSITIVE.setConstant();
        temp = new RangeConstraint(0L, EqualityOp.LT);
        temp.setConstant();
        NEGATIVE = temp;
        NEGATIVE.setConstant();
        temp = new RangeConstraint(0L, EqualityOp.GTE);
        temp.setConstant();
        NON_NEGATIVE = temp;
        NON_NEGATIVE.setConstant();
    }
}

