/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.regex.Pattern;

public class RegExConstraint
extends Constraint {
    private Pattern pattern;

    public RegExConstraint(String somePattern, int flags) {
        if (somePattern == null) {
            throw new IllegalArgumentException("Null is not a valid regular expression pattern.");
        }
        this.pattern = Pattern.compile(somePattern, flags);
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    public RegExConstraint(String somePattern) {
        if (somePattern == null) {
            throw new IllegalArgumentException("Null is not a valid regular expression pattern.");
        }
        this.pattern = Pattern.compile(somePattern);
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        return someValue == null ? true : this.pattern.matcher(someValue.toString()).matches();
    }

    String getLegalValues() {
        return this.pattern.pattern() + " (regular expression)";
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof RegExConstraint) {
            RegExConstraint oc = (RegExConstraint)o;
            equal = this.pattern == oc.pattern;
        } else if (o instanceof ConstraintGroup) {
            ConstraintGroup og = (ConstraintGroup)o;
            boolean bl = equal = og.constraints.size() == 1;
            if (equal) {
                equal = this.equals(og.constraints.get(0));
            }
        }
        return equal;
    }

    public Object cloneAsNeeded(boolean sameParameter) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

