/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;

public final class SingleValueConstraint
extends Constraint {
    static final SingleValueConstraint SINGLE_VALUE = new SingleValueConstraint();
    private int count = 0;

    public SingleValueConstraint() {
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        if (param.isScalar()) {
            boolean valid = true;
            if (someValue != null && ++this.count > 1) {
                return false;
            }
            return valid;
        }
        if (param.isStructured()) {
            return param.getNext() == null;
        }
        throw new RuntimeException("Broken IF-ELSE statement.");
    }

    String getLegalValues() {
        return "value? (once or not at all)";
    }

    public int hashCode() {
        return HASH_SINGLE_VALUE;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof SingleValueConstraint) {
            equal = true;
        } else if (o instanceof ConstraintGroup) {
            ConstraintGroup og = (ConstraintGroup)o;
            boolean bl = equal = og.constraints.size() == 1;
            if (equal) {
                equal = this.equals(og.constraints.get(0));
            }
        }
        return equal;
    }

    Object cloneAsNeeded(boolean sameParameter) {
        return new SingleValueConstraint();
    }

    public boolean forStructured() {
        return true;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    boolean isSatisfied() {
        return true;
    }

    boolean isCardinality() {
        return true;
    }

    public boolean canBeAppliedToMultipleParams() {
        return false;
    }

    boolean isStateful() {
        return true;
    }

    boolean isIndependent() {
        return true;
    }
}

