/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

public class StatusLevel
implements Comparable {
    public static final StatusLevel FATAL = new StatusLevel("fatal", 1);
    public static final StatusLevel ERROR = new StatusLevel("error", 2);
    public static final StatusLevel RETRY = new StatusLevel("retry", 3);
    public static final StatusLevel WARNING = new StatusLevel("warning", 4);
    public static final StatusLevel SUCCESS = new StatusLevel("success", 5);
    private String level;
    private int weight;

    private StatusLevel(String someLevel, int someWeight) {
        this.level = someLevel;
        this.weight = someWeight;
    }

    public static final StatusLevel getLevel(String level) {
        if (FATAL.equals(level)) {
            return FATAL;
        }
        if (ERROR.equals(level)) {
            return ERROR;
        }
        if (WARNING.equals(level)) {
            return WARNING;
        }
        if (SUCCESS.equals(level)) {
            return SUCCESS;
        }
        if (RETRY.equals(level)) {
            return RETRY;
        }
        return null;
    }

    public boolean equals(Object someLevel) {
        if (someLevel == null) {
            return false;
        }
        if (someLevel == this) {
            return true;
        }
        if (someLevel.getClass() == String.class) {
            return this.equals((String)someLevel);
        }
        return false;
    }

    public boolean equals(String someLevel) {
        if (someLevel == null) {
            return false;
        }
        return this.level.compareTo(someLevel) == 0;
    }

    public int compareTo(Object someLevel) {
        if (someLevel == null) {
            return -1;
        }
        StatusLevel otherLevel = (StatusLevel)someLevel;
        int otherWeight = otherLevel.getWeight();
        if (this.weight < otherWeight) {
            return -1;
        }
        if (this.weight > otherWeight) {
            return 1;
        }
        return 0;
    }

    int getWeight() {
        return this.weight;
    }

    public String toString() {
        return this.level;
    }
}

