/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Comparators;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Maps;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public final class TypedEnumConstraint
extends Constraint {
    private Set values;
    private Comparator comparator;
    private int hashCode;
    private boolean hashCodeSet;
    private boolean caseInsensitive;

    public TypedEnumConstraint(DataType someType, Comparator someComparator) {
        Lib.CheckParam(someType, "someType");
        this.setType(someType);
        this.setComparator(someComparator);
        this.setCaseInsensitive();
        this.setValues();
        this.addConstraint(this);
    }

    protected void setType(DataType someType) {
        if (someType == DataType.STRUCT) {
            throw new IllegalArgumentException("Type struct is not supported.");
        }
        if (someType == DataType.ANY) {
            throw new IllegalArgumentException("Type any is not supported.");
        }
        super.setType(someType);
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private void setValues() {
        this.values = new TreeSet(this.comparator);
    }

    void setComparator(Comparator someComparator) {
        if (someComparator == null) {
            someComparator = Maps.GetComparator(this.getType());
        }
        if (!Comparators.TestArgs(someComparator, this.getType())) {
            throw new IllegalArgumentException("Passed comparator does not accept arguments of type '" + this.getType().getJavaClass().getName() + "'.");
        }
        this.comparator = someComparator;
    }

    private void setCaseInsensitive() {
        this.caseInsensitive = DataType.IsStringType(this.getType()) ? this.comparator.compare("c", "C") == 0 : true;
    }

    public void add(Object value) {
        this.checkConstant();
        if (value == null) {
            return;
        }
        DataType t = Maps.GetType(value.getClass());
        if (t == null) {
            throw new IllegalArgumentException("Values of type '" + value.getClass().getName() + "' are not supported.");
        }
        if (!this.getType().isCompatibleImpl(t)) {
            throw new IllegalArgumentException("Value type mismatch.  Values of type '" + t + "' cannot be added to constraints of type " + this.getType() + "'.");
        }
        this.values.add(value);
    }

    public void add(Collection values) {
        this.checkConstant();
        if (values == null || values.isEmpty()) {
            return;
        }
        Iterator i = values.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    boolean isValidValue(Parameter param, Object someValue, Object[] typedValue) {
        return someValue == null ? true : this.isValid(someValue, this.not);
    }

    private boolean isValid(Object someValue, boolean returnVal) {
        return this.values.contains(someValue) ? !returnVal : returnVal;
    }

    String getLegalValues() {
        StringBuffer buffer = new StringBuffer(this.values.size() * 16);
        boolean first = true;
        Iterator i = this.values.iterator();
        while (i.hasNext()) {
            String value = (String)i.next();
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            if (DataType.IsStringType(this.getType())) {
                buffer.append("'");
            }
            buffer.append(value);
            if (!DataType.IsStringType(this.getType())) continue;
            buffer.append("'");
        }
        return buffer.toString();
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        String hashString = this.getLegalValues();
        if (this.caseInsensitive) {
            hashString = hashString.toUpperCase();
        }
        this.setConstant();
        this.hashCodeSet = true;
        this.hashCode = hashString.hashCode();
        return this.hashCode;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof TypedEnumConstraint) {
            TypedEnumConstraint oc = (TypedEnumConstraint)o;
            if (((Object)this.comparator).equals(oc.comparator) && this.comparator.compare(this.getLegalValues(), oc.getLegalValues()) == 0) {
                equal = true;
            }
        } else if (o instanceof ConstraintGroup) {
            ConstraintGroup og = (ConstraintGroup)o;
            boolean bl = equal = og.constraints.size() == 1;
            if (equal) {
                equal = this.equals(og.constraints.get(0));
            }
        }
        return equal;
    }

    Object cloneAsNeeded(boolean sameParameter) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

