/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import org.w3c.dom.Element;

public class XDSAssociationElement
extends ElementImpl
implements TextParent {
    private String text;

    XDSAssociationElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    XDSAssociationElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "association");
    }

    private void init() {
        this.text = "";
    }

    protected void passText(String someText) throws XDSParseException {
        this.text = this.text + someText;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.text == "") {
            throw new XDSParseException(Errors.NoText("association"));
        }
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public void appendText(String someText) {
        Lib.TextParent_appendText(this, someText);
    }
}

