/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DTD;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds._Boolean;
import org.w3c.dom.Element;

public class XDSAttrDefElement
extends ElementImpl {
    private static final int INDEX_CASE_SENSITIVE = 0;
    private static final int INDEX_MULTI_VALUED = 1;
    private static final int INDEX_NAMING = 2;
    private static final int INDEX_READ_ONLY = 3;
    private static final int INDEX_REQUIRED = 4;
    private static final String[] BOOL_ATTR_NAMES = new String[]{"case-sensitive", "multi-valued", "naming", "read-only", "required"};
    private static final _Boolean[] BOOL_ATTR_DEFAULTS = new _Boolean[]{_Boolean.FALSE, _Boolean.TRUE, _Boolean.FALSE, _Boolean.FALSE, _Boolean.FALSE};
    private String attrName;
    private _Boolean[] booleans;
    private ValueType type;
    private String typeStr;

    XDSAttrDefElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.readInit();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSAttrDefElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "attr-def");
        this.writeInit();
    }

    private void readInit() {
        this.booleans = new _Boolean[BOOL_ATTR_NAMES.length];
    }

    private void writeInit() {
        this.booleans = BOOL_ATTR_DEFAULTS;
    }

    private void parseAttributes() {
        this.attrName = this.attributeValueGet("attr-name");
        this.typeStr = this.attributeValueGet("type");
        this.type = ValueType.Lookup(this.typeStr);
        for (int b = 0; b < BOOL_ATTR_NAMES.length; ++b) {
            this.booleans[b] = _Boolean.getBoolean(this.attributeValueGet(BOOL_ATTR_NAMES[b]), BOOL_ATTR_DEFAULTS[b]);
        }
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.attrName == null) {
                throw new XDSParseException(Errors.NoAttributeValue("attr-name"));
            }
            if (this.type == null) {
                throw new XDSParseException(Errors.BadValueType(this.typeStr));
            }
            for (int b = 0; b < BOOL_ATTR_NAMES.length; ++b) {
                if (!this.booleans[b].equals(_Boolean.ILLEGAL)) continue;
                throw new XDSParseException(Errors.BadBooleanType(this.booleans[b].toString()));
            }
        }
    }

    String getAttrName() {
        Lib.CheckContext(this.document.context, 0);
        return this.attrName;
    }

    String getASN1ID() {
        return Lib.GetAttributeValue(this, "asn1id");
    }

    boolean getCaseSensitive() {
        Lib.CheckContext(this.document.context, 0);
        return this.booleans[0].toPrimitive();
    }

    boolean getMultiValued() {
        Lib.CheckContext(this.document.context, 0);
        return this.booleans[1].toPrimitive();
    }

    boolean getNaming() {
        Lib.CheckContext(this.document.context, 0);
        return this.booleans[2].toPrimitive();
    }

    boolean getReadOnly() {
        Lib.CheckContext(this.document.context, 0);
        return this.booleans[3].toPrimitive();
    }

    boolean getRequired() {
        Lib.CheckContext(this.document.context, 0);
        return this.booleans[4].toPrimitive();
    }

    ValueType getType() {
        Lib.CheckContext(this.document.context, 0);
        return this.type;
    }

    public void setAttrName(String someName) {
        this.attributeValueSet("attr-name", someName);
    }

    public void setASN1ID(String someID) {
        this.attributeValueSet("asn1id", someID);
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.attributeValueSet("case-sensitive", DTD.GetStringValue(isCaseSensitive));
    }

    public void setMultiValued(boolean isMultiValued) {
        this.attributeValueSet("multi-valued", DTD.GetStringValue(isMultiValued));
    }

    public void setNaming(boolean isNaming) {
        this.attributeValueSet("naming", DTD.GetStringValue(isNaming));
    }

    public void setReadOnly(boolean isReadOnly) {
        this.attributeValueSet("read-only", DTD.GetStringValue(isReadOnly));
    }

    public void setRequired(boolean isRequired) {
        this.attributeValueSet("required", DTD.GetStringValue(isRequired));
    }

    public void setType(ValueType someType) {
        this.setAttributeValue("type", someType);
    }
}

