/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.ParamParent;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSServerElement;
import com.novell.nds.dirxml.driver.xds.XDSUserElement;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class XDSAuthenticationInfoElement
extends ElementImpl
implements ParamParent {
    private XDSServerElement server;
    private XDSUserElement user;
    private XDSPasswordElement password;
    private int noOfServers;
    private int noOfUsers;
    private int noOfPasswords;
    private Map[] paramMap;

    XDSAuthenticationInfoElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.readInit();
        this.parseChildNodes();
        this.validate();
    }

    private void readInit() {
        this.server = null;
        this.user = null;
        this.password = null;
        this.noOfServers = 0;
        this.noOfUsers = 0;
        this.noOfPasswords = 0;
        this.paramMap = new Map[1];
        this.paramMap[0] = XDS.EMPTY_MAP;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.noOfServers > 1) {
                throw new XDSParseException(Errors.DuplicateElement("server"));
            }
            if (this.noOfUsers > 1) {
                throw new XDSParseException(Errors.DuplicateElement("user"));
            }
            if (this.noOfPasswords > 1) {
                throw new XDSParseException(Errors.DuplicateElement("password"));
            }
            if (this.document.isStrict()) {
                if (this.password != null && this.password.position() != this.children().size()) {
                    throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "password", this.children().size()));
                }
                if (this.server != null && this.server.position() != 1) {
                    throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "server", 1));
                }
            }
        }
    }

    private void setPassword(XDSPasswordElement somePassword) {
        if (this.password == null) {
            this.password = somePassword;
        }
        ++this.noOfPasswords;
    }

    private void setUser(XDSUserElement someUser) {
        if (this.user == null) {
            this.user = someUser;
        }
        ++this.noOfUsers;
    }

    private void setServer(XDSServerElement someServer) {
        if (this.server == null) {
            this.server = someServer;
        }
        ++this.noOfServers;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("password".compareTo(tagName) == 0) {
            child = new XDSPasswordElement(childElement, this.document);
            this.setPassword((XDSPasswordElement)child);
        } else if ("user".compareTo(tagName) == 0) {
            child = new XDSUserElement(childElement, this.document);
            this.setUser((XDSUserElement)child);
        } else if ("server".compareTo(tagName) == 0) {
            child = new XDSServerElement(childElement, this.document);
            this.setServer((XDSServerElement)child);
        }
        return child;
    }

    public XDSServerElement extractServerElement() {
        return this.server;
    }

    public String extractServerText() {
        return Lib.GetText(this, this.server);
    }

    public XDSUserElement extractUserElement() {
        return this.user;
    }

    public String extractUserText() {
        return Lib.GetText(this, this.user);
    }

    public XDSPasswordElement extractPasswordElement() {
        return this.password;
    }

    public String extractPasswordText() {
        return Lib.GetText(this, this.password);
    }

    public List childElements() {
        return super.childElements();
    }

    public ParamElement paramElement(String tagName) throws XDSParameterException {
        return Lib.ParamParent_paramElement((ElementImpl)this, this.paramMap, this.children(), tagName);
    }

    public String paramText(String tagName) throws XDSParameterException {
        return Lib.ParamParent_paramText((ElementImpl)this, this.paramMap, this.children(), tagName);
    }

    public void parameters(Map params) throws XDSParameterException {
        Lib.ExtractParams((ElementImpl)this, this.paramMap, this.children(), params);
    }
}

