/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DTD;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAttrDefElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds._Boolean;
import java.util.List;
import org.w3c.dom.Element;

public class XDSClassDefElement
extends ElementImpl {
    private static final _Boolean DEFAULT_CONTAINER = _Boolean.FALSE;
    private _Boolean container;
    private String className;

    XDSClassDefElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSClassDefElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "class-def");
    }

    private void init() {
        this.container = DEFAULT_CONTAINER;
        this.className = null;
    }

    private void parseAttributes() throws XDSParseException {
        this.className = this.attributeValueGet("class-name");
        this.container = _Boolean.getBoolean(this.attributeValueGet("container"), DEFAULT_CONTAINER);
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.className == null) {
                throw new XDSParseException(Errors.NoAttributeValue("class-name"));
            }
            if (this.container.equals(_Boolean.ILLEGAL)) {
                throw new XDSParseException(Errors.BadBooleanType(this.container.toString()));
            }
        }
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        XDSAttrDefElement child = null;
        if ("attr-def".compareTo(tagName) == 0) {
            child = new XDSAttrDefElement(childElement, this.document);
        }
        return child;
    }

    String getClassName() {
        return Lib.GetValue((ElementImpl)this, this.className);
    }

    boolean getContainer() {
        return Lib.GetValue((ElementImpl)this, this.container);
    }

    String getASN1ID() {
        return Lib.GetAttributeValue(this, "asn1id");
    }

    public List childElements() {
        return super.childElements();
    }

    public void setClassName(String someName) {
        this.attributeValueSet("class-name", someName);
    }

    public void setASN1ID(String someID) {
        this.attributeValueSet("asn1id", someID);
    }

    public void setContainer(boolean isContainer) {
        this.attributeValueSet("container", DTD.GetStringValue(isContainer));
    }

    public XDSAttrDefElement appendAttrDefElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSAttrDefElement(this.document, this.element);
    }
}

