/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import org.w3c.dom.Element;

public class XDSComponentElement
extends ElementImpl
implements TextParent {
    private String name;
    private String associationRef;
    private String text;

    XDSComponentElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSComponentElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "component");
    }

    private void init() {
        this.name = null;
        this.associationRef = null;
        this.text = "";
    }

    protected void passText(String someText) throws XDSParseException {
        this.text = this.text + someText;
    }

    private void parseAttributes() {
        this.name = this.attributeValueGet("name");
        this.associationRef = this.attributeValueGet("association-ref");
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.name == null) {
            this.throwMissingAttributeException("name");
        }
    }

    public String getName() {
        return Lib.GetValue((ElementImpl)this, this.name);
    }

    public String getAssociationRef() {
        return Lib.GetValue((ElementImpl)this, this.associationRef);
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public void setName(String someName) {
        this.attributeValueSet("name", someName);
    }

    public void setAssociationRef(String someRef) {
        this.attributeValueSet("association-ref", someRef);
    }

    public void appendText(String someText) {
        Lib.TextParent_appendText(this, someText);
    }
}

