/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.DriverFilter;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.ReadableDocument;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class XDSInitDocument
extends DocumentImpl
implements ReadableDocument {
    private XDSInitParamsElement initParams;

    public XDSInitDocument(XmlDocument xdsXML) throws XDSParseException {
        super(xdsXML, "input", 0, DEFAULT_READ_VALIDATION_LEVEL);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    private void init() {
        this.initParams = null;
    }

    private void validate() throws XDSParseException {
        if (this.validate && this.initParams == null) {
            throw new XDSParseException(Errors.NoElement("init-params"));
        }
    }

    protected ElementImpl parseChildElement(Element domElement, String tagName, int position, int noOfElements) throws XDSParseException {
        XDSInitParamsElement child = null;
        if ("init-params".compareTo(tagName) == 0) {
            child = new XDSInitParamsElement(domElement, this);
            if (this.initParams == null) {
                this.initParams = child;
            }
        }
        return child;
    }

    public XDSSourceElement extractSourceElement() {
        return Lib.ReadableDocument_sourceElement(this);
    }

    public DriverFilter driverFilter() {
        Lib.CheckContext(this.context, 0);
        return this.initParams == null ? XDSInitParamsElement.EMPTY_FILTER : this.initParams.driverFilter();
    }

    public String srcDN() {
        return this.initParams == null ? null : this.initParams.getSrcDN();
    }

    public String rdn() {
        return this.initParams == null ? null : this.initParams.rdn();
    }

    public String treeName() {
        return this.initParams == null ? null : this.initParams.treeName();
    }

    public String containerDN() {
        return this.initParams == null ? null : this.initParams.containerDN();
    }

    public void parameters(Map params) throws XDSParameterException {
        Lib.CheckContext(this.context, 0);
        if (this.initParams == null) {
            XDSParameterException first = null;
            XDSParameterException last = null;
            XDSParameterException current = null;
            Iterator p = params.values().iterator();
            while (p.hasNext()) {
                Parameter param = (Parameter)p.next();
                if (!param.isRequired()) continue;
                current = new XDSParameterException("Missing required parameter " + param.getParamInfo() + ".");
                if (last == null) {
                    first = current;
                    last = current;
                    continue;
                }
                last.setNext(current);
                last = current;
            }
            if (first != null) {
                throw first;
            }
        } else if (this.initParams.uniqueParams()) {
            Lib.ExtractParams(this.initParams.paramMap(), this.initParams.paramList(), params);
        } else {
            throw new XDSParameterException("Initialization document contains one or more parameters with the same tag name.  Parameter tag names must be unique.");
        }
    }

    public DTDVersion getDTDVersion() {
        return Lib.ReadableDocument_dtdVersion(this);
    }

    public XDSInitParamsElement extractInitParamsElement() {
        Lib.CheckContext(this.context, 0);
        return this.initParams;
    }

    public List childElements() {
        return super.childElements();
    }
}

