/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.DriverFilter;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.ParamParent;
import com.novell.nds.dirxml.driver.xds.XDSAuthenticationInfoElement;
import com.novell.nds.dirxml.driver.xds.XDSDriverFilterElement;
import com.novell.nds.dirxml.driver.xds.XDSDriverOptionsElement;
import com.novell.nds.dirxml.driver.xds.XDSDriverStateElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPublisherOptionsElement;
import com.novell.nds.dirxml.driver.xds.XDSPublisherStateElement;
import com.novell.nds.dirxml.driver.xds.XDSSubscriberOptionsElement;
import com.novell.nds.dirxml.driver.xds.XDSSubscriberStateElement;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Element;

public class XDSInitParamsElement
extends ElementImpl {
    public static final DriverFilter EMPTY_FILTER = new DriverFilter();
    private static final int INDEX_AUTHENTICATION_INFO = 0;
    private static final int INDEX_DRIVER_FILTER = 1;
    private static final int INDEX_DRIVER_STATE = 2;
    private static final int INDEX_PUBLISHER_STATE = 3;
    private static final int INDEX_SUBSCRIBER_STATE = 4;
    private static final int INDEX_DRIVER_OPTIONS = 5;
    private static final int INDEX_PUBLISHER_OPTIONS = 6;
    private static final int INDEX_SUBSCRIBER_OPTIONS = 7;
    private static final int NO_OF_ELEMENTS = 8;
    private static final String[] TAG_NAMES = new String[8];
    private String srcDN;
    private int[] noOfElements;
    private DriverFilter filter;
    private XDSDriverFilterElement driverFilter;
    private XDSAuthenticationInfoElement authenticationInfo;
    private XDSDriverStateElement driverState;
    private XDSPublisherStateElement publisherState;
    private XDSSubscriberStateElement subscriberState;
    private XDSDriverOptionsElement driverOptions;
    private XDSPublisherOptionsElement publisherOptions;
    private XDSSubscriberOptionsElement subscriberOptions;
    private Map paramMap;
    private List paramList;
    private boolean unique;

    XDSInitParamsElement(Element initParams, DocumentImpl myDocument) throws XDSParseException {
        super(initParams, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSInitParamsElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "init-params");
    }

    private void init() {
        this.srcDN = null;
        this.noOfElements = new int[8];
        this.paramMap = new HashMap();
        this.paramList = new ArrayList();
        this.unique = true;
        for (int i = 0; i < this.noOfElements.length; ++i) {
            this.noOfElements[i] = 0;
        }
        this.filter = null;
        this.driverFilter = null;
        this.authenticationInfo = null;
        this.driverState = null;
        this.publisherState = null;
        this.subscriberState = null;
        this.driverOptions = null;
        this.publisherOptions = null;
        this.subscriberOptions = null;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            for (int i = 0; i < 8; ++i) {
                if (this.noOfElements[i] <= 1) continue;
                throw new XDSParseException(Errors.DuplicateElement(TAG_NAMES[i]));
            }
            if (this.document.isStrict()) {
                int position = 1;
                if (this.authenticationInfo != null) {
                    if (this.authenticationInfo.position() > position) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "authentication-info", position));
                    }
                    ++position;
                }
                if (this.driverFilter != null) {
                    if (this.driverFilter.position() > position) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "driver-filter", position));
                    }
                    ++position;
                }
                if (this.driverOptions != null) {
                    if (this.driverOptions.position() > position) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "driver-options", position));
                    }
                    ++position;
                }
                if (this.subscriberOptions != null) {
                    if (this.subscriberOptions.position() > position) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "subscriber-options", position));
                    }
                    ++position;
                }
                if (this.publisherOptions != null) {
                    if (this.publisherOptions.position() > position) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "publisher-options", position));
                    }
                    ++position;
                }
                if (this.driverState != null) {
                    if (this.driverState.position() > position) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "driver-state", position));
                    }
                    ++position;
                }
                if (this.subscriberState != null) {
                    if (this.subscriberState.position() > position) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "subscriber-state", position));
                    }
                    ++position;
                }
                if (this.publisherState != null) {
                    if (this.publisherState.position() > position) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "publisher-state", position));
                    }
                    ++position;
                }
            }
        }
    }

    private void parseAttributes() {
        this.srcDN = this.attributeValueGet("src-dn");
    }

    boolean uniqueParams() {
        return this.unique;
    }

    public String rdn() {
        return XDSUtil.getRDN(this.srcDN);
    }

    public String treeName() {
        if (this.srcDN == null) {
            return null;
        }
        int firstSlash = this.srcDN.indexOf("\\");
        int secondSlash = this.srcDN.indexOf("\\", firstSlash + 1);
        String name = firstSlash == -1 ? this.srcDN : (secondSlash == -1 ? this.srcDN.substring(firstSlash + 1, this.srcDN.length()) : this.srcDN.substring(firstSlash + 1, secondSlash));
        return "".compareTo(name) == 0 ? null : name;
    }

    public String containerDN() {
        if (this.srcDN == null) {
            return null;
        }
        int lastSlash = this.srcDN.lastIndexOf("\\");
        String dn = lastSlash == -1 ? this.srcDN : this.srcDN.substring(0, lastSlash);
        return "".compareTo(dn) == 0 ? null : dn;
    }

    public String getSrcDN() {
        return this.srcDN;
    }

    public XDSDriverFilterElement extractDriverFilterElement() {
        return this.driverFilter;
    }

    public DriverFilter driverFilter() {
        Lib.CheckContext(this.document.context, 0);
        if (this.driverFilter == null || this.driverFilter.childElements().size() == 0) {
            return EMPTY_FILTER;
        }
        return new DriverFilter(this.driverFilter.domElement());
    }

    public XDSDriverOptionsElement extractDriverOptionsElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.driverOptions;
    }

    public XDSSubscriberOptionsElement extractSubscriberOptionsElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.subscriberOptions;
    }

    public XDSPublisherOptionsElement extractPublisherOptionsElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.publisherOptions;
    }

    public XDSDriverStateElement extractDriverStateElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.driverState;
    }

    public XDSSubscriberStateElement extractSubscriberStateElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.subscriberState;
    }

    public XDSPublisherStateElement extractPublisherStateElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.publisherState;
    }

    public XDSAuthenticationInfoElement extractAuthenticationInfoElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.authenticationInfo;
    }

    Map paramMap() {
        return this.paramMap;
    }

    List paramList() {
        return this.paramList;
    }

    private void addToMap(ParamParent parent) {
        ListIterator c = parent.childElements().listIterator();
        while (c.hasNext()) {
            Object o = c.next();
            if (!(o instanceof ParamElement)) continue;
            ParamElement p = (ParamElement)o;
            o = this.paramMap.put(p.tagName(), p);
            this.paramList.add(p);
            if (o == null) continue;
            this.unique = false;
        }
    }

    private void setAuthenticationInfo(XDSAuthenticationInfoElement someElement) {
        if (this.authenticationInfo == null) {
            this.authenticationInfo = someElement;
            this.addToMap(this.authenticationInfo);
        }
        this.noOfElements[0] = this.noOfElements[0] + 1;
    }

    private void setDriverFilter(XDSDriverFilterElement someElement) {
        if (this.driverFilter == null) {
            this.driverFilter = someElement;
        }
        this.noOfElements[1] = this.noOfElements[1] + 1;
    }

    private void setDriverState(XDSDriverStateElement someElement) {
        if (this.driverState == null) {
            this.driverState = someElement;
            this.addToMap(this.driverState);
        }
        this.noOfElements[2] = this.noOfElements[2] + 1;
    }

    private void setPublisherState(XDSPublisherStateElement someElement) {
        if (this.publisherState == null) {
            this.publisherState = someElement;
            this.addToMap(this.publisherState);
        }
        this.noOfElements[3] = this.noOfElements[3] + 1;
    }

    private void setSubscriberState(XDSSubscriberStateElement someElement) {
        if (this.subscriberState == null) {
            this.subscriberState = someElement;
            this.addToMap(this.subscriberState);
        }
        this.noOfElements[4] = this.noOfElements[4] + 1;
    }

    private void setDriverOptions(XDSDriverOptionsElement someElement) {
        if (this.driverOptions == null) {
            this.driverOptions = someElement;
            this.addToMap(this.driverOptions);
        }
        this.noOfElements[5] = this.noOfElements[5] + 1;
    }

    private void setPublisherOptions(XDSPublisherOptionsElement someElement) {
        if (this.publisherOptions == null) {
            this.publisherOptions = someElement;
            this.addToMap(this.publisherOptions);
        }
        this.noOfElements[6] = this.noOfElements[6] + 1;
    }

    private void setSubscriberOptions(XDSSubscriberOptionsElement someElement) {
        if (this.subscriberOptions == null) {
            this.subscriberOptions = someElement;
            this.addToMap(this.subscriberOptions);
        }
        this.noOfElements[7] = this.noOfElements[7] + 1;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("authentication-info".compareTo(tagName) == 0) {
            child = new XDSAuthenticationInfoElement(childElement, this.document);
            this.setAuthenticationInfo((XDSAuthenticationInfoElement)child);
        } else if ("driver-filter".compareTo(tagName) == 0) {
            child = new XDSDriverFilterElement(childElement, this.document);
            this.setDriverFilter((XDSDriverFilterElement)child);
        } else if ("driver-state".compareTo(tagName) == 0) {
            child = new XDSDriverStateElement(childElement, this.document);
            this.setDriverState((XDSDriverStateElement)child);
        } else if ("publisher-state".compareTo(tagName) == 0) {
            child = new XDSPublisherStateElement(childElement, this.document);
            this.setPublisherState((XDSPublisherStateElement)child);
        } else if ("subscriber-state".compareTo(tagName) == 0) {
            child = new XDSSubscriberStateElement(childElement, this.document);
            this.setSubscriberState((XDSSubscriberStateElement)child);
        } else if ("driver-options".compareTo(tagName) == 0) {
            child = new XDSDriverOptionsElement(childElement, this.document);
            this.setDriverOptions((XDSDriverOptionsElement)child);
        } else if ("publisher-options".compareTo(tagName) == 0) {
            child = new XDSPublisherOptionsElement(childElement, this.document);
            this.setPublisherOptions((XDSPublisherOptionsElement)child);
        } else if ("subscriber-options".compareTo(tagName) == 0) {
            child = new XDSSubscriberOptionsElement(childElement, this.document);
            this.setSubscriberOptions((XDSSubscriberOptionsElement)child);
        }
        return child;
    }

    public XDSDriverStateElement appendDriverStateElement() {
        Lib.CheckContext(this.document.context, 1);
        if (this.driverState == null) {
            this.driverState = new XDSDriverStateElement(this.document, this.element);
        }
        return this.driverState;
    }

    public XDSPublisherStateElement appendPublisherStateElement() {
        Lib.CheckContext(this.document.context, 1);
        if (this.publisherState == null) {
            this.publisherState = new XDSPublisherStateElement(this.document, this.element);
        }
        return this.publisherState;
    }

    public XDSSubscriberStateElement appendSubscriberStateElement() {
        Lib.CheckContext(this.document.context, 1);
        if (this.subscriberState == null) {
            this.subscriberState = new XDSSubscriberStateElement(this.document, this.element);
        }
        return this.subscriberState;
    }

    static {
        XDSInitParamsElement.TAG_NAMES[1] = "driver-filter";
        XDSInitParamsElement.TAG_NAMES[0] = "authentication-info";
        XDSInitParamsElement.TAG_NAMES[2] = "driver-state";
        XDSInitParamsElement.TAG_NAMES[3] = "publisher-state";
        XDSInitParamsElement.TAG_NAMES[4] = "subscriber-state";
        XDSInitParamsElement.TAG_NAMES[5] = "driver-options";
        XDSInitParamsElement.TAG_NAMES[6] = "publisher-options";
        XDSInitParamsElement.TAG_NAMES[7] = "subscriber-options";
    }
}

