/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.PasswordElementParent;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSOldPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import java.util.List;
import org.w3c.dom.Element;

public class XDSModifyPasswordElement
extends ElementImpl
implements CommandElement,
PasswordElementParent,
AssociationElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;
    private XDSOldPasswordElement oldPassword;
    private int noOfOldPasswords;
    private XDSPasswordElement password;
    private int noOfPasswords;

    XDSModifyPasswordElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    XDSModifyPasswordElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "modify-password");
    }

    private void init() {
        this.password = null;
        this.oldPassword = null;
        this.association = null;
        this.noOfAssociations = 0;
        this.noOfOldPasswords = 0;
        this.noOfPasswords = 0;
    }

    protected void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.noOfPasswords > 1) {
                throw new XDSParseException(Errors.DuplicateElement("password"));
            }
            if (this.password == null) {
                throw new XDSParseException(Errors.NoElement("password"));
            }
            if (this.noOfOldPasswords > 1) {
                throw new XDSParseException(Errors.DuplicateElement("old-password"));
            }
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, false);
            if (this.document.isStrict() && this.password.position() != this.children().size()) {
                throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "password", this.children().size()));
            }
        }
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String extractOldPasswordText() {
        return Lib.GetText(this, this.oldPassword);
    }

    public String extractPasswordText() {
        return Lib.PasswordElementParent_passwordText(this, this.password);
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.TextParent_extractText(this, this.association);
    }

    public XDSPasswordElement extractPasswordElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.password;
    }

    public XDSOldPasswordElement extractOldPasswordElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.oldPassword;
    }

    public String getClassName() {
        return Lib.GetAttributeValue(this, "class-name");
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    private void setPassword(XDSPasswordElement somePassword) {
        if (this.password == null) {
            this.password = somePassword;
        }
        ++this.noOfPasswords;
    }

    private void setOldPassword(XDSOldPasswordElement somePassword) {
        if (this.oldPassword == null) {
            this.oldPassword = somePassword;
        }
        ++this.noOfOldPasswords;
    }

    private void setAssociation(XDSAssociationElement someAssociation) {
        if (this.association == null) {
            this.association = someAssociation;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("password".compareTo(tagName) == 0) {
            child = new XDSPasswordElement(childElement, this.document);
            this.setPassword((XDSPasswordElement)child);
        } else if ("old-password".compareTo(tagName) == 0) {
            child = new XDSOldPasswordElement(childElement, this.document);
            this.setOldPassword((XDSOldPasswordElement)child);
        } else if ("association".compareTo(tagName) == 0) {
            child = new XDSAssociationElement(childElement, this.document);
            this.setAssociation((XDSAssociationElement)child);
        }
        return child;
    }

    public List childElements() {
        return super.childElements();
    }

    public void setEventID(String someID) {
        Lib.CommandElement_setEventID(this, someID);
    }

    public void setClassName(String someName) {
        this.attributeValueSet("class-name", someName);
    }

    public void setSrcDN(String someDN) {
        this.attributeValueSet("src-dn", someDN);
    }

    public void setDestDN(String someDN) {
        this.attributeValueSet("dest-dn", someDN);
    }

    public void setDestEntryID(String someID) {
        this.attributeValueSet("dest-entry-id", someID);
    }

    public XDSAssociationElement appendAssociationElement(String someText) {
        return Lib.AssociationElementParent_appendAssociationElement(this, someText);
    }

    public XDSPasswordElement appendPasswordElement(String someText) {
        Lib.CheckContext(this.document.context, 1);
        this.password = new XDSPasswordElement(this.document, this.element);
        this.password.appendText(someText);
        return this.password;
    }

    public XDSOldPasswordElement appendOldPasswordElement(String someText) {
        Lib.CheckContext(this.document.context, 1);
        return new XDSOldPasswordElement(this.document, this.element);
    }
}

