/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import org.w3c.dom.Element;

public class XDSParentElement
extends ElementImpl
implements AssociationElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;

    XDSParentElement(Element myParentElement, DocumentImpl myDocument) throws XDSParseException {
        super(myParentElement, myDocument);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    XDSParentElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "parent");
    }

    private void init() {
        this.association = null;
        this.noOfAssociations = 0;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, this.document.context == 1);
        }
    }

    public String getSrcDN() {
        return Lib.GetAttributeValue(this, "src-dn");
    }

    public String getQualifiedSrcDN() {
        return Lib.GetAttributeValue(this, "qualified-src-dn");
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.TextParent_extractText(this, this.association);
    }

    private void setAssociation(XDSAssociationElement someAssociation) {
        if (this.association == null) {
            this.association = someAssociation;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        XDSAssociationElement child = null;
        if ("association".compareTo(tagName) == 0) {
            child = new XDSAssociationElement(childElement, this.document);
            this.setAssociation(child);
        }
        return child;
    }

    public void setSrcDN(String someDN) {
        this.attributeValueSet("src-dn", someDN);
    }

    public XDSAssociationElement appendAssociationElement(String value) {
        return Lib.AssociationElementParent_appendAssociationElement(this, value);
    }
}

