/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import org.w3c.dom.Element;

public class XDSProductElement
extends ElementImpl
implements TextParent {
    private String text;

    XDSProductElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseChildNodes();
    }

    XDSProductElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "product");
    }

    private void init() {
        this.text = "";
    }

    protected void passText(String someText) {
        this.text = this.text + someText;
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public String getVersion() {
        return this.attributeValueGet("version");
    }

    public String getASN1ID() {
        return this.attributeValueGet("asn1id");
    }

    public String getInstance() {
        Lib.CheckContext(this.document.context, 0);
        return this.attributeValueGet("instance");
    }

    public String getBuild() {
        Lib.CheckContext(this.document.context, 0);
        return this.attributeValueGet("build");
    }

    public void setVersion(String someVersion) {
        this.setAttributeValue("version", someVersion, DTDVersion.V1_1);
    }

    public void setInstance(String someName) {
        this.setAttributeValue("instance", someName, DTDVersion.V1_1);
    }

    public void setBuild(String someID) {
        this.setAttributeValue("build", someID, DTDVersion.V1_1);
    }

    public void setASN1ID(String someID) {
        this.attributeValueSet("asn1id", someID);
    }

    public void appendText(String someText) {
        Lib.TextParent_appendText(this, someText);
    }
}

