/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.NDSVersion;
import com.novell.nds.dirxml.driver.xds.ReadableDocument;
import com.novell.nds.dirxml.driver.xds.ValidationLevel;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryExElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XDSQueryDocument
extends DocumentImpl
implements ReadableDocument,
WriteableDocument {
    private XDSInitParamsElement[] initParams;
    private List queries;

    public XDSQueryDocument(XmlDocument xdsXML) throws XDSParseException {
        super(xdsXML, "input", 0, DEFAULT_READ_VALIDATION_LEVEL);
        this.readInit();
        this.parseChildNodes();
    }

    public XDSQueryDocument() {
        super("input", 1, NDSVersion.CURRENT, DTDVersion.CURRENT);
        this.writeInit();
    }

    public XDSQueryDocument(DTDVersion dtdVersion) {
        super("input", 1, NDSVersion.CURRENT, dtdVersion);
        this.writeInit();
    }

    private XDSQueryDocument(Document domDocument, ValidationLevel someLevel) throws XDSParseException {
        super(domDocument, "input", 1, someLevel);
        this.readInit();
        this.parseChildNodes();
    }

    private void readInit() {
        this.initParams = null;
        this.queries = Collections.EMPTY_LIST;
        this.commandContainer = true;
    }

    private void writeInit() {
        this.queries = null;
        this.initParams = new XDSInitParamsElement[1];
        this.initParams[0] = null;
    }

    public XDSSourceElement extractSourceElement() {
        return this.source;
    }

    public List extractQueryElements() {
        Lib.CheckContext(this.context, 0);
        if (this.isStrict()) {
            return this.childElements();
        }
        return this.queries;
    }

    public DTDVersion getDTDVersion() {
        return Lib.ReadableDocument_dtdVersion(this);
    }

    public List childElements() {
        return super.childElements();
    }

    private void addQuery(XDSQueryElement someQuery, int noOfElements) {
        if (!this.isStrict()) {
            if (this.queries == Collections.EMPTY_LIST) {
                this.queries = new ArrayList(noOfElements);
            }
            this.queries.add(someQuery);
        }
    }

    protected ElementImpl parseChildElement(Element domElement, String tagName, int position, int noOfElements) throws XDSParseException {
        XDSQueryElement child = null;
        if ("query".compareTo(tagName) == 0) {
            child = new XDSQueryElement(domElement, this);
            this.addQuery(child, noOfElements);
        } else if ("query-ex".compareTo(tagName) == 0) {
            child = new XDSQueryExElement(domElement, this);
            this.addQuery(child, noOfElements);
        }
        return child;
    }

    public XDSQueryElement appendQueryElement() {
        return new XDSQueryElement(this, this.ioElement);
    }

    public XDSQueryExElement appendQueryExElement() {
        Lib.CheckContext(this.context, 1);
        Lib.CheckVersion(this.version, DTDVersion.V2_0);
        return new XDSQueryExElement(this, this.ioElement);
    }

    public XDSSourceElement appendSourceElement() {
        this.source = Lib.WriteableDocument_appendSourceElement(this, this.source);
        return this.source;
    }

    public void validate() throws XDSParseException {
        new XDSQueryDocument(this.document, ValidationLevel.STRICT);
    }

    public XmlDocument toXML() {
        return Lib.WriteableDocument_toXML(this);
    }

    public void empty() {
        Lib.WriteableDocument_setEmpty(this);
    }
}

