/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DTD;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryTokenElement;
import com.novell.nds.dirxml.driver.xds._Boolean;
import java.util.List;
import org.w3c.dom.Element;

public class XDSQueryExElement
extends XDSQueryElement
implements CommandElement,
AssociationElementParent {
    private static final Integer ILLEGAL_RESULT_COUNT = new Integer(Integer.MAX_VALUE);
    private Integer maxResultCount;
    private String sMaxResultCount;
    private _Boolean cancel;
    private XDSQueryTokenElement queryToken;
    private int noOfTokens;

    XDSQueryExElement(Element query, DocumentImpl myDocument) throws XDSParseException {
        super(query, myDocument);
        this.noOfTokens = 0;
        this.maxResultCount = UNLIMITED_RESULTS;
        this.parseAttributes();
        this.validate();
    }

    XDSQueryExElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "query-ex");
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.noOfTokens > 1) {
                throw new XDSParseException(Errors.DuplicateElement("query-token"));
            }
            if (this.maxResultCount == ILLEGAL_RESULT_COUNT) {
                throw new XDSParseException(Errors.BadAttributeValue("max-result-count", this.sMaxResultCount));
            }
            if (this.maxResultCount < 1) {
                throw new XDSParseException(Errors.BadAttributeValue("max-result-count", this.sMaxResultCount));
            }
            if (this.cancel.equals(_Boolean.ILLEGAL)) {
                throw new XDSParseException(Errors.BadBooleanType(this.cancel.toString()));
            }
        }
    }

    public boolean isIdentity() {
        Lib.CheckContext(this.document.context, 0);
        return false;
    }

    private void parseAttributes() throws XDSParseException {
        this.sMaxResultCount = this.attributeValueGet("max-result-count");
        if (this.sMaxResultCount == null) {
            this.maxResultCount = UNLIMITED_RESULTS;
        } else {
            try {
                this.maxResultCount = new Integer(this.sMaxResultCount.trim());
            }
            catch (IllegalArgumentException iae) {
                this.maxResultCount = ILLEGAL_RESULT_COUNT;
            }
        }
        this.cancel = _Boolean.getBoolean(this.attributeValueGet("cancel"), _Boolean.FALSE);
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("query-token".equals(tagName)) {
            this.setQueryToken(new XDSQueryTokenElement(childElement, this.document));
            child = this.queryToken;
        } else {
            child = super.parseChildElement(childElement, tagName, position, noOfElements);
        }
        return child;
    }

    private void setQueryToken(XDSQueryTokenElement someToken) {
        if (this.queryToken == null) {
            this.queryToken = someToken;
        }
        ++this.noOfTokens;
    }

    public int getMaxResultCount() {
        Lib.CheckContext(this.document.context, 0);
        return this.maxResultCount;
    }

    public boolean getCancel() {
        Lib.CheckContext(this.document.context, 0);
        return this.cancel.toPrimitive();
    }

    public boolean isCancelled() {
        Lib.CheckContext(this.document.context, 0);
        return this.cancel.toPrimitive();
    }

    public boolean containsQueryToken() {
        Lib.CheckContext(this.document.context, 0);
        return this.queryToken != null;
    }

    public XDSQueryTokenElement extractQueryToken() {
        Lib.CheckContext(this.document.context, 0);
        return this.queryToken;
    }

    public String extractQueryTokenText() {
        return Lib.TextParent_extractText(this, this.queryToken);
    }

    public boolean hasUnlimitedResults() {
        Lib.CheckContext(this.document.context, 0);
        return UNLIMITED_RESULTS.equals(this.maxResultCount);
    }

    public boolean hasLimitedResults() {
        Lib.CheckContext(this.document.context, 0);
        return !this.hasUnlimitedResults();
    }

    public boolean isInitialQuery() {
        Lib.CheckContext(this.document.context, 0);
        return this.queryToken == null;
    }

    public boolean isSubsequentQuery() {
        Lib.CheckContext(this.document.context, 0);
        return this.queryToken != null;
    }

    public boolean isExtended() {
        Lib.CheckContext(this.document.context, 0);
        return !this.hasEntryScope() && !this.hasUnlimitedResults();
    }

    public List childElements() {
        return super.childElements();
    }

    public void setCancel(boolean cancel) {
        this.attributeValueSet("cancel", DTD.GetStringValue(cancel));
    }

    public void setMaxResultCount(int someCount) {
        this.attributeValueSet("max-result-count", String.valueOf(someCount));
    }

    public XDSQueryTokenElement appendQueryTokenElement(String someToken) {
        return Lib.QueryTokenParent_appendQueryTokenElement(this.document, this.element, someToken);
    }
}

