/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.NDSVersion;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.ValidationLevel;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSInstanceElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryTokenElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XDSQueryResultDocument
extends DocumentImpl
implements QueryResultDocument {
    private List[] instanceElements;
    private List[] statusElements;
    private Map[] statusMap;
    private XDSStatusElement[] mostSevere;
    private List[] queryTokens;

    public XDSQueryResultDocument(XmlDocument xdsXML) throws XDSParseException {
        super(xdsXML, "output", 0, DEFAULT_READ_VALIDATION_LEVEL);
        this.readInit();
        this.parseChildNodes();
    }

    public XDSQueryResultDocument() {
        super("output", 1, NDSVersion.CURRENT, DTDVersion.CURRENT);
        this.writeInit();
    }

    public XDSQueryResultDocument(DTDVersion dtdVersion) {
        super("output", 1, NDSVersion.CURRENT, dtdVersion);
        this.writeInit();
    }

    private XDSQueryResultDocument(Document someDocument, ValidationLevel someLevel) throws XDSParseException {
        super(someDocument, "output", 1, someLevel);
        this.readInit();
        this.parseChildNodes();
    }

    private void readInit() {
        this.statusMap = new Map[1];
        this.statusMap[0] = XDS.EMPTY_MAP;
        this.instanceElements = new List[1];
        this.instanceElements[0] = Collections.EMPTY_LIST;
        this.statusElements = new List[1];
        this.statusElements[0] = Collections.EMPTY_LIST;
        this.mostSevere = new XDSStatusElement[1];
        this.mostSevere[0] = null;
        this.queryTokens = new List[1];
        this.queryTokens[0] = Collections.EMPTY_LIST;
    }

    private void writeInit() {
        this.statusMap = null;
        this.instanceElements = null;
        this.statusElements = null;
        this.mostSevere = null;
    }

    public DTDVersion getDTDVersion() {
        Lib.CheckContext(this.context, 0);
        return this.version;
    }

    public XDSSourceElement extractSourceElement() {
        return this.source;
    }

    public boolean containsQueryTokenElements() {
        return Lib.QueryResultDocument_containsQueryTokenElements(this, this.queryTokens);
    }

    public boolean containsQueryToken(String someToken) {
        return Lib.QueryResultDocument_containsQueryToken(this, this.queryTokens, someToken);
    }

    public List extractQueryTokenElements() {
        return Lib.QueryResultDocument_extractQueryTokenElements(this, this.queryTokens);
    }

    public List extractStatusElements(String someID) {
        return Lib.QueryResultDocument_extractStatusElements(this, this.statusMap, this.statusElements, someID);
    }

    public List extractStatusElements() {
        return Lib.GetElements((DocumentImpl)this, this.statusElements);
    }

    public XDSStatusElement mostSevereStatusElement(String someID) {
        return Lib.ResultDocument_mostSevereStatusElement(this, someID, this.statusMap, this.statusElements, this.mostSevere);
    }

    public StatusLevel mostSevereStatusLevel(String someID) {
        return Lib.ResultDocument_mostSevereStatusLevel(this, someID, this.statusMap, this.statusElements, this.mostSevere);
    }

    public List extractInstanceElements() {
        return Lib.GetElements((DocumentImpl)this, this.instanceElements);
    }

    public List childElements() {
        return super.childElements();
    }

    protected ElementImpl parseChildElement(Element domElement, String tagName, int position, int noOfElements) throws XDSParseException {
        return Lib.QueryResultDocument_parseChildElement(this, domElement, tagName, position, noOfElements, this.statusElements, this.instanceElements, this.mostSevere, this.queryTokens);
    }

    public XDSInstanceElement appendInstanceElement() {
        return Lib.QueryResultDocument_appendInstanceElement(this);
    }

    public XDSQueryTokenElement appendQueryTokenElement(String someToken) {
        return Lib.QueryTokenParent_appendQueryTokenElement(this, this.ioElement, someToken);
    }

    public void validate() throws XDSParseException {
        new XDSQueryResultDocument(this.document, ValidationLevel.STRICT);
    }

    public XDSSourceElement appendSourceElement() {
        this.source = Lib.WriteableDocument_appendSourceElement(this, this.source);
        return this.source;
    }

    public XmlDocument toXML() {
        return Lib.WriteableDocument_toXML(this);
    }

    public void empty() {
        Lib.WriteableDocument_setEmpty(this);
    }

    public XDSStatusElement appendStatusElement() {
        return Lib.StatusDocument_appendStatusElement(this);
    }
}

