/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DTD;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSNewNameElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds._Boolean;
import java.util.List;
import org.w3c.dom.Element;

public class XDSRenameElement
extends ElementImpl
implements CommandElement,
AssociationElementParent {
    private static final _Boolean DEFAULT_REMOVE_OLD_NAME = _Boolean.TRUE;
    private XDSAssociationElement association;
    private XDSNewNameElement newName;
    private _Boolean removeOldName;
    private int noOfAssociations;
    private int noOfNewNames;

    XDSRenameElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSRenameElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "rename");
    }

    private void init() {
        this.removeOldName = DEFAULT_REMOVE_OLD_NAME;
        this.association = null;
        this.newName = null;
        this.noOfAssociations = 0;
        this.noOfNewNames = 0;
    }

    private void parseAttributes() {
        this.removeOldName = _Boolean.getBoolean(this.attributeValueGet("remove-old-name"), DEFAULT_REMOVE_OLD_NAME);
    }

    protected void validate() throws XDSParseException {
        if (this.document.validate) {
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
            if (this.newName == null) {
                throw new XDSParseException(Errors.NoElement("new-name"));
            }
            if (this.noOfNewNames > 1) {
                throw new XDSParseException(Errors.DuplicateElement("new-name"));
            }
            if (this.removeOldName.equals(_Boolean.ILLEGAL)) {
                throw new XDSParseException(Errors.BadBooleanType(this.removeOldName.toString()));
            }
        }
    }

    public List childElements() {
        return super.childElements();
    }

    public String getClassName() {
        return Lib.GetAttributeValue(this, "class-name");
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getQualifiedOldSrcDN() {
        return Lib.GetAttributeValue(this, "qualified-old-src-dn");
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getOldSrcDN() {
        return Lib.GetAttributeValue(this, "old-src-dn");
    }

    public boolean getRemoveOldName() {
        return Lib.GetValue((ElementImpl)this, this.removeOldName);
    }

    public XDSNewNameElement extractNewNameElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.newName;
    }

    public String extractNewNameText() {
        return Lib.GetText(this, this.newName);
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.TextParent_extractText(this, this.association);
    }

    private void setNewName(XDSNewNameElement someName) {
        if (this.newName == null) {
            this.newName = someName;
        }
        ++this.noOfNewNames;
    }

    private void setAssociation(XDSAssociationElement someAssociation) {
        if (this.association == null) {
            this.association = someAssociation;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("new-name".equals(tagName)) {
            child = new XDSNewNameElement(childElement, this.document);
            this.setNewName((XDSNewNameElement)child);
        } else if ("association".compareTo(tagName) == 0) {
            child = new XDSAssociationElement(childElement, this.document);
            this.setAssociation((XDSAssociationElement)child);
        }
        return child;
    }

    public XDSNewNameElement appendNewNameElement(String someName) {
        Lib.CheckContext(this.document.context, 1);
        XDSNewNameElement newName = new XDSNewNameElement(this.document, this.element);
        newName.appendText(someName);
        return newName;
    }

    public void setSrcDN(String someDN) {
        this.attributeValueSet("src-dn", someDN);
    }

    public void setRemoveOldName(boolean value) {
        this.attributeValueSet("remove-old-name", DTD.GetStringValue(value));
    }

    public void setClassName(String someName) {
        this.attributeValueSet("class-name", someName);
    }

    public void setEventID(String someID) {
        this.attributeValueSet("event-id", someID);
    }

    public void setOldSrcDN(String someDN) {
        this.attributeValueSet("old-src-dn", someDN);
    }

    public void setDestDN(String someDN) {
        this.attributeValueSet("dest-dn", someDN);
    }

    public void setDestEntryID(String someID) {
        this.attributeValueSet("dest-entry-id", someID);
    }

    public XDSAssociationElement appendAssociationElement(String someText) {
        return Lib.AssociationElementParent_appendAssociationElement(this, someText);
    }
}

