/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DescriptionElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.ExceptionElement;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.xml.dom.DOMQuery;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XDSStatusElement
extends ElementImpl
implements TextParent,
Comparable {
    private static final String TAG_DOCUMENT = "document";
    private static final String COMMENT_SUPPRESSED = "content suppressed";
    private static final String[] SENSITIVE_XPATH = new String[]{"//*[@is-sensitive = 'true']", "//password", "//old-password"};
    private String level;
    private StatusLevel statusLevel;
    private StatusType statusType;
    private DescriptionElement description;
    private String text;

    XDSStatusElement(Element statusElement, DocumentImpl myDocument) throws XDSParseException {
        super(statusElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSStatusElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "status");
    }

    private void init() {
        this.level = null;
        this.statusLevel = null;
        this.statusType = null;
        this.description = null;
        this.text = "";
        this.anyContent = true;
    }

    protected void passText(String someText) throws XDSParseException {
        this.text = this.text + someText;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.statusLevel == null) {
            if (this.level == null) {
                this.throwMissingAttributeException("level");
            } else {
                throw new XDSParseException(Errors.BadAttributeValue("level", this.level));
            }
        }
    }

    private void parseAttributes() throws XDSParseException {
        this.level = this.attributeValueGet("level");
        this.statusLevel = StatusLevel.getLevel(this.level);
        this.statusType = StatusType.Lookup(this.attributeValueGet("type"));
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        DescriptionElement child = null;
        if ("description".compareTo(tagName) == 0) {
            this.description = child = new DescriptionElement(childElement, this.document);
        }
        return child;
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public StatusType getType() {
        Lib.CheckContext(this.document.context, 0);
        return this.statusType;
    }

    public StatusLevel getLevel() {
        Lib.CheckContext(this.document.context, 0);
        return this.statusLevel;
    }

    public String getEventID() {
        return Lib.GetAttributeValue(this, "event-id");
    }

    public DescriptionElement descriptionElementExtract() {
        Lib.CheckContext(this.document.context, 0);
        return this.description;
    }

    public String descriptionTextExtract() {
        return Lib.GetText(this, this.description);
    }

    public void setLevel(StatusLevel someLevel) {
        if (someLevel != null) {
            this.element.setAttribute("level", someLevel.toString());
        }
    }

    public void setType(StatusType someType) {
        this.setAttributeValue("type", someType, DTDVersion.V1_1);
    }

    public void setEventID(String someID) {
        this.attributeValueSet("event-id", someID);
    }

    public void appendText(String someText) {
        Lib.TextParent_appendText(this, someText);
    }

    public void parametersAppend(Map params) {
        Lib.CheckParam(params, "params");
        if (params.size() > 0) {
            Document domDoc = this.domDocument();
            Element parent = domDoc.createElement("options");
            this.element.appendChild(parent);
            this.appendParams(parent, params.values());
        }
    }

    private void appendParams(Element parent, Collection params) {
        if (params.size() > 0) {
            ArrayList sorted = new ArrayList(params.size());
            sorted.addAll(params);
            Collections.sort(sorted);
            Document domDoc = this.domDocument();
            ListIterator p = sorted.listIterator();
            while (p.hasNext()) {
                String description;
                Element child;
                Parameter param = (Parameter)p.next();
                if (param.isStructured()) {
                    while (param != null) {
                        if (param.isSet()) {
                            int instanceID;
                            child = domDoc.createElement(param.tagName());
                            parent.appendChild(child);
                            description = param.getDisplayName();
                            if (description != null) {
                                child.setAttribute("display-name", description);
                            }
                            if ((instanceID = param.getInstanceID()) > -1) {
                                child.setAttribute("instance-id", String.valueOf(instanceID));
                            }
                            this.appendParams(child, param.getParameters());
                        }
                        param = param.getNext();
                    }
                    continue;
                }
                if (!param.isScalar()) continue;
                List list = param.toList();
                if (list.isEmpty()) {
                    child = domDoc.createElement(param.tagName());
                    parent.appendChild(child);
                    continue;
                }
                ListIterator l = list.listIterator();
                while (l.hasNext()) {
                    Object value = l.next();
                    child = domDoc.createElement(param.tagName());
                    parent.appendChild(child);
                    description = param.getDisplayName();
                    if (description != null) {
                        child.setAttribute("display-name", description);
                    }
                    CharacterData content = param.isContentSensitive() ? domDoc.createComment("content suppressed!") : domDoc.createTextNode(value.toString());
                    child.appendChild(content);
                }
            }
        }
    }

    public void descriptionAppend(String someText) {
        Lib.CheckContext(this.document.context, 1);
        if (Lib.IsValue(someText)) {
            DescriptionElement temp = new DescriptionElement(this.document, this.element);
            temp.appendText(someText);
        }
    }

    public void documentAppend(XmlDocument xml) {
        if (xml == null) {
            return;
        }
        StringWriter writer = new StringWriter();
        xml = XDSStatusElement.SuppressContent(xml);
        try {
            DOMUtil.printDocumentWithFormat((Writer)writer, (Document)xml.getDocument());
            Element docElement = this.document.document.createElement(TAG_DOCUMENT);
            this.element.appendChild(docElement);
            docElement.setAttribute("xml:space", "preserve");
            docElement.appendChild(docElement.getOwnerDocument().createTextNode(writer.toString()));
        }
        catch (IOException io) {
            // empty catch block
        }
    }

    static XmlDocument SuppressContent(XmlDocument xml) {
        Document doc = xml.getDocument();
        for (int i = 0; i < SENSITIVE_XPATH.length; ++i) {
            try {
                DOMQuery query = new DOMQuery(SENSITIVE_XPATH[i]);
                NodeSet set = query.evaluate((Node)doc.getDocumentElement());
                Node oldChild = set.first();
                while (oldChild != null) {
                    Node parent = oldChild.getParentNode();
                    if (parent != null) {
                        Node newChild = oldChild.cloneNode(false);
                        Comment comment = oldChild.getOwnerDocument().createComment(COMMENT_SUPPRESSED);
                        newChild.appendChild(comment);
                        parent.replaceChild(newChild, oldChild);
                    }
                    oldChild = set.next();
                }
                continue;
            }
            catch (XPathEvaluationException e) {
                throw new RuntimeException("Broken XPATH expression.");
            }
        }
        return new XmlDocument(doc);
    }

    public void exceptionAppend(Exception e, boolean stack) {
        this.exceptionAppend((Throwable)e, stack);
    }

    public void exceptionAppend(Throwable t, boolean stack) {
        if (t != null) {
            ExceptionElement temp = new ExceptionElement(this.document, this.element);
            temp.attributeValueSet("class-name", t.getClass().getName());
            temp.messageAppend(t);
            if (stack) {
                temp.stackTraceAppend(t);
            }
        }
    }

    public int compareTo(Object someStatus) {
        if (someStatus == null) {
            return -1;
        }
        if (this.statusLevel == null) {
            return 1;
        }
        return this.statusLevel.compareTo(((XDSStatusElement)someStatus).getLevel());
    }
}

