/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.util;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DriverException
extends Exception {
    public static final int CAT_ERROR = 0;
    public static final int CAT_AUTH = 1;
    public static final int CAT_CONNECT = 2;
    public static final int CAT_RETRY = 4;
    public static final int CAT_FATAL = 8;
    private static final StatusLevel DEFAULT_LEVEL = StatusLevel.ERROR;
    private static final StatusType DEFAULT_TYPE = StatusType.DRIVER_GENERAL;
    private StatusLevel level;
    private int category;
    private StatusType type;
    private List throwables;
    private boolean printStackTrace;
    private String message;
    private XmlDocument doc;
    private String id;
    private boolean appendDocument;

    public DriverException(String someMessage) {
        this.message = someMessage;
        this.init();
        this.setLevel(DEFAULT_LEVEL);
    }

    private void init() {
        this.category = 0;
        this.type = DEFAULT_TYPE;
        this.throwables = Collections.EMPTY_LIST;
        this.printStackTrace = false;
        this.id = null;
        this.doc = null;
        this.appendDocument = true;
    }

    public void appendPreMessage(String someMessage) {
        if (XDSUtil.isValue(someMessage)) {
            if (this.message == null) {
                this.message = someMessage;
            } else {
                StringBuffer buffer = new StringBuffer(someMessage.length() + this.message.length() + 2);
                buffer.append(someMessage);
                buffer.append("  ");
                buffer.append(this.message);
                this.message = buffer.toString();
            }
        }
    }

    public void appendPostMessage(String someMessage) {
        if (XDSUtil.isValue(someMessage)) {
            if (this.message == null) {
                this.message = someMessage;
            } else {
                StringBuffer buffer = new StringBuffer(someMessage.length() + this.message.length() + 2);
                buffer.append(this.message);
                buffer.append("  ");
                buffer.append(someMessage);
                this.message = buffer.toString();
            }
        }
    }

    public void addThrowables(List someThrowables) {
        if (someThrowables == null) {
            return;
        }
        if (this.throwables == Collections.EMPTY_LIST) {
            this.throwables = new ArrayList(someThrowables.size());
        }
        this.throwables.addAll(someThrowables);
    }

    public void addThrowble(Throwable someThrowable) {
        if (someThrowable == null) {
            return;
        }
        if (this.throwables == Collections.EMPTY_LIST) {
            this.throwables = new LinkedList();
        }
        this.throwables.add(someThrowable);
    }

    public void setPrintStackTrace(boolean value) {
        this.printStackTrace = value;
    }

    public void setAppendDocument(boolean value) {
        this.appendDocument = value;
    }

    public boolean getAppendDocument() {
        return this.appendDocument;
    }

    public boolean getPrintStackTrace() {
        return this.printStackTrace;
    }

    public List getThrowables() {
        return this.throwables;
    }

    public void setLevel(StatusLevel someLevel) {
        this.level = someLevel;
    }

    public StatusLevel getLevel() {
        return this.level;
    }

    public void setType(StatusType someType) {
        this.type = someType;
    }

    public StatusType getType() {
        return this.type;
    }

    public void setCategory(int someCategory) {
        this.category = 0;
        this.category |= someCategory;
    }

    public boolean isFatal() {
        return this.level == StatusLevel.FATAL || (this.category & 8) != 0;
    }

    public boolean isAuthenticationRelated() {
        return (this.category & 1) != 0;
    }

    public boolean isConnectivityRelated() {
        return (this.category & 2) != 0;
    }

    public boolean isSpecialCondition() {
        return this.category != 0 || this.level == StatusLevel.FATAL;
    }

    public boolean isRetry() {
        return (this.category & 4) != 0;
    }

    public String getMessage() {
        return this.message == null ? "" : this.message;
    }

    public void setDocument(XmlDocument someDoc) {
        this.doc = someDoc;
    }

    public XmlDocument getDocument() {
        return this.doc;
    }

    public void setEventID(String someID) {
        this.id = someID;
    }

    public String getEventID() {
        return this.id;
    }
}

