/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.util;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.util.Java;
import com.novell.nds.dirxml.driver.xds.util.TimeUtil;

public class DriverTrace {
    public static final int LEVEL_NONE = Integer.MAX_VALUE;
    private int implLevel;
    private Trace impl;
    private int bufferLevel;
    private StringBuffer buffer;
    private int indent;

    public DriverTrace() {
        try {
            this.setImpl(new Trace(null));
        }
        catch (Error e) {
            this.setImpl(null);
        }
        this.init();
    }

    public DriverTrace(Trace someTrace) {
        if (someTrace == null) {
            throw new IllegalArgumentException();
        }
        this.setImpl(someTrace);
        this.init();
    }

    private void init() {
        this.buffer = new StringBuffer(512);
        this.indent = 0;
    }

    public Trace getImpl() {
        return this.impl;
    }

    private void setImpl(Trace someTrace) {
        this.impl = someTrace;
        this.implLevel = this.impl == null ? Integer.MAX_VALUE : this.impl.getTraceLevel();
    }

    private boolean haveImpl() {
        return this.impl != null;
    }

    public void resetIndent() {
        this.indent(0);
        if (this.haveImpl()) {
            this.impl.resetIndent();
        }
    }

    public void indent(int noOfTabs) {
        this.indent = noOfTabs;
        if (this.haveImpl()) {
            this.impl.pushIndent(noOfTabs);
        }
    }

    public void indent() {
        ++this.indent;
        if (this.haveImpl()) {
            this.impl.pushIndent(this.indent);
        }
    }

    public void outdent() {
        --this.indent;
        if (this.haveImpl()) {
            this.impl.popIndent();
        }
    }

    public boolean willTrace(int level) {
        return level <= this.implLevel;
    }

    public void trace(String aMessage, int aLevel) {
        if (this.willTrace(aLevel)) {
            this.traceImpl(aMessage, aLevel);
        }
    }

    private void traceImpl(XmlDocument xml, int level) {
        xml.setIndent(true);
        if (this.haveImpl()) {
            this.impl.trace(xml, level);
        } else {
            this.sysOut(xml.getDocumentString());
        }
    }

    private void traceImpl(String message) {
        if (this.haveImpl()) {
            this.impl.trace(message);
        } else {
            this.sysOut(message);
        }
    }

    private void traceImpl(String message, int level) {
        if (this.haveImpl()) {
            this.impl.trace(message, level);
        } else {
            this.sysOut(message);
        }
    }

    private void sysOut(String message) {
        for (int t = 0; t < this.indent; ++t) {
            System.out.print("\t");
        }
        System.out.println(message);
    }

    public void trace(String aMessage) {
        this.traceImpl(aMessage, -1);
    }

    public void trace(Throwable t, int aLevel) {
        if (t != null && this.willTrace(aLevel)) {
            this.traceImpl(t.toString(), aLevel);
            if (Java.isJRE(1, 4) && (t = t.getCause()) != null) {
                this.traceImpl(t.toString(), aLevel);
            }
        }
    }

    public void trace(XmlDocument xml, int level) {
        if (this.willTrace(level)) {
            xml.setIndent(true);
            this.traceImpl(xml, level);
        }
    }

    public void sleepInterval(long interval, int level) {
        if (interval > 0L && this.willTrace(level)) {
            long[] remainder = new long[1];
            long days = TimeUtil.toDaysFromMillis(interval, remainder);
            this.clear();
            this.setBufferLevel(level);
            this.buffer.append("Sleeping for ");
            if (days > 30L) {
                this.buffer.append("a really, really long time.");
            } else {
                long hours = TimeUtil.toHoursFromMillis(remainder[0], remainder);
                long minutes = TimeUtil.toMinutesFromMillis(remainder[0], remainder);
                long seconds = TimeUtil.toSecondsFromMillis(remainder[0], remainder);
                long millis = remainder[0];
                if (days != 0L) {
                    this.buffer.append(days + " day(s), ");
                }
                if (hours != 0L) {
                    this.buffer.append(hours + " hour(s), ");
                }
                if (minutes != 0L) {
                    this.buffer.append(minutes + " minute(s), ");
                }
                if (seconds != 0L) {
                    this.buffer.append(seconds + " second(s), ");
                }
                this.buffer.append(millis + " millisecond(s).");
            }
            this.flush();
        }
    }

    public void setBufferLevel(int someLevel) {
        this.bufferLevel = someLevel;
    }

    public DriverTrace buffer(String string) {
        this.buffer.append(string);
        return this;
    }

    public DriverTrace buffer(Object object) {
        this.buffer.append(object);
        return this;
    }

    public DriverTrace buffer(double d) {
        this.buffer.append(d);
        return this;
    }

    public DriverTrace buffer(long l) {
        this.buffer.append(l);
        return this;
    }

    public DriverTrace buffer(int i) {
        this.buffer.append(i);
        return this;
    }

    public DriverTrace buffer(boolean b) {
        this.buffer.append(b);
        return this;
    }

    public String flush() {
        String flush = this.buffer.toString();
        if (this.buffer.length() > 0) {
            this.traceImpl(flush, this.bufferLevel);
        }
        this.clear();
        return flush;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void clear() {
        Java.clear(this.buffer);
    }
}

