/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.util;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.util.Errors;
import com.novell.nds.dirxml.driver.xds.util.Java;
import com.novell.nds.dirxml.driver.xds.util.Lib;
import com.novell.nds.dirxml.driver.xds.util.Lib_1_4;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XDSUtil {
    private static final Set CHILD_ELEMENTS_OF_IN_OUT = new HashSet();

    private XDSUtil() {
    }

    public static boolean isChildOfInputOrOutput(Element element) {
        boolean is = false;
        if (element != null) {
            is = CHILD_ELEMENTS_OF_IN_OUT.contains(element.getTagName());
        }
        return is;
    }

    public static final boolean isInputOrOutputElement(Element element) {
        boolean is = false;
        if (element != null) {
            is = "input".compareTo(element.getTagName()) == 0 || "output".compareTo(element.getTagName()) == 0;
        }
        return is;
    }

    public static final boolean isNDSElement(Element element) {
        boolean is = false;
        if (element != null) {
            is = "nds".compareTo(element.getTagName()) == 0;
        }
        return is;
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bytes);
        t.printStackTrace(writer);
        writer.flush();
        writer.close();
        return bytes.toString();
    }

    public static long toMillis(int seconds) {
        return seconds * 1000;
    }

    public static XDSStatusElement appendStatus(StatusDocument doc, StatusAttributes attrs, String description) {
        XDSStatusElement status = doc.appendStatusElement();
        if (attrs != null) {
            status.setLevel(attrs.getLevel());
            status.setType(attrs.getType());
            status.setEventID(attrs.getEventID());
        }
        status.descriptionAppend(description);
        return status;
    }

    private static XDSStatusElement appendStatus(StatusDocument doc, StatusAttributes attrs, XDSParameterException p, XmlDocument xml) {
        XDSStatusElement status = null;
        for (XDSParameterException next = p; next != null; next = next.getNext()) {
            status = XDSUtil.appendStatus(doc, attrs, next.getMessage());
        }
        if (status != null && xml != null) {
            status.documentAppend(xml);
        }
        return status;
    }

    private static String getDescription(String description, Throwable throwable) {
        if (description == null) {
            if (throwable == null) {
                return null;
            }
            return throwable.toString();
        }
        return description;
    }

    public static XDSStatusElement appendStatus(StatusDocument doc, StatusAttributes attrs, String description, Exception exception, boolean stack, XmlDocument xml) {
        XDSStatusElement status = null;
        if (doc != null) {
            if (exception instanceof XDSParameterException) {
                status = XDSUtil.appendStatus(doc, attrs, (XDSParameterException)exception, xml);
            } else {
                status = doc.appendStatusElement();
                if (attrs != null) {
                    status.setLevel(attrs.getLevel());
                    status.setType(attrs.getType());
                    status.setEventID(attrs.getEventID());
                }
                status.descriptionAppend(XDSUtil.getDescription(description, exception));
                status.exceptionAppend(exception, stack);
                if (Java.isJRE(1, 4)) {
                    // empty if block
                }
                Lib_1_4.causeAppend(status.documentImpl(), status.domElement(), exception, stack);
                status.documentAppend(xml);
            }
        }
        return status;
    }

    public static void appendXML(Element element, String xml) {
        if (XDSUtil.isValue(xml) && element != null) {
            Node copy;
            Document doc = element.getOwnerDocument();
            XmlDocument tempXML = new XmlDocument(xml);
            Document tempDOM = tempXML.getDocument();
            if (tempDOM != null && (copy = Lib.cloneSubtree(doc, tempDOM.getDocumentElement())) != null) {
                element.appendChild(copy);
            }
        }
    }

    public static final void appendThrowable(Element root, Throwable t, boolean appendStackTrace) {
        Text text;
        if (t == null || root == null) {
            return;
        }
        Document doc = root.getOwnerDocument();
        Element exceptionElement = doc.createElement("exception");
        root.appendChild(exceptionElement);
        String string = t.getClass().getName();
        if (XDSUtil.isValue(string)) {
            exceptionElement.setAttribute("class-name", string);
        }
        if (XDSUtil.isValue(string = t.getMessage())) {
            Element messageElement = doc.createElement("message");
            exceptionElement.appendChild(messageElement);
            text = doc.createTextNode(string);
            messageElement.appendChild(text);
        }
        if (appendStackTrace && XDSUtil.isValue(string = XDSUtil.getStackTrace(t))) {
            Element stackTraceElement = doc.createElement("stack-trace");
            exceptionElement.appendChild(stackTraceElement);
            text = doc.createTextNode(string);
            stackTraceElement.appendChild(text);
        }
    }

    public static void appendNode(Node dest, Node src) {
        Document doc;
        Node srcCopy;
        if (dest != null && src != null && (srcCopy = Lib.cloneSubtree(doc = dest.getOwnerDocument(), src)) != null) {
            dest.appendChild(srcCopy);
        }
    }

    public static boolean appendStackTrace(Exception e) {
        return e instanceof RuntimeException;
    }

    public static boolean isWhitespace(String s) {
        if (s == null) {
            return false;
        }
        int length = s.length();
        if (length == 0) {
            return true;
        }
        if (length == 1) {
            return Character.isWhitespace(s.charAt(0));
        }
        char[] chars = s.toCharArray();
        for (int c = 0; c < chars.length; ++c) {
            if (Character.isWhitespace(chars[c])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isValue(String string) {
        return string != null && !XDSUtil.isWhitespace(string);
    }

    public static final boolean noValue(String string) {
        return string == null || XDSUtil.isWhitespace(string);
    }

    public static String toNull(String someValue) {
        if (XDSUtil.noValue(someValue)) {
            return null;
        }
        return someValue;
    }

    public static String getChildText(Element someElement) {
        someElement.normalize();
        NodeList childNodes = someElement.getChildNodes();
        for (int n = 0; n < childNodes.getLength(); ++n) {
            short nodeType = childNodes.item(n).getNodeType();
            if (nodeType != 3) continue;
            Text textNode = (Text)childNodes.item(n);
            return XDSUtil.toNull(textNode.getData());
        }
        return null;
    }

    public static final boolean isNullOrEmpty(NodeList list) {
        return list == null || list.getLength() == 0;
    }

    public static final Node getFirst(NodeList list) {
        if (XDSUtil.isNullOrEmpty(list)) {
            return null;
        }
        return list.item(0);
    }

    public static void getChildElements(Element parent, List elements) {
        XDSUtil.getChildNodes(parent, 1, elements);
    }

    public static void getChildTextNodes(Element parent, List textNodes) {
        XDSUtil.getChildNodes(parent, 3, textNodes);
    }

    public static void getChildNodes(Element parent, int nodeType, List nodes) {
        nodes.clear();
        NodeList childNodes = parent.getChildNodes();
        if (childNodes.getLength() > 0) {
            for (int n = 0; n < childNodes.getLength(); ++n) {
                Node child = childNodes.item(n);
                if (child.getNodeType() != nodeType) continue;
                nodes.add(child);
            }
        }
    }

    public static final void checkArg(String argName, Object argValue, int position) {
        if (argValue == null) {
            throw new IllegalArgumentException(Errors.noParamValue(argName, position));
        }
    }

    public static final void checkArg(String argName, String argValue, int position) {
        if (XDSUtil.noValue(argValue)) {
            throw new IllegalArgumentException(Errors.noParamValue(argName, position));
        }
    }

    public static final String getRDN(String slashSrcDN) {
        if (slashSrcDN == null) {
            return null;
        }
        int lastSlash = slashSrcDN.lastIndexOf("\\");
        String rdn = lastSlash == -1 ? slashSrcDN : slashSrcDN.substring(lastSlash + 1, slashSrcDN.length());
        return "".compareTo(rdn) == 0 ? null : rdn;
    }

    public static boolean isNullOrEmpty(XmlDocument xml) {
        return xml == null || xml.getDocument() == null || xml.getDocument().getDocumentElement() == null;
    }

    static {
        CHILD_ELEMENTS_OF_IN_OUT.add("add");
        CHILD_ELEMENTS_OF_IN_OUT.add("modify");
        CHILD_ELEMENTS_OF_IN_OUT.add("delete");
        CHILD_ELEMENTS_OF_IN_OUT.add("rename");
        CHILD_ELEMENTS_OF_IN_OUT.add("move");
        CHILD_ELEMENTS_OF_IN_OUT.add("query");
        CHILD_ELEMENTS_OF_IN_OUT.add("query-ex");
        CHILD_ELEMENTS_OF_IN_OUT.add("add-association");
        CHILD_ELEMENTS_OF_IN_OUT.add("modify-association");
        CHILD_ELEMENTS_OF_IN_OUT.add("remove-association");
        CHILD_ELEMENTS_OF_IN_OUT.add("status");
        CHILD_ELEMENTS_OF_IN_OUT.add("check-object-password");
        CHILD_ELEMENTS_OF_IN_OUT.add("modify-password");
        CHILD_ELEMENTS_OF_IN_OUT.add("instance");
        CHILD_ELEMENTS_OF_IN_OUT.add("password");
        CHILD_ELEMENTS_OF_IN_OUT.add("query-token");
        CHILD_ELEMENTS_OF_IN_OUT.add("get-named-password");
        CHILD_ELEMENTS_OF_IN_OUT.add("sync");
        CHILD_ELEMENTS_OF_IN_OUT.add("check-password");
    }
}

