/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ASN1BitString
implements ASN1TaggedObject {
    private ASN1Header header;
    private byte[] value;
    private int unused;

    public ASN1BitString() {
        this(new byte[0], 0);
    }

    public ASN1BitString(int n) {
        int n2 = n == 0 ? 0 : (n - 1) / 8 + 1;
        this.initialize(new byte[n2], 8 * n2 - n);
    }

    public ASN1BitString(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1BitString(BigInteger bigInteger) {
        this(bigInteger.bitLength());
        int n = this.bitLength();
        int n2 = 0;
        while (n2 < n) {
            if (bigInteger.testBit(n2)) {
                this.setBit(n2);
            }
            ++n2;
        }
    }

    public ASN1BitString(byte[] byArray) {
        this.initialize(byArray, 0);
    }

    public ASN1BitString(byte[] byArray, int n) {
        this.initialize(byArray, n);
    }

    public int bitLength() {
        return 8 * this.value.length - this.unused;
    }

    public void clearBit(int n) {
        if (n < 0 || n >= 8 * this.value.length - this.unused) {
            throw new ArithmeticException("Bit index out of bounds");
        }
        int n2 = n / 8;
        this.value[n2] = (byte)(this.value[n2] & ~(1 << 7 - n % 8));
    }

    public ASN1Header getHeader() {
        return this.header;
    }

    public int getUnused() {
        return this.unused;
    }

    public byte[] getValue() {
        return this.value;
    }

    private void initialize(byte[] byArray, int n) {
        if (byArray.length == 0) {
            n = 0;
        }
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException();
        }
        this.value = byArray;
        this.unused = n;
        this.header = new ASN1Header(3, 0, 0, byArray.length + 1);
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(3);
        if (aSN1Header.getEncodingMethod() == 0) {
            if (aSN1Header.getBodyLength() == 0) {
                throw new ASN1FormatException("Body is empty.");
            }
            this.unused = Utils.inputByte(inputStream) & 7;
            this.initialize(Utils.inputBytes(inputStream, aSN1Header.getBodyLength() - 1), this.unused);
        } else {
            int n = 0;
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
            while (aSN1ConstructedInputStream.hasMoreData()) {
                ASN1BitString aSN1BitString = new ASN1BitString(aSN1ConstructedInputStream);
                if (n != 0) {
                    throw new ASN1FormatException("Illegal encoding of bit-string.");
                }
                unsyncByteArrayOutputStream.write(aSN1BitString.getValue());
                n = aSN1BitString.getUnused();
            }
            aSN1ConstructedInputStream.terminate();
            this.initialize(unsyncByteArrayOutputStream.toByteArray(), n);
        }
    }

    public static byte[] inputValue(InputStream inputStream) throws IOException {
        return new ASN1BitString(inputStream).getValue();
    }

    public int intValue() {
        if (this.value.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            if (n2 == this.value.length - 1) {
                n += (this.value[n2] & 0xFF & 255 << this.unused) << 8 * (3 - n2);
                break;
            }
            n += (this.value[n2] & 0xFF) << 8 * (3 - n2);
            ++n2;
        }
        int n3 = 0;
        int n4 = this.bitLength();
        int n5 = 0;
        while (n5 < n4) {
            n3 += (n & Integer.MIN_VALUE) != 0 ? 1 << n5 : 0;
            n <<= 1;
            ++n5;
        }
        return n3;
    }

    public int length() {
        return this.header.totalLength();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.header.output(outputStream);
        outputStream.write(this.unused);
        if (this.unused == 0) {
            outputStream.write(this.value);
        } else {
            outputStream.write(this.value, 0, this.value.length - 1);
            outputStream.write(this.value[this.value.length - 1] & 255 << this.unused & 0xFF);
        }
    }

    public static void outputValue(OutputStream outputStream, byte[] byArray) throws IOException {
        ASN1BitString.outputValueWithTag(outputStream, byArray, 3, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, byte[] byArray, int n) throws IOException {
        ASN1BitString.outputValueWithTag(outputStream, byArray, n, 128);
    }

    private static void outputValueWithTag(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, byArray.length + 1);
        outputStream.write(0);
        outputStream.write(byArray);
    }

    public void setBit(int n) {
        if (n < 0 || n >= 8 * this.value.length - this.unused) {
            throw new ArithmeticException("Bit index out of bounds");
        }
        int n2 = n / 8;
        this.value[n2] = (byte)(this.value[n2] | 1 << 7 - n % 8);
    }

    public boolean testBit(int n) {
        if (n < 0 || n >= 8 * this.value.length - this.unused) {
            throw new ArithmeticException("Bit index out of bounds");
        }
        return (this.value[n / 8] & 1 << 7 - n % 8) != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BIT STRING ");
        stringBuffer.append(Utils.toHexString(this.value));
        if (this.unused != 0) {
            stringBuffer.append("(" + this.unused + " unused)");
        }
        return stringBuffer.toString();
    }
}

