/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1TaggedObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1Boolean
implements ASN1TaggedObject {
    private ASN1Header header;
    private boolean value;

    public ASN1Boolean() {
        this(false);
    }

    public ASN1Boolean(InputStream inputStream) throws IOException {
        this.initialize(ASN1Boolean.inputValue(inputStream));
    }

    public ASN1Boolean(boolean bl) {
        this.initialize(bl);
    }

    public ASN1Header getHeader() {
        return this.header;
    }

    public boolean getValue() {
        return this.value;
    }

    private void initialize(boolean bl) {
        this.value = bl;
        this.header = new ASN1Header(1, 0, 0, 1);
    }

    public void input(InputStream inputStream) throws IOException {
        this.initialize(ASN1Boolean.inputValue(inputStream));
    }

    public static boolean inputValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(1);
        aSN1Header.checkEncodingMethod(0);
        byte[] byArray = aSN1Header.readBody(inputStream);
        return byArray[0] != 0;
    }

    public int length() {
        return this.header.totalLength();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.header.output(outputStream);
        ASN1Boolean.outputBody(outputStream, this.value);
    }

    private static void outputBody(OutputStream outputStream, boolean bl) throws IOException {
        outputStream.write(bl ? 255 : 0);
    }

    public static void outputValue(OutputStream outputStream, boolean bl) throws IOException {
        ASN1Boolean.outputValueWithTag(outputStream, bl, 1, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, boolean bl, int n) throws IOException {
        ASN1Boolean.outputValueWithTag(outputStream, bl, n, 128);
    }

    private static void outputValueWithTag(OutputStream outputStream, boolean bl, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        outputStream.write(1);
        ASN1Boolean.outputBody(outputStream, bl);
    }
}

