/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1Utils;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1ConstructedInputStream
extends FilterInputStream {
    private int bodyLength;
    private int bytesRead = 0;
    private int pushback = -1;

    public ASN1ConstructedInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        ASN1Header aSN1Header = new ASN1Header(this.in);
        aSN1Header.checkTagClass(128);
        if (aSN1Header.getEncodingMethod() == 0) {
            throw new ASN1FormatException("Constructed encoding expected");
        }
        this.initialize(aSN1Header);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, int n) throws IOException {
        this(inputStream, n, 128);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, int n, int n2) throws IOException {
        super(inputStream);
        ASN1Header aSN1Header = new ASN1Header(this.in);
        aSN1Header.checkTag(n);
        aSN1Header.checkTagClass(n2);
        if (aSN1Header.getEncodingMethod() == 0) {
            throw new ASN1FormatException("Constructed encoding expected");
        }
        this.initialize(aSN1Header);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, ASN1Header aSN1Header) {
        super(inputStream);
        this.initialize(aSN1Header);
    }

    public int available() throws IOException {
        return (this.pushback != -1 ? 1 : 0) + super.available();
    }

    public int getCurrentIDByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            return -1;
        }
        this.pushBack(n);
        return n;
    }

    public int getCurrentTag() throws IOException {
        int n = this.read();
        if (n == -1) {
            return -1;
        }
        this.pushBack(n);
        int n2 = n & 0x1F;
        return n2;
    }

    public boolean hasMoreData() throws IOException {
        if (this.bodyLength >= 0) {
            return this.bytesRead < this.bodyLength;
        }
        int n = this.read();
        if (n == -1) {
            throw new ASN1FormatException("End of input.");
        }
        this.unread(n);
        return n != 0;
    }

    private void initialize(ASN1Header aSN1Header) {
        this.bodyLength = aSN1Header.getBodyLength();
    }

    public boolean markSupported() {
        return false;
    }

    private void pushBack(int n) {
        if (this.pushback == -1) {
            this.pushback = n & 0xFF;
            --this.bytesRead;
        } else {
            throw new IllegalStateException("Pushback buffer is full.");
        }
    }

    public int read() throws IOException {
        if (this.pushback == -1) {
            if (this.bodyLength != -1 && this.bytesRead >= this.bodyLength) {
                return -1;
            }
            int n = super.read();
            if (n == -1) {
                throw new ASN1FormatException("End of input.");
            }
            ++this.bytesRead;
            return n;
        }
        int n = this.pushback;
        this.pushback = -1;
        ++this.bytesRead;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.bodyLength == -1 || this.bytesRead + n2 <= this.bodyLength) {
            int n3 = 0;
            if (this.pushback != -1) {
                byArray[n] = (byte)this.pushback;
                n3 = 1;
            }
            int n4 = n3 + super.read(byArray, n, n2 - n3);
            this.bytesRead += n4;
            return n4;
        }
        throw new ASN1FormatException("Contents length exceeded.");
    }

    public void setCurrentTag(int n) throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        this.pushBack((n2 & 0x20) + n);
    }

    public void terminate() throws IOException {
        this.terminate(false);
    }

    public void terminate(boolean bl) throws IOException {
        if (bl) {
            while (this.hasMoreData()) {
                ASN1Utils.inputASN1Object(this);
            }
        }
        if (this.bodyLength >= 0) {
            if (this.bytesRead < this.bodyLength) {
                throw new ASN1FormatException("End of constructed encoding expected.");
            }
        } else {
            if (this.read() != 0) {
                throw new ASN1FormatException("First end-of-contents octet expected.");
            }
            if (this.read() != 0) {
                throw new ASN1FormatException("Second end-of-contents octet expected.");
            }
        }
    }

    public void unread(int n) {
        this.pushBack(n);
    }
}

