/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Constructed;
import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ASN1GenericConstructed
implements ASN1TaggedObject,
ASN1Constructed {
    private Vector elements = new Vector();
    private int bodyLength = 0;
    private ASN1Header header = null;
    private int tag;
    private int tagClass;
    private int encodingType = 0;
    private ASN1Object[] sortedElements = null;

    public ASN1GenericConstructed(int n) {
        this(n, 128);
    }

    public ASN1GenericConstructed(int n, int n2) {
        this.tag = n;
        this.tagClass = n2;
    }

    public ASN1GenericConstructed(ASN1Object aSN1Object, int n) {
        this(aSN1Object, n, 128);
    }

    public ASN1GenericConstructed(ASN1Object aSN1Object, int n, int n2) {
        this(n, n2);
        this.addElement(aSN1Object);
    }

    public ASN1GenericConstructed(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1GenericConstructed(Vector vector, int n) {
        this(vector, n, 128);
    }

    public ASN1GenericConstructed(Vector vector, int n, int n2) {
        this(n, n2);
        this.elements = vector;
        this.bodyLength = 0;
        int n3 = 0;
        int n4 = this.elements.size();
        while (n3 < n4) {
            this.bodyLength += ((ASN1Object)this.elements.elementAt(n3)).length();
            ++n3;
        }
    }

    public ASN1GenericConstructed(byte[] byArray) throws IOException {
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public void addElement(ASN1Object aSN1Object) {
        this.elements.addElement(aSN1Object);
        this.bodyLength += aSN1Object.length();
        this.header = null;
        this.sortedElements = null;
    }

    public ASN1Object elementAt(int n) {
        return (ASN1Object)this.elements.elementAt(n);
    }

    public Vector elements() {
        return this.elements;
    }

    public ASN1Object firstElement() {
        return (ASN1Object)this.elements.firstElement();
    }

    public int getEncodingType() {
        return this.encodingType;
    }

    public ASN1Header getHeader() {
        if (this.header == null) {
            this.header = new ASN1Header(this.tag, this.tagClass, 1, this.bodyLength);
        }
        return this.header;
    }

    private ASN1Object[] getSortedElements() {
        if (this.sortedElements == null) {
            this.sortedElements = ASN1Set.sortElements(this.elements, this.encodingType);
        }
        return this.sortedElements;
    }

    public int getTag() {
        return this.tag;
    }

    public int getTagClass() {
        return this.tagClass;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        if (aSN1Header.getEncodingMethod() == 0) {
            throw new ASN1FormatException("Constructed encoding expected.");
        }
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        this.tag = aSN1Header.getTag();
        this.tagClass = aSN1Header.getTagClass();
        this.elements = new Vector();
        this.bodyLength = 0;
        while (aSN1ConstructedInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1ConstructedInputStream);
            this.elements.addElement(aSN1Object);
            this.bodyLength += aSN1Object.length();
        }
        aSN1ConstructedInputStream.terminate();
        this.header = null;
        this.sortedElements = null;
    }

    public ASN1Object lastElement() {
        return (ASN1Object)this.elements.lastElement();
    }

    public int length() {
        return this.getHeader().totalLength();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        if (this.encodingType == 0) {
            int n = 0;
            int n2 = this.elements.size();
            while (n < n2) {
                ((ASN1Object)this.elements.elementAt(n)).output(outputStream);
                ++n;
            }
        } else {
            ASN1Object[] aSN1ObjectArray = this.getSortedElements();
            int n = 0;
            while (n < aSN1ObjectArray.length) {
                aSN1ObjectArray[n].output(outputStream);
                ++n;
            }
        }
    }

    public static void outputValue(OutputStream outputStream, Vector vector, int n) throws IOException {
        ASN1GenericConstructed.outputValue(outputStream, vector, n, 128);
    }

    public static void outputValue(OutputStream outputStream, Vector vector, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        int n5 = vector.size();
        while (n4 < n5) {
            n3 += ((ASN1Object)vector.elementAt(n4)).length();
            ++n4;
        }
        outputStream.write(32 + n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, n3);
        int n6 = 0;
        int n7 = vector.size();
        while (n6 < n7) {
            ((ASN1Object)vector.elementAt(n6)).output(outputStream);
            ++n6;
        }
    }

    public void setEncodingType(int n) {
        this.encodingType = n;
    }

    public int size() {
        return this.elements.size();
    }

    public ASN1Sequence toSequence() {
        return new ASN1Sequence(this.elements);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GENERIC CONSTRUCTED [");
        switch (this.tagClass) {
            case 0: {
                stringBuffer.append("UNIVERSAL");
                break;
            }
            case 64: {
                stringBuffer.append("APPLICATION");
                break;
            }
            case 128: {
                stringBuffer.append("CONTEXT SPECIFIC");
                break;
            }
            case 192: {
                stringBuffer.append("PRIVATE");
                break;
            }
            default: {
                stringBuffer.append(this.tagClass);
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.tag);
        stringBuffer.append("] ");
        stringBuffer.append(Utils.toString(this.elements));
        return stringBuffer.toString();
    }
}

