/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ASN1Integer
implements ASN1TaggedObject {
    private ASN1Header header;
    private BigInteger value;

    public ASN1Integer(long l) {
        this(BigInteger.valueOf(l));
    }

    public ASN1Integer(InputStream inputStream) throws IOException {
        this.initialize(ASN1Integer.inputValue(inputStream));
    }

    public ASN1Integer(BigInteger bigInteger) {
        this.initialize(bigInteger);
    }

    private static int bodyLength(BigInteger bigInteger) {
        return bigInteger.bitLength() / 8 + 1;
    }

    public boolean equals(int n) {
        if (this.value.bitLength() > 31) {
            return false;
        }
        return this.value.intValue() == n;
    }

    public ASN1Header getHeader() {
        return this.header;
    }

    public BigInteger getValue() {
        return this.value;
    }

    private void initialize(BigInteger bigInteger) {
        this.value = bigInteger;
        this.header = new ASN1Header(2, 0, 0, ASN1Integer.bodyLength(bigInteger));
    }

    public void input(InputStream inputStream) throws IOException {
        this.initialize(ASN1Integer.inputValue(inputStream));
    }

    public static BigInteger inputValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(2);
        aSN1Header.checkEncodingMethod(0);
        return new BigInteger(aSN1Header.readBody(inputStream));
    }

    public int intValue() {
        return this.value.intValue();
    }

    public int length() {
        return this.header.totalLength();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.header.output(outputStream);
        ASN1Integer.outputBody(outputStream, this.value);
    }

    private static void outputBody(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        outputStream.write(bigInteger.toByteArray());
    }

    public static void outputValue(OutputStream outputStream, int n) throws IOException {
        ASN1Integer.outputValue(outputStream, BigInteger.valueOf(n));
    }

    public static void outputValue(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        ASN1Integer.outputValueWithTag(outputStream, bigInteger, 2, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, BigInteger bigInteger, int n) throws IOException {
        ASN1Integer.outputValueWithTag(outputStream, bigInteger, n, 128);
    }

    private static void outputValueWithTag(OutputStream outputStream, BigInteger bigInteger, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, ASN1Integer.bodyLength(bigInteger));
        ASN1Integer.outputBody(outputStream, bigInteger);
    }

    public String toString() {
        return "INTEGER " + this.value.toString();
    }
}

