/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.InvalidFormatException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class ASN1ObjectID
implements ASN1TaggedObject {
    private ASN1Header header;
    private int[] value;
    private byte[] encoded;
    private int hash;

    public ASN1ObjectID(ASN1ObjectID aSN1ObjectID, int n) {
        this(aSN1ObjectID.getValue(), n);
    }

    public ASN1ObjectID(ASN1ObjectID aSN1ObjectID, int[] nArray) {
        this(aSN1ObjectID.getValue(), nArray);
    }

    public ASN1ObjectID(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1ObjectID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        try {
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException(numberFormatException.toString());
        }
        this.initialize(nArray);
    }

    public ASN1ObjectID(int[] nArray) {
        this.initialize(nArray);
    }

    public ASN1ObjectID(int[] nArray, int n) {
        this(nArray, new int[]{n});
    }

    public ASN1ObjectID(int[] nArray, int n, int n2) {
        this(nArray, new int[]{n, n2});
    }

    public ASN1ObjectID(int[] nArray, int n, int n2, int n3) {
        this(nArray, new int[]{n, n2, n3});
    }

    public ASN1ObjectID(int[] nArray, int n, int n2, int n3, int n4) {
        this(nArray, new int[]{n, n2, n3, n4});
    }

    public ASN1ObjectID(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        this.initialize(nArray3);
    }

    private static int bodyLength(int[] nArray) {
        int n = 1;
        int n2 = 2;
        int n3 = nArray.length;
        while (n2 < n3) {
            n += ASN1Utils.lengthBase128(nArray[n2]);
            ++n2;
        }
        return n;
    }

    private static int[] decodeValue(byte[] byArray) throws IOException {
        int[] nArray;
        int[] nArray2 = new int[10];
        int n = 0;
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
        int n2 = Utils.inputByte(unsyncByteArrayInputStream) & 0xFF;
        if (n2 < 80) {
            nArray2[n++] = n2 / 40;
            nArray2[n++] = n2 % 40;
        } else {
            nArray2[n++] = 2;
            nArray2[n++] = n2 - 80;
        }
        while (unsyncByteArrayInputStream.available() > 0) {
            if (n >= nArray2.length) {
                nArray = new int[2 * nArray2.length];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray2 = nArray;
            }
            nArray2[n++] = ASN1Utils.inputBase128(unsyncByteArrayInputStream);
        }
        if (n < nArray2.length) {
            nArray = new int[n];
            System.arraycopy(nArray2, 0, nArray, 0, n);
            nArray2 = nArray;
        }
        return nArray2;
    }

    private static byte[] encodeValue(int[] nArray) {
        byte[] byArray = new byte[ASN1ObjectID.bodyLength(nArray)];
        byArray[0] = (byte)(40 * nArray[0] + nArray[1]);
        int n = 1;
        int n2 = 2;
        int n3 = nArray.length;
        while (n2 < n3) {
            byte[] byArray2 = ASN1Utils.toBytesBase128(nArray[n2]);
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
            ++n2;
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Utils.areEqual(this.encoded, ((ASN1ObjectID)object).getEncodedValue());
    }

    public boolean equals(int[] nArray, int n) {
        return this.equals(nArray, new int[]{n});
    }

    public boolean equals(int[] nArray, int n, int n2) {
        return this.equals(nArray, new int[]{n, n2});
    }

    public boolean equals(int[] nArray, int n, int n2, int n3) {
        return this.equals(nArray, new int[]{n, n2, n3});
    }

    public boolean equals(int[] nArray, int n, int n2, int n3, int n4) {
        return this.equals(nArray, new int[]{n, n2, n3, n4});
    }

    public boolean equals(int[] nArray, int[] nArray2) {
        return this.equals(new ASN1ObjectID(nArray, nArray2));
    }

    public byte[] getEncodedValue() {
        return this.encoded;
    }

    public ASN1Header getHeader() {
        return this.header;
    }

    public int[] getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = new String(this.encoded).hashCode();
        }
        return this.hash;
    }

    private void initialize(int[] nArray) {
        this.value = nArray;
        this.encoded = ASN1ObjectID.encodeValue(nArray);
        this.header = new ASN1Header(6, 0, 0, this.encoded.length);
        this.hash = -1;
    }

    public void input(InputStream inputStream) throws IOException {
        this.initialize(ASN1ObjectID.inputValue(inputStream));
    }

    private static byte[] inputEncoded(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(6);
        aSN1Header.checkEncodingMethod(0);
        return aSN1Header.readBody(inputStream);
    }

    public static int[] inputValue(InputStream inputStream) throws IOException {
        return ASN1ObjectID.decodeValue(ASN1ObjectID.inputEncoded(inputStream));
    }

    public int length() {
        return this.header.totalLength();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.header.output(outputStream);
        ASN1ObjectID.outputBody(outputStream, this.getValue());
    }

    private static void outputBody(OutputStream outputStream, int[] nArray) throws IOException {
        outputStream.write(40 * nArray[0] + nArray[1]);
        int n = 2;
        int n2 = nArray.length;
        while (n < n2) {
            ASN1Utils.outputBase128(nArray[n], outputStream);
            ++n;
        }
    }

    public static void outputValue(OutputStream outputStream, int[] nArray) throws IOException {
        ASN1ObjectID.outputValueWithTag(outputStream, nArray, 6, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, int[] nArray, int n) throws IOException {
        ASN1ObjectID.outputValueWithTag(outputStream, nArray, n, 128);
    }

    private static void outputValueWithTag(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, ASN1ObjectID.bodyLength(nArray));
        ASN1ObjectID.outputBody(outputStream, nArray);
    }

    public int[] suffix(int[] nArray) {
        int[] nArray2 = this.getValue();
        if (ASN1Utils.isPrefix(nArray, nArray2)) {
            int[] nArray3 = new int[nArray2.length - nArray.length];
            System.arraycopy(nArray2, nArray.length, nArray3, 0, nArray3.length);
            return nArray3;
        }
        return null;
    }

    public String toString() {
        int[] nArray = this.getValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OBJECT IDENTIFIER {");
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            stringBuffer.append(nArray[n]);
            if (n < n2 - 1) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toStringCompact() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.value.length;
        while (n < n2) {
            if (n > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(this.value[n]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

