/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1Date;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.RevokedCertificate;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.cert.X509Attributes;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509ExtensionSet;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.OutputGenerationException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CRL
implements ASN1Object {
    private ASN1Sequence tbsCertList = null;
    private AlgorithmIdentifier sigAlgID = null;
    private byte[] sigBytes = null;
    private X500Name issuer;
    private Date thisUpdate = new Date();
    private Date nextUpdate = null;
    private Hashtable revokedCertificates = null;
    private Vector serialNo = null;
    private X509ExtensionSet extensions = null;
    private PrivateKey privKey;
    private PublicKey pubKey;
    private X509 issuerCert;
    private ASN1Sequence contents = null;

    public CRL() {
    }

    public CRL(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public CRL(X500Name x500Name, PrivateKey privateKey) {
        this.setIssuer(x500Name);
        this.setPrivateKey(privateKey);
    }

    public CRL(X500Name x500Name, PrivateKey privateKey, int n) {
        this(x500Name, privateKey);
        if (n > 0) {
            this.setDates(n);
        }
    }

    public CRL(X500Name x500Name, PrivateKey privateKey, Date date, Date date2, Vector vector) {
        this(x500Name, privateKey);
        this.setDates(date, date2);
        this.setRevokedCertificates(vector);
    }

    public CRL(X509 x509) {
        this.setIssuer(x509.getSubject());
        this.setPublicKey(x509.getPublicKey());
    }

    public CRL(X509 x509, ASN1Sequence aSN1Sequence) throws IOException {
        this(x509);
        this.input(aSN1Sequence);
    }

    public CRL(X509 x509, File file) throws FileNotFoundException, IOException {
        this(x509);
        FileInputStream fileInputStream = new FileInputStream(file);
        this.input(fileInputStream);
        fileInputStream.close();
    }

    public CRL(X509 x509, InputStream inputStream) throws IOException {
        this(x509);
        this.input(inputStream);
    }

    public CRL(X509 x509, URL uRL) throws IOException {
        this(x509);
        InputStream inputStream = uRL.openStream();
        this.input(inputStream);
        inputStream.close();
    }

    public CRL(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public CRL(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public CRL(URL uRL) throws IOException {
        this(uRL.openStream());
    }

    public void addCertificate(RevokedCertificate revokedCertificate) {
        if (this.revokedCertificates == null) {
            this.revokedCertificates = new Hashtable();
            this.serialNo = new Vector();
        }
        if (this.revokedCertificates.put(revokedCertificate.getSerialNo(), revokedCertificate) != null) {
            this.serialNo.removeElement(revokedCertificate.getSerialNo());
        }
        this.serialNo.addElement(revokedCertificate.getSerialNo());
        this.reset();
    }

    public void addCertificate(BigInteger bigInteger) {
        this.addCertificate(bigInteger, new Date());
    }

    public void addCertificate(BigInteger bigInteger, Date date) {
        this.addCertificate(new RevokedCertificate(bigInteger, date));
    }

    public void addExtension(X509Extension x509Extension) {
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(x509Extension);
        this.reset();
    }

    private boolean equals(CRL cRL) {
        return Utils.areEqual(Utils.toBytes(this), Utils.toBytes(cRL));
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof CRL) {
            return this.equals((CRL)object);
        }
        return false;
    }

    public Date getDate() {
        return this.thisUpdate;
    }

    public byte[] getEncoded() {
        try {
            return Utils.toBytes(this.toASN1Sequence());
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        return this.extensions != null ? this.extensions.getExtension(aSN1ObjectID) : null;
    }

    public X509ExtensionSet getExtensionSet() {
        return this.extensions;
    }

    public Vector getExtensions() {
        return this.extensions != null ? this.extensions.getExtensions() : null;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Date getNextDate() {
        return this.nextUpdate;
    }

    public RevokedCertificate getRevokedCertificate(BigInteger bigInteger) {
        return this.revokedCertificates != null ? (RevokedCertificate)this.revokedCertificates.get(bigInteger) : null;
    }

    public Vector getRevokedCertificates() {
        Vector vector = null;
        if (this.revokedCertificates != null) {
            vector = new Vector();
            Enumeration enumeration = this.serialNo.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(this.revokedCertificates.get(enumeration.nextElement()));
            }
        }
        return vector;
    }

    public byte[] getSigBytes() throws SignatureException {
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    private ASN1Sequence getTBSCertList() {
        if (this.tbsCertList == null) {
            Object object;
            Object object2;
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.extensions != null && this.extensions.size() > 0) {
                aSN1Sequence.addElement(new ASN1Integer(1L));
            } else if (this.revokedCertificates != null && this.revokedCertificates.size() > 0) {
                object2 = this.serialNo.elements();
                while (object2.hasMoreElements()) {
                    object = (RevokedCertificate)this.revokedCertificates.get(object2.nextElement());
                    if (((RevokedCertificate)object).getExtensions() == null || ((RevokedCertificate)object).getExtensions().size() <= 0) continue;
                    aSN1Sequence.addElement(new ASN1Integer(1L));
                    break;
                }
            }
            if (this.sigAlgID == null) {
                try {
                    this.sigAlgID = Signature.getInstance(this.privKey).getAlgID();
                }
                catch (SignatureException signatureException) {
                    throw new IllegalStateException(signatureException.toString());
                }
                catch (NullPointerException nullPointerException) {
                    throw new IllegalStateException("Issuer signing key must be set befor output");
                }
            }
            aSN1Sequence.addElement(this.sigAlgID);
            aSN1Sequence.addElement(this.issuer);
            object2 = Calendar.getInstance();
            ((Calendar)object2).setTime(this.thisUpdate);
            aSN1Sequence.addElement(new ASN1Date(this.thisUpdate, ((Calendar)object2).get(1) > 2049));
            if (this.nextUpdate != null) {
                object = Calendar.getInstance();
                ((Calendar)object).setTime(this.nextUpdate);
                aSN1Sequence.addElement(new ASN1Date(this.nextUpdate, ((Calendar)object).get(1) > 2049));
            }
            if (this.revokedCertificates != null && this.revokedCertificates.size() > 0) {
                object = new ASN1Sequence();
                Enumeration enumeration = this.serialNo.elements();
                while (enumeration.hasMoreElements()) {
                    ((ASN1Sequence)object).addElement((RevokedCertificate)this.revokedCertificates.get(enumeration.nextElement()));
                }
                aSN1Sequence.addElement((ASN1Object)object);
            }
            if (this.extensions != null && this.extensions.size() > 0) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.extensions, 0));
            }
            this.tbsCertList = aSN1Sequence;
        }
        return this.tbsCertList;
    }

    public boolean hasUnrecognizedCriticalExtension() {
        if (this.extensions != null && this.extensions.hasUnrecognizedCriticalExtension()) {
            return true;
        }
        if (this.revokedCertificates != null) {
            Enumeration enumeration = this.revokedSerialNos();
            while (enumeration.hasMoreElements()) {
                RevokedCertificate revokedCertificate = this.getRevokedCertificate((BigInteger)enumeration.nextElement());
                if (revokedCertificate == null || !revokedCertificate.getExtensionSet().hasUnrecognizedCriticalExtension()) continue;
                return true;
            }
        }
        return false;
    }

    private void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1ConstructedInputStream aSN1ConstructedInputStream;
        Object object;
        this.reset();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.tbsCertList = new ASN1Sequence(aSN1SequenceInputStream);
        this.sigAlgID = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.sigBytes = ASN1BitString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(Utils.toStream(this.tbsCertList));
        if (aSN1SequenceInputStream2.getCurrentTag() == 2) {
            object = ASN1Integer.inputValue(aSN1SequenceInputStream2);
        }
        if (!((AlgorithmIdentifier)(object = new AlgorithmIdentifier(aSN1SequenceInputStream2))).equals(this.sigAlgID)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        X500Name x500Name = new X500Name(aSN1SequenceInputStream2);
        if (this.issuer == null) {
            this.issuer = x500Name;
        } else if (!this.issuer.equals(x500Name)) {
            throw new IOException("Expected issuer {" + this.issuer + "}, got issuer {" + x500Name + "}");
        }
        this.thisUpdate = ASN1Date.inputValue(aSN1SequenceInputStream2);
        this.nextUpdate = aSN1SequenceInputStream2.getCurrentTag() == 23 || aSN1SequenceInputStream2.getCurrentTag() == 24 ? ASN1Date.inputValue(aSN1SequenceInputStream2) : null;
        if (aSN1SequenceInputStream2.getCurrentTag() == 16) {
            aSN1ConstructedInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
            this.revokedCertificates = new Hashtable();
            this.serialNo = new Vector();
            while (aSN1ConstructedInputStream.hasMoreData()) {
                RevokedCertificate revokedCertificate = new RevokedCertificate(aSN1ConstructedInputStream);
                if (this.revokedCertificates.put(revokedCertificate.getSerialNo(), revokedCertificate) != null) {
                    this.serialNo.removeElement(revokedCertificate.getSerialNo());
                }
                this.serialNo.addElement(revokedCertificate.getSerialNo());
            }
            aSN1ConstructedInputStream.terminate();
        } else {
            this.revokedCertificates = null;
            this.serialNo = null;
        }
        if (aSN1SequenceInputStream2.getCurrentTag() == 0) {
            aSN1ConstructedInputStream = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            this.extensions = new X509ExtensionSet(aSN1ConstructedInputStream);
            aSN1ConstructedInputStream.terminate();
        } else {
            this.extensions = null;
        }
        aSN1SequenceInputStream2.terminate();
    }

    public boolean isRevoked(BigInteger bigInteger) {
        return this.getRevokedCertificate(bigInteger) != null;
    }

    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        try {
            this.toASN1Sequence().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException.toString());
        }
    }

    public ASN1Sequence outputASN1() throws IOException {
        try {
            return this.toASN1Sequence();
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException.toString());
        }
    }

    private void reset() {
        this.resetContents();
        this.tbsCertList = null;
        this.sigBytes = null;
    }

    private void resetContents() {
        this.contents = null;
    }

    public Date revocationDate(BigInteger bigInteger) {
        RevokedCertificate revokedCertificate = this.getRevokedCertificate(bigInteger);
        return revokedCertificate != null ? revokedCertificate.getRevocationDate() : null;
    }

    public Enumeration revokedSerialNos() {
        return this.serialNo != null ? this.serialNo.elements() : new Vector().elements();
    }

    public void setAttributes(X509Attributes x509Attributes) {
        X509ExtensionSet x509ExtensionSet = this.extensions;
        X509ExtensionSet x509ExtensionSet2 = X509Attributes.toExtensionSet(x509Attributes);
        if (x509ExtensionSet != null) {
            Vector vector = x509ExtensionSet.getExtensions();
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                x509ExtensionSet2.addExtension((X509Extension)vector.elementAt(n));
                ++n;
            }
        }
        this.setExtensions(x509ExtensionSet2);
    }

    public void setDate(Date date) {
        this.thisUpdate = date;
        this.reset();
    }

    public void setDates(int n) {
        this.setDates(new Date(), Utils.daysFromNow(n));
    }

    public void setDates(Date date, Date date2) {
        this.thisUpdate = date;
        this.nextUpdate = date2;
        this.reset();
    }

    public void setExtensions(X509ExtensionSet x509ExtensionSet) {
        this.extensions = x509ExtensionSet;
        this.reset();
    }

    public void setExtensions(Vector vector) {
        this.setExtensions(new X509ExtensionSet(vector));
    }

    public void setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
        this.reset();
    }

    public void setIssuerCertificate(X509 x509) {
        this.issuerCert = x509;
        if (this.issuer == null) {
            this.issuer = x509.getSubject();
        }
        this.setPublicKey(x509.getPublicKey());
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.setPrivateKey(privateKey, null);
    }

    public void setPrivateKey(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.privKey = privateKey;
        this.setSigAlgID(algorithmIdentifier);
    }

    public void setPublicKey(PublicKey publicKey) {
        this.pubKey = publicKey;
    }

    public void setRevokedCertificates(Vector vector) {
        if (vector != null && vector.size() > 0) {
            this.revokedCertificates = new Hashtable();
            this.serialNo = new Vector();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RevokedCertificate revokedCertificate = (RevokedCertificate)enumeration.nextElement();
                if (this.revokedCertificates.put(revokedCertificate.getSerialNo(), revokedCertificate) != null) {
                    this.serialNo.removeElement(revokedCertificate.getSerialNo());
                }
                this.serialNo.addElement(revokedCertificate.getSerialNo());
            }
            this.reset();
        }
    }

    public void setSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.sigAlgID = algorithmIdentifier;
        this.reset();
    }

    public void sign() throws SignatureException {
        this.sign(RandomBitsSource.getDefault());
    }

    public void sign(RandomBitsSource randomBitsSource) throws SignatureException {
        ASN1Sequence aSN1Sequence = this.getTBSCertList();
        try {
            try {
                Signature signature = Signature.getInstance(this.sigAlgID);
                signature.setPrivateKey(this.privKey);
                signature.setRandomBitsSource(randomBitsSource);
                signature.setDocument(Utils.toBytes(aSN1Sequence));
                this.sigBytes = signature.sign();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new SignatureException(algorithmIdentifierException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SignatureException(invalidKeyException.toString());
            }
            Object var4_6 = null;
            this.resetContents();
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.resetContents();
            throw throwable;
        }
    }

    private ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.getTBSCertList());
            aSN1Sequence.addElement(this.sigAlgID);
            aSN1Sequence.addElement(new ASN1BitString(this.getSigBytes()));
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    public String toString() {
        String string = "issuer = " + this.issuer + ", thisUpdate = " + this.thisUpdate;
        if (this.nextUpdate != null) {
            string = String.valueOf(string) + ", nextUpdate = " + this.nextUpdate;
        }
        string = String.valueOf(string) + ", revokedCertificates = {";
        Enumeration enumeration = this.serialNo.elements();
        while (enumeration.hasMoreElements()) {
            RevokedCertificate revokedCertificate = (RevokedCertificate)this.revokedCertificates.get(enumeration.nextElement());
            string = String.valueOf(string) + "(" + revokedCertificate + ")";
            if (!enumeration.hasMoreElements()) continue;
            string = String.valueOf(string) + ", ";
        }
        string = String.valueOf(string) + "}";
        if (this.extensions != null && this.extensions.size() > 0) {
            string = String.valueOf(string) + ", extensions = " + this.extensions;
        }
        return string;
    }

    public boolean verify() throws AuthenticationException {
        if (this.hasUnrecognizedCriticalExtension()) {
            return false;
        }
        if (!this.verifyDate()) {
            return false;
        }
        return this.verifySignature();
    }

    public boolean verifyDate() {
        Date date = new Date();
        if (date.before(this.thisUpdate)) {
            return false;
        }
        return this.nextUpdate == null || !date.after(this.nextUpdate);
    }

    public boolean verifySignature() throws AuthenticationException {
        try {
            return CryptoUtils.verifySignedASN1(this.toASN1Sequence(), this.pubKey);
        }
        catch (SignatureException signatureException) {
            throw new AuthenticationException(signatureException.toString());
        }
    }
}

