/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.GeneralName;
import com.phaos.cert.X500RDN;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Vector;

public class CRLDistPointName
implements ASN1Object {
    private Vector fullName;
    private X500RDN relativeName;
    private transient ASN1Object contents;

    public CRLDistPointName(GeneralName generalName) {
        this.fullName = new Vector();
        this.fullName.addElement(generalName);
    }

    public CRLDistPointName(X500RDN x500RDN) {
        this.relativeName = x500RDN;
    }

    public CRLDistPointName(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public CRLDistPointName(Vector vector) {
        this.fullName = vector;
    }

    public void addGeneralName(GeneralName generalName) {
        if (this.fullName == null) {
            this.fullName = new Vector();
        }
        this.fullName.addElement(generalName);
    }

    public Vector getFullName() {
        return this.fullName;
    }

    public X500RDN getRelativeName() {
        return this.relativeName;
    }

    public void input(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        int n2 = ASN1Utils.getTag(n);
        if (n2 == 0) {
            pushbackInputStream.unread((n & 0x20) + 16);
            if (this.fullName == null) {
                this.fullName = new Vector();
            } else {
                this.fullName.removeAllElements();
            }
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(pushbackInputStream);
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.fullName.addElement(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            this.relativeName = null;
        } else if (n2 == 1) {
            pushbackInputStream.unread((n & 0x20) + 17);
            this.fullName = null;
            this.relativeName = new X500RDN(pushbackInputStream);
        }
        if ((this.fullName == null || this.fullName.size() == 0) && this.relativeName == null) {
            throw new ASN1FormatException("No name elements found in CRLDistPointName");
        }
    }

    public int length() {
        return this.toASN1().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1().output(outputStream);
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            this.contents = this.fullName != null ? new ASN1GenericConstructed(this.fullName, 0) : ASN1Utils.addImplicitTag(this.relativeName, 1);
        }
        return this.contents;
    }
}

