/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.Attribute;
import com.phaos.cert.AttributeSet;
import com.phaos.cert.PKIX;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509ExtensionSet;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.OutputGenerationException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CertificateRequest
implements ASN1Object {
    private X500Name subject;
    private PublicKey pubKey;
    private AttributeSet attributes;
    private ASN1Sequence certReqInfo;
    private PrivateKey privKey;
    private AlgorithmIdentifier sigAlgID;
    private byte[] sigBytes;
    private boolean useWrongFormat;
    private ASN1Sequence contents = null;

    public CertificateRequest() {
    }

    public CertificateRequest(X500Name x500Name, KeyPair keyPair) {
        this(x500Name, keyPair, false);
    }

    public CertificateRequest(X500Name x500Name, KeyPair keyPair, boolean bl) {
        this.subject = x500Name;
        this.pubKey = keyPair.getPublic();
        this.privKey = keyPair.getPrivate();
        this.useWrongFormat = bl;
    }

    public CertificateRequest(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public CertificateRequest(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public Attribute addAttribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        return this.addAttribute(new Attribute(aSN1ObjectID, aSN1Object));
    }

    public Attribute addAttribute(Attribute attribute) {
        this.resetAll();
        if (this.attributes == null) {
            this.attributes = new AttributeSet();
        }
        return this.attributes.addAttribute(attribute);
    }

    public X509Extension addExtension(X509Extension x509Extension) {
        X509ExtensionSet x509ExtensionSet = this.getExtensions();
        if (x509ExtensionSet == null) {
            x509ExtensionSet = new X509ExtensionSet();
        }
        X509Extension x509Extension2 = x509ExtensionSet.getExtension(x509Extension.getType());
        x509ExtensionSet.addExtension(x509Extension);
        this.setExtensions(x509ExtensionSet);
        return x509Extension2;
    }

    public Attribute getAttribute(ASN1ObjectID aSN1ObjectID) {
        return this.attributes != null ? this.attributes.getAttribute(aSN1ObjectID) : null;
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    private ASN1Sequence getCertReqInfo() {
        if (this.certReqInfo == null) {
            this.certReqInfo = new ASN1Sequence();
            this.certReqInfo.addElement(new ASN1Integer(0L));
            this.certReqInfo.addElement(this.subject);
            this.certReqInfo.addElement(CryptoUtils.subjectPublicKeyInfo(this.pubKey));
            if (this.attributes != null) {
                this.certReqInfo.addElement(new ASN1GenericConstructed(this.attributes.toASN1Set().elements(), 0));
            } else if (!this.useWrongFormat) {
                this.certReqInfo.addElement(new ASN1GenericConstructed(new Vector(), 0));
            }
        }
        return this.certReqInfo;
    }

    public X509ExtensionSet getExtensions() {
        Attribute attribute = this.getAttribute(PKIX.extensionRequest);
        if (attribute != null) {
            try {
                return new X509ExtensionSet(Utils.toStream((ASN1Object)attribute.getValues().elementAt(0)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
        return null;
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public byte[] getSigBytes() throws SignatureException {
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public boolean getUseWrongFormat() {
        return this.useWrongFormat;
    }

    public void input(InputStream inputStream) throws IOException {
        this.resetAll();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.certReqInfo = new ASN1Sequence(aSN1SequenceInputStream);
        this.sigAlgID = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.sigBytes = ASN1BitString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(this.certReqInfo));
        int n = ASN1Integer.inputValue(aSN1SequenceInputStream).intValue();
        if (n != 0) {
            throw new ASN1FormatException("Expected version 0, got " + n);
        }
        this.subject = new X500Name(aSN1SequenceInputStream);
        this.pubKey = CryptoUtils.inputSPKI(aSN1SequenceInputStream);
        if (aSN1SequenceInputStream.hasMoreData()) {
            if (aSN1SequenceInputStream.getCurrentTag() == 0) {
                aSN1SequenceInputStream.setCurrentTag(17);
                this.attributes = new AttributeSet(aSN1SequenceInputStream);
            } else {
                throw new ASN1FormatException("Expected tag 0, got " + aSN1SequenceInputStream.getCurrentTag());
            }
        }
        aSN1SequenceInputStream.terminate();
        try {
            this.verifySignature();
        }
        catch (AuthenticationException authenticationException) {
            throw new IOException(authenticationException.toString());
        }
    }

    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException signatureException) {
            return 0;
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        try {
            this.toASN1Sequence().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException.toString());
        }
    }

    private void reset() {
        this.contents = null;
    }

    private void resetAll() {
        this.reset();
        this.certReqInfo = null;
        this.sigBytes = null;
    }

    public X509ExtensionSet setExtensions(X509ExtensionSet x509ExtensionSet) {
        Attribute attribute = this.addAttribute(PKIX.extensionRequest, x509ExtensionSet);
        if (attribute != null) {
            try {
                return new X509ExtensionSet(Utils.toStream((ASN1Object)attribute.getValues().elementAt(0)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
        return null;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.setPrivateKey(privateKey, null);
    }

    public void setPrivateKey(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.privKey = privateKey;
        this.setSigAlgID(algorithmIdentifier);
    }

    public void setPublicKey(PublicKey publicKey) {
        this.pubKey = publicKey;
        this.resetAll();
    }

    public void setSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.sigAlgID = algorithmIdentifier;
        this.resetAll();
    }

    public void setSubject(X500Name x500Name) {
        this.subject = x500Name;
        this.resetAll();
    }

    public void setUseWrongFormat(boolean bl) {
        this.useWrongFormat = bl;
        this.resetAll();
    }

    public void sign() throws SignatureException {
        this.sign(RandomBitsSource.getDefault());
    }

    public void sign(RandomBitsSource randomBitsSource) throws SignatureException {
        this.getCertReqInfo();
        try {
            Signature signature = Signature.getInstance(this.privKey);
            if (this.sigAlgID != null) {
                signature.setAlgID(this.sigAlgID);
            } else {
                this.sigAlgID = signature.getAlgID();
            }
            signature.setRandomBitsSource(randomBitsSource);
            signature.setDocument(Utils.toBytes(this.certReqInfo));
            this.sigBytes = signature.sign();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
        this.reset();
    }

    ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            this.getSigBytes();
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.certReqInfo);
            aSN1Sequence.addElement(this.sigAlgID);
            aSN1Sequence.addElement(new ASN1BitString(this.sigBytes));
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    public String toString() {
        return "subject = " + this.subject + ", pubKey = " + this.pubKey;
    }

    public boolean verifySignature() throws AuthenticationException {
        try {
            Signature signature = Signature.getInstance(this.sigAlgID);
            signature.setPublicKey(this.pubKey);
            signature.setDocument(Utils.toBytes(this.certReqInfo));
            signature.setSigBytes(this.sigBytes);
            return signature.verify();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AuthenticationException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
    }
}

