/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import java.io.Serializable;
import java.util.Date;

public class CertificateStatus
implements Serializable {
    public static final int UNKNOWN = 0;
    public static final int VALID = 1;
    public static final int INVALID = 2;
    public static final int REVOKED = 3;
    public static final int EXPIRED = 4;
    public static final int ON_HOLD = 5;
    protected static final String[] statusCodeStrs = new String[]{"UNKNOWN", "VALID", "INVALID", "REVOKED", "EXPIRED", "ON_HOLD"};
    protected int statusCode = 0;
    protected String reason;
    protected Date revocationDate;

    public CertificateStatus() {
    }

    public CertificateStatus(int n) {
        this.statusCode = n;
    }

    public CertificateStatus(int n, String string) {
        this(n);
        this.reason = string;
    }

    public String getReason() {
        return this.reason;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusCodeString() {
        if (this.statusCode >= 0 && this.statusCode < statusCodeStrs.length) {
            return statusCodeStrs[this.statusCode];
        }
        return "UNKNOWN";
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public void setRevocationDate(Date date) {
        this.revocationDate = date;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    public void setStatusCode(String string) {
        int n = 0;
        int n2 = statusCodeStrs.length;
        while (n < n2) {
            if (string.equals(statusCodeStrs[n])) break;
            ++n;
        }
        this.statusCode = n >= statusCodeStrs.length ? 0 : n;
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + this.getStatusCodeString();
        if (this.reason != null && this.reason.length() > 0) {
            string = String.valueOf(string) + ", reason = " + this.reason;
        }
        if (this.revocationDate != null) {
            string = String.valueOf(string) + ", revocationDate = " + this.revocationDate;
        }
        return string;
    }
}

